/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.geotiff.internal;

import java.io.IOException;
import java.nio.ByteOrder;
import javax.imageio.stream.ImageOutputStream;
import org.esa.beam.dataio.geotiff.internal.TiffIFD;
import org.esa.beam.dataio.geotiff.internal.TiffLong;
import org.esa.beam.dataio.geotiff.internal.TiffShort;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.util.Guardian;

public class TiffHeader {
    public static final TiffShort MAGIC_NUMBER = new TiffShort(42);
    private static final TiffShort LITTLE_ENDIAN = new TiffShort(18761);
    private static final TiffShort BIG_ENDIAN = new TiffShort(19789);
    public static final TiffLong FIRST_IFD_OFFSET = new TiffLong(10L);
    private final TiffIFD[] ifds;
    private boolean bigEndianOrder = true;

    public TiffHeader(Product[] products) {
        Guardian.assertNotNull("products", products);
        Guardian.assertGreaterThan("products.length", products.length, 0L);
        this.ifds = new TiffIFD[products.length];
        int i = 0;
        while (i < products.length) {
            this.ifds[i] = new TiffIFD(products[i]);
            ++i;
        }
    }

    public void write(ImageOutputStream ios) throws IOException {
        if (this.bigEndianOrder) {
            ios.setByteOrder(ByteOrder.BIG_ENDIAN);
            BIG_ENDIAN.write(ios);
        } else {
            ios.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            LITTLE_ENDIAN.write(ios);
        }
        MAGIC_NUMBER.write(ios);
        FIRST_IFD_OFFSET.write(ios);
        long offset = FIRST_IFD_OFFSET.getValue();
        int i = 0;
        while (i < this.ifds.length) {
            TiffIFD ifd = this.ifds[i];
            long nextOffset = this.computeNextIfdOffset(i, offset, ifd);
            ifd.write(ios, offset, nextOffset);
            offset = nextOffset;
            ++i;
        }
    }

    public TiffIFD getIfdAt(int index) {
        Guardian.assertWithinRange("index", index, 0L, this.ifds.length - 1);
        return this.ifds[index];
    }

    public void setBigEndianOrder(boolean bigEndianOrder) {
        this.bigEndianOrder = bigEndianOrder;
    }

    private long computeNextIfdOffset(int i, long offset, TiffIFD ifd) {
        if (i < this.ifds.length - 1) {
            return offset + ifd.getRequiredEntireSize();
        }
        return 0L;
    }
}

