/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.geotiff.internal;

import java.io.IOException;
import javax.imageio.stream.ImageOutputStream;
import org.esa.beam.dataio.geotiff.internal.TiffLong;
import org.esa.beam.dataio.geotiff.internal.TiffShort;
import org.esa.beam.dataio.geotiff.internal.TiffType;
import org.esa.beam.dataio.geotiff.internal.TiffValue;

public class TiffDirectoryEntry {
    public static final short BYTES_PER_ENTRY = 12;
    private TiffShort tag;
    private TiffShort type;
    private TiffLong count;
    private TiffValue[] values;
    private TiffLong valuesOffset;

    public TiffDirectoryEntry(TiffShort tiffTag, TiffValue value) {
        this(tiffTag, new TiffValue[]{value});
    }

    public TiffDirectoryEntry(TiffShort tiffTag, TiffValue[] values) {
        this.type = TiffType.getType(values);
        this.tag = tiffTag;
        this.count = this.getCount(values);
        this.values = values;
    }

    public TiffShort getTag() {
        return this.tag;
    }

    public TiffLong getCount() {
        return this.count;
    }

    public TiffShort getType() {
        return this.type;
    }

    public TiffValue[] getValues() {
        return this.values;
    }

    public void write(ImageOutputStream ios) throws IOException {
        if (this.mustValuesBeReferenced() && this.valuesOffset == null) {
            throw new IllegalStateException("no value offset given");
        }
        this.tag.write(ios);
        this.type.write(ios);
        this.count.write(ios);
        if (this.valuesOffset == null) {
            this.writeValuesInsideEnty(ios);
        } else {
            this.writeValuesReferenced(ios);
        }
    }

    private void writeValuesInsideEnty(ImageOutputStream ios) throws IOException {
        this.writeValues(ios);
        this.fillEntry(ios);
    }

    private void fillEntry(ImageOutputStream ios) throws IOException {
        long bytesToWrite = 4L - this.getValuesSizeInBytes();
        int i = 0;
        while ((long)i < bytesToWrite) {
            ios.writeByte(0);
            ++i;
        }
    }

    private long getReferencedValuesSizeInBytes() {
        if (this.mustValuesBeReferenced()) {
            return this.getValuesSizeInBytes();
        }
        return 0L;
    }

    public void setValuesOffset(long offset) {
        this.valuesOffset = new TiffLong(offset);
    }

    public long getSize() {
        return 12L + this.getReferencedValuesSizeInBytes();
    }

    public boolean mustValuesBeReferenced() {
        return this.getValuesSizeInBytes() > 4L;
    }

    public long getValuesSizeInBytes() {
        int size = 0;
        TiffValue[] tiffValueArray = this.values;
        int n = this.values.length;
        int n2 = 0;
        while (n2 < n) {
            TiffValue _value = tiffValueArray[n2];
            size += _value.getSizeInBytes();
            ++n2;
        }
        return size;
    }

    private void writeValuesReferenced(ImageOutputStream ios) throws IOException {
        this.valuesOffset.write(ios);
        ios.seek(this.valuesOffset.getValue());
        this.writeValues(ios);
    }

    private void writeValues(ImageOutputStream ios) throws IOException {
        int i = 0;
        while (i < this.values.length) {
            this.values[i].write(ios);
            ++i;
        }
    }

    public TiffLong getValuesOffset() {
        return this.valuesOffset;
    }

    private TiffLong getCount(TiffValue[] values) {
        if (this.type.getValue() != TiffType.ASCII.getValue()) {
            return new TiffLong(values.length);
        }
        long size = 0L;
        TiffValue[] tiffValueArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            TiffValue value = tiffValueArray[n2];
            size += (long)value.getSizeInBytes();
            ++n2;
        }
        return new TiffLong(size);
    }
}

