/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.geometry;

import com.bc.ceres.binding.Converter;
import com.bc.ceres.binding.ConverterRegistry;
import java.io.IOException;
import java.util.Arrays;
import org.esa.beam.framework.datamodel.VectorDataNode;
import org.esa.beam.util.converters.JtsGeometryConverter;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class VectorDataNodeIO {
    public static final char DEFAULT_DELIMITER_CHAR = '\t';
    public static final String ESCAPE_STRING = "\\t";
    public static final String NULL_TEXT = "[null]";
    public static final String FILENAME_EXTENSION = ".csv";
    static final String PROPERTY_NAME_DEFAULT_CSS = "defaultCSS";

    static {
        JtsGeometryConverter.registerConverter();
    }

    public static Converter[] getConverters(SimpleFeatureType simpleFeatureType) throws IOException {
        Converter[] converters = new Converter[simpleFeatureType.getAttributeCount()];
        int i = 0;
        while (i < converters.length) {
            Class<?> attributeType = simpleFeatureType.getType(i).getBinding();
            Converter<?> converter = ConverterRegistry.getInstance().getConverter(attributeType);
            if (converter == null) {
                throw new IOException(String.format("No converter for type %s found.", attributeType));
            }
            converters[i] = converter;
            ++i;
        }
        return converters;
    }

    public static String encodeTabString(String input) {
        StringBuilder sb = new StringBuilder(input.length() + 10);
        boolean escapeMode = false;
        int i = 0;
        while (i < input.length()) {
            char c = input.charAt(i);
            if (c == '\t') {
                sb.append(ESCAPE_STRING);
                escapeMode = false;
            } else {
                if (c == '\\') {
                    escapeMode = true;
                } else {
                    if (c == 't' && escapeMode) {
                        sb.append('\\');
                    }
                    escapeMode = false;
                }
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String decodeTabString(String input) {
        StringBuilder sb = new StringBuilder(input.length() + 10);
        int numEscapes = 0;
        int i = 0;
        while (i < input.length()) {
            char c = input.charAt(i);
            if (c == '\\') {
                ++numEscapes;
                sb.append(c);
            } else if (c == 't' && numEscapes == 1) {
                sb.deleteCharAt(sb.length() - 1);
                sb.append('\t');
                numEscapes = 0;
            } else if (c == 't' && numEscapes > 1) {
                sb.deleteCharAt(sb.length() - 1);
                sb.append(c);
                numEscapes = 0;
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public static VectorDataNode[] getVectorDataNodes(VectorDataNode vectorDataNode, boolean individualShapes, String attributeName) {
        VectorDataNode[] vectorDataNodes;
        if (individualShapes) {
            FeatureCollection<SimpleFeatureType, SimpleFeature> featureCollection = vectorDataNode.getFeatureCollection();
            SimpleFeature[] features = featureCollection.toArray(new SimpleFeature[0]);
            vectorDataNodes = new VectorDataNode[features.length];
            int i = 0;
            while (i < features.length) {
                SimpleFeature feature = features[i];
                String newName = attributeName != null && feature.getAttribute(attributeName) != null && !feature.getAttribute(attributeName).toString().isEmpty() ? feature.getAttribute(attributeName).toString().replace(" ", "_").replace("-", "_") : String.valueOf(vectorDataNode.getName()) + "_" + (i + 1);
                vectorDataNodes[i] = new VectorDataNode(newName, new ListFeatureCollection(vectorDataNode.getFeatureType(), Arrays.asList(feature)));
                ++i;
            }
        } else {
            vectorDataNodes = new VectorDataNode[]{vectorDataNode};
        }
        return vectorDataNodes;
    }
}

