/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.avhrr.noaa.pod;

import org.esa.beam.dataio.avhrr.noaa.pod.PodGeoCoding;
import org.esa.beam.dataio.dimap.spi.DimapPersistable;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.TiePointGrid;
import org.jdom.Element;

public class PodGeoCodingPersistable
implements DimapPersistable {
    static final String POD_GEO_CODING_TAG = "PodGeoCoding";

    @Override
    public Object createObjectFromXml(Element element, Product product) {
        Element podGeoCodingElement = element.getChild(POD_GEO_CODING_TAG);
        String tpgNameLat = podGeoCodingElement.getChildTextTrim("TIE_POINT_GRID_NAME_LAT");
        String tpgNameLon = podGeoCodingElement.getChildTextTrim("TIE_POINT_GRID_NAME_LON");
        if (tpgNameLat != null && tpgNameLon != null) {
            TiePointGrid tiePointGridLat = product.getTiePointGrid(tpgNameLat);
            TiePointGrid tiePointGridLon = product.getTiePointGrid(tpgNameLon);
            if (tiePointGridLat != null && tiePointGridLon != null && tiePointGridLat.hasRasterData() && tiePointGridLon.hasRasterData()) {
                return new PodGeoCoding(tiePointGridLat, tiePointGridLon);
            }
        }
        return null;
    }

    @Override
    public Element createXmlFromObject(Object object) {
        PodGeoCoding podGeoCoding = (PodGeoCoding)object;
        Element podGeoCodingElement = new Element(POD_GEO_CODING_TAG);
        Element tpgLatElement = new Element("TIE_POINT_GRID_NAME_LAT");
        tpgLatElement.setText(podGeoCoding.getLatGrid().getName());
        podGeoCodingElement.addContent(tpgLatElement);
        Element tpgLonElement = new Element("TIE_POINT_GRID_NAME_LON");
        tpgLonElement.setText(podGeoCoding.getLonGrid().getName());
        podGeoCodingElement.addContent(tpgLonElement);
        return podGeoCodingElement;
    }
}

