/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.avhrr;

import com.bc.ceres.core.ProgressMonitor;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import org.esa.beam.dataio.avhrr.AvhrrFile;
import org.esa.beam.dataio.avhrr.BandReader;
import org.esa.beam.framework.datamodel.ProductData;

public class FlagReader
implements BandReader {
    private AvhrrFile avhrrFile;
    private ImageInputStream inputStream;

    public FlagReader(AvhrrFile avhrrFile, ImageInputStream inputStream) {
        this.avhrrFile = avhrrFile;
        this.inputStream = inputStream;
    }

    @Override
    public String getBandName() {
        return "flags";
    }

    @Override
    public String getBandUnit() {
        return null;
    }

    @Override
    public String getBandDescription() {
        return null;
    }

    @Override
    public double getScalingFactor() {
        return 1.0;
    }

    @Override
    public int getDataType() {
        return 20;
    }

    @Override
    public synchronized void readBandRasterData(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        AvhrrFile.RawCoordinates rawCoord = this.avhrrFile.getRawCoordinates(sourceOffsetX, sourceOffsetY, sourceWidth, sourceHeight);
        byte[] flagsData = (byte[])destBuffer.getElems();
        int targetIdx = rawCoord.targetStart;
        pm.beginTask("Reading AVHRR band '" + this.getBandName() + "'...", rawCoord.maxY - rawCoord.minY);
        try {
            int sourceY = rawCoord.minY;
            while (sourceY <= rawCoord.maxY) {
                if (pm.isCanceled()) {
                    break;
                }
                byte flag = this.readFlags(sourceY);
                int sourceX = rawCoord.minX;
                while (sourceX <= rawCoord.maxX) {
                    flagsData[targetIdx] = flag;
                    targetIdx += rawCoord.targetIncrement;
                    sourceX += sourceStepX;
                }
                pm.done();
                sourceY += sourceStepY;
            }
        }
        finally {
            pm.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte readFlags(int rawY) throws IOException {
        long[] flags = new long[6];
        int dataSetOffset = this.avhrrFile.getFlagOffset(rawY);
        ImageInputStream imageInputStream = this.inputStream;
        synchronized (imageInputStream) {
            this.inputStream.seek(dataSetOffset);
            flags[0] = this.inputStream.readUnsignedInt();
            flags[1] = this.inputStream.readUnsignedInt();
            flags[2] = this.inputStream.readUnsignedShort();
            flags[3] = this.inputStream.readUnsignedShort();
            flags[4] = this.inputStream.readUnsignedShort();
            flags[5] = this.inputStream.readUnsignedShort();
        }
        byte flag = 0;
        int i = 0;
        while (i < flags.length) {
            flag = (byte)(flag | (flags[i] != 0L ? 1 : 0) << i);
            ++i;
        }
        return flag;
    }
}

