/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.avhrr;

import java.io.IOException;
import org.esa.beam.dataio.avhrr.BandReader;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.ProductData;

public abstract class AvhrrFile {
    protected int productWidth;
    protected int productHeight;
    protected int channel3ab;
    protected boolean northbound = false;

    public abstract void readHeader() throws IOException;

    public abstract String getProductName() throws IOException;

    public int getProductWidth() {
        return this.productWidth;
    }

    public int getProductHeight() {
        return this.productHeight;
    }

    public abstract ProductData.UTC getStartDate() throws IOException;

    public abstract ProductData.UTC getEndDate() throws IOException;

    public int getChannel3abState() {
        return this.channel3ab;
    }

    public abstract void addMetaData(MetadataElement var1) throws IOException;

    public abstract BandReader createVisibleRadianceBandReader(int var1) throws IOException;

    public abstract BandReader createIrRadianceBandReader(int var1) throws IOException;

    public abstract BandReader createIrTemperatureBandReader(int var1) throws IOException;

    public abstract BandReader createReflectanceFactorBandReader(int var1);

    public abstract BandReader createFlagBandReader();

    public abstract boolean hasCloudBand();

    public abstract BandReader createCloudBandReader();

    public abstract String[] getTiePointNames();

    public abstract float[][] getTiePointData() throws IOException;

    public abstract int getScanLineOffset(int var1);

    public abstract int getFlagOffset(int var1);

    public abstract int getTiePointTrimX();

    public abstract int getTiePointSubsampling();

    public RawCoordinates getRawCoordinates(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight) {
        RawCoordinates coordinates = new RawCoordinates();
        if (this.northbound) {
            coordinates.minX = this.productWidth - sourceOffsetX - sourceWidth;
            coordinates.maxX = this.productWidth - sourceOffsetX - 1;
            coordinates.minY = this.productHeight - sourceOffsetY - sourceHeight;
            coordinates.maxY = this.productHeight - sourceOffsetY - 1;
            coordinates.targetStart = sourceWidth * sourceHeight - 1;
            coordinates.targetIncrement = -1;
        } else {
            coordinates.minX = sourceOffsetX;
            coordinates.maxX = sourceOffsetX + sourceWidth - 1;
            coordinates.minY = sourceOffsetY;
            coordinates.maxY = sourceOffsetY + sourceHeight - 1;
            coordinates.targetStart = 0;
            coordinates.targetIncrement = 1;
        }
        int tpTrimX = this.getTiePointTrimX();
        coordinates.minX += tpTrimX;
        coordinates.maxX += tpTrimX;
        return coordinates;
    }

    public abstract void dispose() throws IOException;

    public class RawCoordinates {
        public int minX;
        public int maxX;
        public int minY;
        public int maxY;
        public int targetIncrement;
        public int targetStart;
    }
}

