/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtsexample.geom;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;

public class PrecisionModelExample {
    public static void main(String[] args) {
        PrecisionModelExample example = new PrecisionModelExample();
        try {
            example.run();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void run() throws ParseException {
        this.example1();
        this.example2();
    }

    public void example1() throws ParseException {
        System.out.println("-------------------------------------------");
        System.out.println("Example 1 shows roundoff from computing in different precision models");
        String wktA = "POLYGON ((60 180, 160 260, 240 80, 60 180))";
        String wktB = "POLYGON ((200 260, 280 160, 80 100, 200 260))";
        System.out.println("A = " + wktA);
        System.out.println("B = " + wktB);
        this.intersection(wktA, wktB, new PrecisionModel());
        this.intersection(wktA, wktB, new PrecisionModel(PrecisionModel.FLOATING_SINGLE));
        this.intersection(wktA, wktB, new PrecisionModel(1.0));
    }

    public void example2() throws ParseException {
        System.out.println("-------------------------------------------");
        System.out.println("Example 2 shows that roundoff can change the topology of geometry computed in different precision models");
        String wktA = "POLYGON ((0 0, 160 0, 160 1, 0 0))";
        String wktB = "POLYGON ((40 60, 40 -20, 140 -20, 140 60, 40 60))";
        System.out.println("A = " + wktA);
        System.out.println("B = " + wktB);
        this.difference(wktA, wktB, new PrecisionModel());
        this.difference(wktA, wktB, new PrecisionModel(1.0));
    }

    public void intersection(String wktA, String wktB, PrecisionModel pm) throws ParseException {
        System.out.println("Running example using Precision Model = " + pm);
        GeometryFactory fact = new GeometryFactory(pm);
        WKTReader wktRdr = new WKTReader(fact);
        Geometry A = wktRdr.read(wktA);
        Geometry B2 = wktRdr.read(wktB);
        Geometry C = A.intersection(B2);
        System.out.println("A intersection B = " + C);
    }

    public void difference(String wktA, String wktB, PrecisionModel pm) throws ParseException {
        System.out.println("-------------------------------------------");
        System.out.println("Running example using Precision Model = " + pm);
        GeometryFactory fact = new GeometryFactory(pm);
        WKTReader wktRdr = new WKTReader(fact);
        Geometry A = wktRdr.read(wktA);
        Geometry B2 = wktRdr.read(wktB);
        Geometry C = A.difference(B2);
        System.out.println("A intersection B = " + C);
    }
}

