/*
 * Decompiled with CFR 0.152.
 */
package com.bc.jexp.impl;

import com.bc.jexp.Function;
import com.bc.jexp.Namespace;
import com.bc.jexp.Symbol;
import com.bc.jexp.Term;
import com.bc.jexp.WritableNamespace;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class NamespaceImpl
implements WritableNamespace {
    private final Namespace defaultNamespace;
    private final Map<String, Symbol> symbols;
    private final Map<String, Function[]> functions;

    public NamespaceImpl() {
        this(null);
    }

    public NamespaceImpl(Namespace defaultNamespace) {
        this.defaultNamespace = defaultNamespace;
        this.symbols = new HashMap<String, Symbol>(32);
        this.functions = new HashMap<String, Function[]>(16);
    }

    public final Namespace getDefaultNamespace() {
        return this.defaultNamespace;
    }

    @Override
    public final void registerSymbol(Symbol symbol) {
        this.symbols.put(symbol.getName(), symbol);
    }

    @Override
    public final void deregisterSymbol(Symbol symbol) {
        this.symbols.remove(symbol.getName());
    }

    @Override
    public final Symbol resolveSymbol(String name) {
        Symbol symbol = this.symbols.get(name);
        if (symbol == null && this.defaultNamespace != null) {
            symbol = this.defaultNamespace.resolveSymbol(name);
        }
        return symbol;
    }

    @Override
    public final void registerFunction(Function function) {
        Function[] array = this.getFunctions(function.getName());
        if (array != null) {
            Function[] functionArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                Function anArray = functionArray[n2];
                if (anArray == function) {
                    return;
                }
                ++n2;
            }
            Function[] arrayNew = new Function[array.length + 1];
            System.arraycopy(array, 0, arrayNew, 0, array.length);
            arrayNew[array.length] = function;
            array = arrayNew;
        } else {
            array = new Function[]{function};
        }
        this.functions.put(function.getName(), array);
    }

    @Override
    public final void deregisterFunction(Function function) {
        Function[] array = this.getFunctions(function.getName());
        if (array != null) {
            ArrayList<Function> functionList = new ArrayList<Function>(Arrays.asList(array));
            if (!functionList.remove(function)) {
                return;
            }
            array = functionList.toArray(new Function[functionList.size()]);
            this.functions.put(function.getName(), array);
        }
    }

    @Override
    public final Function resolveFunction(String name, Term[] args) {
        Function[] functions = this.getFunctions(name);
        if (functions != null) {
            Function bestFunction = null;
            int bestValidity = -1;
            Function[] functionArray = functions;
            int n = functions.length;
            int n2 = 0;
            while (n2 < n) {
                Function function = functionArray[n2];
                int definedNumArgs = function.getNumArgs();
                if (definedNumArgs == args.length || definedNumArgs == -1) {
                    int validity = definedNumArgs == args.length ? 10 : 0;
                    int i = 0;
                    while (i < args.length) {
                        Term arg = args[i];
                        int argType = function.getArgType(i);
                        if (argType == arg.getRetType()) {
                            validity += 4;
                        } else if (argType == 3 && arg.isN()) {
                            validity += 2;
                        } else if (argType == 2 && arg.isN()) {
                            ++validity;
                        }
                        ++i;
                    }
                    if (validity > bestValidity) {
                        bestFunction = function;
                        bestValidity = validity;
                    }
                }
                ++n2;
            }
            if (bestFunction != null) {
                return bestFunction;
            }
            if (bestFunction != null) {
                return bestFunction;
            }
        }
        if (this.defaultNamespace != null) {
            return this.defaultNamespace.resolveFunction(name, args);
        }
        return null;
    }

    @Override
    public Symbol[] getAllSymbols() {
        ArrayList<Symbol> symbolList = new ArrayList<Symbol>(this.symbols.values());
        if (this.defaultNamespace instanceof WritableNamespace) {
            WritableNamespace writableNamespace = (WritableNamespace)this.defaultNamespace;
            Symbol[] defaultSymbols = writableNamespace.getAllSymbols();
            symbolList.addAll(Arrays.asList(defaultSymbols));
        }
        return symbolList.toArray(new Symbol[symbolList.size()]);
    }

    @Override
    public final Function[] getAllFunctions() {
        Collection<Function[]> collection = this.functions.values();
        ArrayList<Function> functionList = new ArrayList<Function>(32 + 2 * collection.size());
        for (Function[] functions : collection) {
            functionList.addAll(Arrays.asList(functions));
        }
        if (this.defaultNamespace instanceof WritableNamespace) {
            WritableNamespace writableNamespace = (WritableNamespace)this.defaultNamespace;
            Function[] defaultFunctions = writableNamespace.getAllFunctions();
            functionList.addAll(Arrays.asList(defaultFunctions));
        }
        return functionList.toArray(new Function[functionList.size()]);
    }

    private Function[] getFunctions(String name) {
        return this.functions.get(name);
    }
}

