/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.core.runtime.internal;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import com.bc.ceres.core.runtime.ModuleState;
import com.bc.ceres.core.runtime.internal.DirScanner;
import com.bc.ceres.core.runtime.internal.InstallInfo;
import com.bc.ceres.core.runtime.internal.ModuleImpl;
import com.bc.ceres.core.runtime.internal.UrlHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.logging.Logger;

public class ModuleUninstaller {
    private Logger logger;

    public ModuleUninstaller(Logger logger) {
        Assert.notNull(logger, "logger");
        this.logger = logger;
    }

    public void uninstallModule(ModuleImpl module) throws IOException {
        this.markLocationFileAsUninstalled(module);
        module.setState(ModuleState.UNINSTALLED);
    }

    public void uninstallModules(File moduleDir, ProgressMonitor pm) {
        DirScanner dirScanner = new DirScanner(moduleDir, false);
        String[] uninstallMarkers = dirScanner.scan(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".uninstall");
            }
        });
        if (uninstallMarkers.length == 0) {
            return;
        }
        pm.beginTask("Uninstalling modules", uninstallMarkers.length);
        String[] stringArray = uninstallMarkers;
        int n = uninstallMarkers.length;
        int n2 = 0;
        while (n2 < n) {
            String uninstallMarker = stringArray[n2];
            String moduleFileName = uninstallMarker.substring(0, uninstallMarker.length() - ".uninstall".length());
            File moduleFile = new File(moduleDir, moduleFileName);
            boolean deleted = this.uninstallModuleFile(moduleFile, SubProgressMonitor.create(pm, 1));
            if (deleted) {
                File uninstallMarkerFile = new File(moduleDir, uninstallMarker);
                uninstallMarkerFile.delete();
            }
            ++n2;
        }
        pm.done();
    }

    private void markLocationFileAsUninstalled(ModuleImpl module) throws IOException {
        URL location = module.getLocation();
        this.logger.info(MessageFormat.format("Marking module file [{0}] for deinstallation.", location));
        File locationFile = UrlHelper.urlToFile(location);
        if (locationFile == null) {
            throw new IOException("Location is not a file.");
        }
        File markerFile = new File(String.valueOf(locationFile.getPath()) + ".uninstall");
        try (FileWriter writer = new FileWriter(markerFile);){
            writer.write(location.toString());
        }
    }

    private boolean uninstallModuleFile(File locationFile, ProgressMonitor pm) {
        this.logger.info(MessageFormat.format("Uninstalling module [{0}]...", locationFile));
        boolean deleted = true;
        if (locationFile.exists()) {
            deleted = locationFile.isDirectory() ? this.uninstallModuleDirectory(locationFile, pm) : ModuleUninstaller.uninstallModuleArchive(locationFile, pm);
        }
        return deleted;
    }

    private static boolean uninstallModuleArchive(File archiveFile, ProgressMonitor pm) {
        pm.beginTask(MessageFormat.format("Uninstalling {0}", archiveFile.getName()), 1);
        try {
            boolean bl = archiveFile.delete();
            return bl;
        }
        finally {
            pm.done();
        }
    }

    private boolean uninstallModuleDirectory(File moduleDir, ProgressMonitor pm) {
        InstallInfo installInfo;
        File installInfoFile = new File(moduleDir, "install-info.xml");
        try {
            installInfo = null;
            try (FileReader reader = new FileReader(installInfoFile);){
                installInfo = InstallInfo.read(reader);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.logger.warning(MessageFormat.format("[{0}] not found.", installInfoFile.getName()));
            this.logger.warning(MessageFormat.format("Please remove directory [{1}] manually to get rid of this warning.", installInfoFile.getName(), moduleDir));
            return false;
        }
        catch (IOException e) {
            this.logger.warning(MessageFormat.format("Failed to read [{0}]: {1}", installInfoFile.getName(), e.getMessage()));
            return false;
        }
        String[] items = installInfo.getItems();
        pm.beginTask(MessageFormat.format("Uninstalling {0}", moduleDir.getName()), items.length);
        try {
            int i = items.length - 1;
            while (i >= 0) {
                String item = items[i];
                File installedFile = new File(moduleDir, item);
                pm.setTaskName(MessageFormat.format("Uninstalling {0}", installedFile.getName()));
                if (installedFile.isFile()) {
                    long oneSecond;
                    boolean fileIsOlderOrEqualInstallTime;
                    long installTime = installInfo.getDate().getTime();
                    long lastModifiedTime = installedFile.lastModified();
                    boolean bl = fileIsOlderOrEqualInstallTime = lastModifiedTime <= installTime + (oneSecond = 1000L);
                    if (fileIsOlderOrEqualInstallTime) {
                        this.delete(installedFile);
                    } else {
                        this.logger.warning(MessageFormat.format("Module file component [{0}] has been modified since installation.", installedFile));
                    }
                } else if (installedFile.isDirectory()) {
                    this.delete(installedFile);
                } else {
                    this.logger.warning(MessageFormat.format("Module file component [{0}] no longer exists.", installedFile));
                }
                pm.worked(1);
                --i;
            }
            this.delete(installInfoFile);
            this.delete(moduleDir);
        }
        finally {
            pm.done();
        }
        return moduleDir.exists();
    }

    private void delete(File file) {
        if (file.delete()) {
            this.logger.info(MessageFormat.format("Deleted module file component [{0}].", file));
        } else {
            this.logger.warning(MessageFormat.format("Unable to delete module file component [{0}].", file));
        }
    }
}

