/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.core.runtime.internal;

import com.bc.ceres.core.Assert;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;

public class DirScanner {
    private File baseDir;
    private boolean recursive;
    private boolean filesOnly;

    public DirScanner(File baseDir) {
        this(baseDir, false);
    }

    public DirScanner(File baseDir, boolean recursive) {
        this(baseDir, recursive, false);
    }

    public DirScanner(File baseDir, boolean recursive, boolean filesOnly) {
        Assert.notNull(baseDir, "baseDir");
        this.baseDir = baseDir;
        this.recursive = recursive;
        this.filesOnly = filesOnly;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public String[] scan() {
        return this.scan(new NullFilenameFilter());
    }

    public String[] scan(FilenameFilter filter) {
        Assert.notNull(filter, "filter");
        ArrayList<String> strings = new ArrayList<String>(16);
        this.collectFiles(filter, "", strings);
        return strings.toArray(new String[0]);
    }

    private void collectFiles(FilenameFilter filter, String relDirPath, ArrayList<String> entries) {
        File dir = new File(this.baseDir, relDirPath);
        String[] fileNames = dir.list();
        if (fileNames != null) {
            String[] stringArray = fileNames;
            int n = fileNames.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName = stringArray[n2];
                String relFilePath = String.valueOf(relDirPath) + fileName;
                File file = new File(this.baseDir, relFilePath);
                if (file.isDirectory()) {
                    if (!this.filesOnly && filter.accept(dir, fileName)) {
                        entries.add(relFilePath);
                    }
                    if (this.recursive) {
                        this.collectFiles(filter, String.valueOf(relFilePath) + '/', entries);
                    }
                } else if (filter.accept(dir, fileName)) {
                    entries.add(relFilePath);
                }
                ++n2;
            }
        }
    }

    private static class NullFilenameFilter
    implements FilenameFilter {
        private NullFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return true;
        }
    }
}

