/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.core;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.NullProgressMonitor;
import com.bc.ceres.core.ProgressMonitor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class ProcessObserver {
    private static final String MAIN = "main";
    private static final int STDOUT = 0;
    private static final int STDERR = 1;
    private final Process process;
    private String name;
    private int pollPeriod;
    private ProgressMonitor progressMonitor;
    private Handler handler;
    private Mode mode;
    private ObservedProcessImpl observedProcess;

    public ProcessObserver(Process process) {
        this.process = process;
        this.name = "process";
        this.pollPeriod = 500;
        this.progressMonitor = new NullProgressMonitor();
        this.handler = new DefaultHandler();
        this.mode = Mode.BLOCKING;
    }

    public String getName() {
        return this.name;
    }

    public ProcessObserver setName(String name) {
        Assert.notNull(name, "name");
        this.name = name;
        return this;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public ProcessObserver setHandler(Handler handler) {
        Assert.notNull(handler, "handler");
        this.handler = handler;
        return this;
    }

    public ProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    public ProcessObserver setProgressMonitor(ProgressMonitor progressMonitor) {
        Assert.notNull(progressMonitor, "progressMonitor");
        this.progressMonitor = progressMonitor;
        return this;
    }

    public Mode getMode() {
        return this.mode;
    }

    public ProcessObserver setMode(Mode mode) {
        Assert.notNull((Object)mode, "mode");
        this.mode = mode;
        return this;
    }

    public int getPollPeriod() {
        return this.pollPeriod;
    }

    public ProcessObserver setPollPeriod(int pollPeriod) {
        Assert.notNull(pollPeriod, "pollPeriod");
        this.pollPeriod = pollPeriod;
        return this;
    }

    public ObservedProcess start() {
        if (this.observedProcess != null) {
            throw new IllegalStateException("process already observed.");
        }
        this.observedProcess = new ObservedProcessImpl();
        this.observedProcess.startObservation();
        return this.observedProcess;
    }

    public static class DefaultHandler
    implements Handler {
        @Override
        public void onObservationStarted(ObservedProcess process, ProgressMonitor pm) {
            System.out.println(String.valueOf(process.getName()) + " started");
        }

        @Override
        public void onStdoutLineReceived(ObservedProcess process, String line, ProgressMonitor pm) {
            System.out.println(String.valueOf(process.getName()) + ": " + line);
        }

        @Override
        public void onStderrLineReceived(ObservedProcess process, String line, ProgressMonitor pm) {
            System.err.println(String.valueOf(process.getName()) + ": " + line);
        }

        @Override
        public void onObservationEnded(ObservedProcess process, Integer exitCode, ProgressMonitor pm) {
            System.out.println(String.valueOf(process.getName()) + " ended, exit code " + exitCode);
        }
    }

    public static interface Handler {
        public void onObservationStarted(ObservedProcess var1, ProgressMonitor var2);

        public void onStdoutLineReceived(ObservedProcess var1, String var2, ProgressMonitor var3);

        public void onStderrLineReceived(ObservedProcess var1, String var2, ProgressMonitor var3);

        public void onObservationEnded(ObservedProcess var1, Integer var2, ProgressMonitor var3);
    }

    private class LineReaderThread
    extends Thread {
        private final int type;

        public LineReaderThread(ThreadGroup threadGroup, int type) {
            super(threadGroup, String.valueOf(ProcessObserver.this.name) + "-" + type);
            this.type = type;
        }

        @Override
        public void run() {
            try {
                this.read();
            }
            catch (IOException iOException) {}
        }

        private void read() throws IOException {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.type == 0 ? ProcessObserver.this.process.getInputStream() : ProcessObserver.this.process.getErrorStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    this.fireLineReceived(line);
                }
            }
        }

        private void fireLineReceived(String line) {
            if (this.type == 0) {
                ProcessObserver.this.handler.onStdoutLineReceived(ProcessObserver.this.observedProcess, line, ProcessObserver.this.progressMonitor);
            } else {
                ProcessObserver.this.handler.onStderrLineReceived(ProcessObserver.this.observedProcess, line, ProcessObserver.this.progressMonitor);
            }
        }
    }

    public static enum Mode {
        BLOCKING,
        NON_BLOCKING;

    }

    public static interface ObservedProcess {
        public String getName();

        public void cancel();
    }

    private class ObservedProcessImpl
    implements ObservedProcess {
        private ThreadGroup threadGroup;
        private Thread stdoutThread;
        private Thread stderrThread;
        private boolean cancellationRequested;
        private boolean cancelled;

        ObservedProcessImpl() {
            this.threadGroup = new ThreadGroup(ProcessObserver.this.name);
            this.stdoutThread = new LineReaderThread(this.threadGroup, 0);
            this.stderrThread = new LineReaderThread(this.threadGroup, 1);
        }

        @Override
        public String getName() {
            return ProcessObserver.this.name;
        }

        @Override
        public void cancel() {
            this.cancellationRequested = true;
        }

        private void startObservation() {
            ProcessObserver.this.handler.onObservationStarted(ProcessObserver.this.observedProcess, ProcessObserver.this.progressMonitor);
            this.stdoutThread.start();
            this.stderrThread.start();
            if (ProcessObserver.this.mode == Mode.BLOCKING) {
                this.awaitTermination();
            } else {
                Thread mainThread = new Thread(this.threadGroup, new Runnable(){

                    @Override
                    public void run() {
                        ObservedProcessImpl.this.awaitTermination();
                    }
                }, String.valueOf(ProcessObserver.this.name) + "-" + ProcessObserver.MAIN);
                mainThread.start();
            }
        }

        private void awaitTermination() {
            while (true) {
                if ((ProcessObserver.this.progressMonitor.isCanceled() || this.cancellationRequested) && !this.cancelled) {
                    this.cancelled = true;
                    ProcessObserver.this.process.destroy();
                    ProcessObserver.this.handler.onObservationEnded(this, null, ProcessObserver.this.progressMonitor);
                    break;
                }
                if (!this.stdoutThread.isAlive() && !this.stderrThread.isAlive()) {
                    try {
                        int exitCode = ProcessObserver.this.process.exitValue();
                        ProcessObserver.this.handler.onObservationEnded(this, exitCode, ProcessObserver.this.progressMonitor);
                        break;
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {}
                }
                try {
                    Thread.sleep(ProcessObserver.this.pollPeriod);
                }
                catch (InterruptedException interruptedException) {
                    ProcessObserver.this.handler.onObservationEnded(this, null, ProcessObserver.this.progressMonitor);
                    break;
                }
            }
        }
    }
}

