/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.compiler;

import com.bc.ceres.compiler.Code;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;

public class CodeCompiler {
    private final JavaCompiler compiler;
    private final File outputDir;
    private final File[] classPath;

    public CodeCompiler(File outputDir, File[] classPath) {
        this(ToolProvider.getSystemJavaCompiler(), outputDir, classPath);
    }

    public CodeCompiler(JavaCompiler compiler, File outputDir, File[] classPath) {
        this.compiler = compiler;
        this.outputDir = outputDir;
        this.classPath = (File[])classPath.clone();
    }

    public Class<?> compile(String packageName, String className, String code) throws IOException, ClassNotFoundException {
        return this.compile(new Code(String.valueOf(packageName) + '.' + className, code));
    }

    public Class<?> compile(Code code) throws IOException, ClassNotFoundException {
        boolean status = this.performCompilerTask(code);
        if (!status) {
            throw new RuntimeException("Code compilation failed.");
        }
        URL[] urls = new URL[this.classPath.length];
        int i = 0;
        while (i < urls.length) {
            urls[i] = this.classPath[i].toURI().toURL();
            ++i;
        }
        URLClassLoader loader = new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
        return loader.loadClass(code.getClassName());
    }

    private boolean performCompilerTask(JavaFileObject ... source) throws IOException {
        StandardJavaFileManager fileManager = this.compiler.getStandardFileManager(null, null, null);
        this.outputDir.mkdirs();
        fileManager.setLocation(StandardLocation.CLASS_OUTPUT, Arrays.asList(this.outputDir));
        fileManager.setLocation(StandardLocation.CLASS_PATH, Arrays.asList(this.classPath));
        JavaCompiler.CompilationTask task = this.compiler.getTask(null, fileManager, null, null, null, Arrays.asList(source));
        return task.call();
    }
}

