/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binio.util;

import com.bc.ceres.binio.DataContext;
import com.bc.ceres.binio.IOHandler;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class MappedFileChannelIOHandler
implements IOHandler {
    private final FileChannel channel;
    private MappedByteBuffer mappedBuffer;
    private long mappedPos;
    private long mappedUpperBound;
    private long streamPos;

    public MappedFileChannelIOHandler(FileChannel channel) throws IOException {
        long channelPosition;
        if (channel == null) {
            throw new IllegalArgumentException("channel == null");
        }
        if (!channel.isOpen()) {
            throw new IllegalArgumentException("channel.isOpen() == false");
        }
        this.channel = channel;
        this.streamPos = channelPosition = channel.position();
        long fullSize = channel.size() - channelPosition;
        long mappedSize = Math.min(fullSize, Integer.MAX_VALUE);
        this.mappedPos = 0L;
        this.mappedUpperBound = this.mappedPos + mappedSize;
        this.mappedBuffer = channel.map(FileChannel.MapMode.READ_ONLY, channelPosition, mappedSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(DataContext context, byte[] data, long position) throws IOException {
        MappedFileChannelIOHandler mappedFileChannelIOHandler = this;
        synchronized (mappedFileChannelIOHandler) {
            this.seek(position);
            this.read(data);
        }
    }

    @Override
    public void write(DataContext context, byte[] data, long position) throws IOException {
        throw new RuntimeException("not implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMaxPosition() throws IOException {
        MappedFileChannelIOHandler mappedFileChannelIOHandler = this;
        synchronized (mappedFileChannelIOHandler) {
            return this.channel.size();
        }
    }

    private void seek(long pos) throws IOException {
        this.streamPos = pos;
        if (pos >= this.mappedPos && pos < this.mappedUpperBound) {
            this.mappedBuffer.position((int)(pos - this.mappedPos));
        } else {
            int len = (int)Math.min(this.channel.size() - pos, Integer.MAX_VALUE);
            this.mappedBuffer = this.getMappedBuffer(len);
        }
    }

    private int read(byte[] b) throws IOException {
        if (b.length == 0) {
            return 0;
        }
        int len = b.length;
        MappedByteBuffer byteBuffer = this.getMappedBuffer(len);
        byteBuffer.get(b, 0, len);
        this.streamPos += (long)len;
        return len;
    }

    private MappedByteBuffer getMappedBuffer(int len) throws IOException {
        if (this.streamPos < this.mappedPos || this.streamPos + (long)len >= this.mappedUpperBound) {
            this.mappedPos = this.streamPos;
            long mappedSize = Math.min(this.channel.size() - this.mappedPos, Integer.MAX_VALUE);
            this.mappedUpperBound = this.mappedPos + mappedSize;
            this.mappedBuffer = this.channel.map(FileChannel.MapMode.READ_ONLY, this.mappedPos, mappedSize);
        }
        return this.mappedBuffer;
    }
}

