/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binding.converters;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.Converter;
import com.bc.ceres.binding.converters.ArrayConverter;
import com.bc.ceres.binding.converters.StringConverter;
import java.awt.Font;
import java.text.MessageFormat;

public class FontConverter
implements Converter<Font> {
    @Override
    public Class<Font> getValueType() {
        return Font.class;
    }

    @Override
    public Font parse(String text) throws ConversionException {
        String[] tokens;
        if (text.isEmpty()) {
            return null;
        }
        try {
            tokens = (String[])new ArrayConverter(String[].class, new StringConverter()).parse(text);
        }
        catch (ConversionException e) {
            throw new ConversionException(MessageFormat.format("Cannot parse ''{0}'' into a font: {1}", text, e.getMessage()));
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < tokens.length) {
            String token = tokens[i].trim();
            sb.append(token);
            if (i != tokens.length - 1) {
                sb.append(" ");
            }
            ++i;
        }
        return Font.decode(sb.toString());
    }

    @Override
    public String format(Font font) {
        if (font == null) {
            return "";
        }
        return String.format("%s,%s,%d", font.getName(), FontConverter.getStyleName(font), font.getSize());
    }

    private static String getStyleName(Font font) {
        StringBuilder sb = new StringBuilder();
        if (font.isPlain()) {
            sb.append("plain");
        } else {
            if (font.isBold()) {
                sb.append("bold");
            }
            if (font.isItalic()) {
                sb.append("italic");
            }
        }
        return sb.toString();
    }
}

