/*
 * Decompiled with CFR 0.152.
 */
import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteOrder;
import javax.imageio.stream.FileImageOutputStream;
import org.esa.beam.dataio.geotiff.Utils;
import org.esa.beam.framework.dataio.AbstractProductWriter;
import org.esa.beam.framework.dataio.ProductWriterPlugIn;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.BasicPixelGeoCoding;
import org.esa.beam.framework.datamodel.CrsGeoCoding;
import org.esa.beam.framework.datamodel.FXYGeoCoding;
import org.esa.beam.framework.datamodel.GcpGeoCoding;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.MapGeoCoding;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.TiePointGeoCoding;
import org.esa.beam.framework.datamodel.TiePointGrid;
import org.esa.beam.framework.dataop.maptransf.Datum;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ILWISProductWriter
extends AbstractProductWriter {
    private String filePrefix;
    private MinMax mm = null;

    public ILWISProductWriter(ProductWriterPlugIn writerPlugIn) {
        super(writerPlugIn);
    }

    @Override
    public void writeBandRasterData(Band sourceBand, int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, ProductData sourceBuffer, ProgressMonitor pm) throws IOException {
        long pixelOffset;
        if (!Utils.shouldWriteNode(sourceBand)) {
            return;
        }
        boolean firstPass = sourceOffsetX == 0 && sourceOffsetY == 0;
        boolean lastPass = sourceOffsetX + sourceWidth == sourceBand.getSceneRasterWidth() && sourceOffsetY + sourceHeight == sourceBand.getSceneRasterHeight();
        int regionX = sourceOffsetX;
        int regionY = sourceOffsetY;
        int regionWidth = sourceWidth;
        int regionHeight = sourceHeight;
        int bandDataType = sourceBand.getDataType();
        long elemSize = ProductData.getElemSize(bandDataType);
        long sourceWidthBytes = (long)sourceBand.getSceneRasterWidth() * elemSize;
        long regionOffsetXInBytes = (long)regionX * elemSize;
        long startOffset = pixelOffset = sourceWidthBytes * (long)regionY + regionOffsetXInBytes;
        String fileNameODF = String.valueOf(this.filePrefix) + "_" + sourceBand.getName() + ".mpr";
        String fileNameData = String.valueOf(this.filePrefix) + "_" + sourceBand.getName() + ".mp#";
        String fnGrf = this.getSourceProduct().isUsingSingleGeoCoding() ? String.valueOf(this.filePrefix) + ".grf" : String.valueOf(this.filePrefix) + "_" + sourceBand.getName() + ".grf";
        File outputFile = new File(fileNameData);
        FileImageOutputStream ios = new FileImageOutputStream(outputFile);
        ios.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        if (firstPass) {
            this.mm = new MinMax();
        }
        pm.beginTask("Writing band '" + sourceBand.getName() + "'...", regionHeight);
        try {
            int y = 0;
            while (y < regionHeight) {
                int x;
                Object[] data;
                ios.seek(startOffset + (long)y * sourceWidthBytes);
                int stride = y * regionWidth;
                if (bandDataType == 20) {
                    data = new byte[regionWidth];
                    x = 0;
                    while (x < regionWidth) {
                        data[x] = (byte)sourceBuffer.getElemUIntAt(stride + x);
                        ++x;
                    }
                    ios.write((byte[])data);
                    this.computeMinMax((byte[])data, this.mm);
                } else if (bandDataType == 10) {
                    data = new byte[regionWidth];
                    x = 0;
                    while (x < regionWidth) {
                        data[x] = (byte)sourceBuffer.getElemIntAt(stride + x);
                        ++x;
                    }
                    ios.write((byte[])data);
                    this.computeMinMax((byte[])data, this.mm);
                } else if (bandDataType == 21) {
                    data = new short[regionWidth];
                    x = 0;
                    while (x < regionWidth) {
                        data[x] = (short)sourceBuffer.getElemUIntAt(stride + x);
                        ++x;
                    }
                    ios.writeShorts((short[])data, 0, regionWidth);
                    this.computeMinMax((short[])data, this.mm);
                } else if (bandDataType == 11) {
                    data = new short[regionWidth];
                    x = 0;
                    while (x < regionWidth) {
                        data[x] = (short)sourceBuffer.getElemIntAt(stride + x);
                        ++x;
                    }
                    ios.writeShorts((short[])data, 0, regionWidth);
                    this.computeMinMax((short[])data, this.mm);
                } else if (bandDataType == 22) {
                    data = new int[regionWidth];
                    x = 0;
                    while (x < regionWidth) {
                        data[x] = (int)sourceBuffer.getElemUIntAt(stride + x);
                        ++x;
                    }
                    ios.writeInts((int[])data, 0, regionWidth);
                    this.computeMinMax((int[])data, this.mm);
                } else if (bandDataType == 12) {
                    data = new int[regionWidth];
                    x = 0;
                    while (x < regionWidth) {
                        data[x] = sourceBuffer.getElemIntAt(stride + x);
                        ++x;
                    }
                    ios.writeInts((int[])data, 0, regionWidth);
                    this.computeMinMax((int[])data, this.mm);
                } else if (bandDataType == 30) {
                    data = new float[regionWidth];
                    x = 0;
                    while (x < regionWidth) {
                        data[x] = (byte)sourceBuffer.getElemFloatAt(stride + x);
                        ++x;
                    }
                    ios.writeFloats((float[])data, 0, regionWidth);
                    this.computeMinMax((float[])data, this.mm);
                } else if (bandDataType == 31) {
                    data = new double[regionWidth];
                    x = 0;
                    while (x < regionWidth) {
                        data[x] = (byte)sourceBuffer.getElemDoubleAt(stride + x);
                        ++x;
                    }
                    ios.writeDoubles((double[])data, 0, regionWidth);
                    this.computeMinMax((double[])data, this.mm);
                }
                pm.worked(1);
                ++y;
            }
        }
        finally {
            pm.done();
            ios.flush();
            ios.close();
        }
        if (!lastPass) {
            return;
        }
        PrintWriter writer = new PrintWriter(fileNameODF, "UTF-8");
        try {
            String sType = "Unknown";
            if (bandDataType == 20) {
                sType = "Byte";
            } else if (bandDataType == 10) {
                sType = "Byte";
            } else if (bandDataType == 21) {
                sType = "Int";
            } else if (bandDataType == 11) {
                sType = "Int";
            } else if (bandDataType == 22) {
                sType = "Long";
            } else if (bandDataType == 12) {
                sType = "Long";
            } else if (bandDataType == 30) {
                sType = "Float";
            } else if (bandDataType == 31) {
                sType = "Real";
            }
            double scale = sourceBand.getScalingFactor();
            double offset = sourceBand.getScalingOffset();
            boolean fRawInt = (sType == "Byte" || sType == "Int" || sType == "Long") && scale == 1.0;
            boolean fRawFloat = (sType == "Byte" || sType == "Int" || sType == "Long") && scale != 1.0;
            boolean fReal = (sType == "Float" || sType == "Real") && scale == 1.0 && offset == 0.0;
            writer.println("[Ilwis]");
            writer.println("Type=BaseMap");
            writer.println("Description=");
            writer.println("Version=3.1");
            writer.println("Class=Raster Map");
            writer.println();
            writer.println("[BaseMap]");
            writer.println("Type=Map");
            writer.println("Domain=value.dom");
            writer.println("CoordSystem=" + ILWISProductWriter.removePath(ILWISProductWriter.getILWISCoordinateSystem(this.getSourceProduct().isUsingSingleGeoCoding() ? this.getSourceProduct().getGeoCoding() : sourceBand.getGeoCoding())));
            if (fRawInt) {
                int min = (int)(this.mm.getMin() + offset);
                int max = (int)(this.mm.getMax() + offset);
                writer.println("MinMax=" + min + ":" + max);
                writer.println("Range=" + min + ":" + max + ":offset=" + (int)offset);
            } else if (fRawFloat) {
                double min = this.mm.getMin() * scale + offset;
                double max = this.mm.getMax() * scale + offset;
                writer.println("MinMax=" + min + ":" + max);
                writer.println("Range=" + min + ":" + max + ":" + scale + ":offset=" + offset);
            } else if (fReal) {
                double min = this.mm.getMin();
                double max = this.mm.getMax();
                writer.println("MinMax=" + min + ":" + max);
                writer.println("Range=" + min + ":" + max + ":0:offset=0");
            } else {
                double min = this.mm.getMin();
                double max = this.mm.getMax();
                writer.println("MinMax=" + min + ":" + max);
            }
            writer.println();
            writer.println("[Map]");
            writer.println("GeoRef=" + ILWISProductWriter.removePath(fnGrf));
            writer.println("Size=" + sourceBand.getSceneRasterHeight() + " " + sourceBand.getSceneRasterWidth());
            writer.println("Type=MapStore");
            writer.println();
            writer.println("[MapStore]");
            writer.println("Data=" + ILWISProductWriter.removePath(fileNameData));
            writer.println("Structure=Line");
            writer.println("Type=" + sType);
        }
        finally {
            writer.flush();
            writer.close();
        }
        this.mm = null;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void deleteOutput() throws IOException {
    }

    @Override
    protected void writeProductNodesImpl() throws IOException {
        if (this.getOutput() instanceof String) {
            this.filePrefix = (String)this.getOutput();
        } else if (this.getOutput() instanceof File) {
            this.filePrefix = ((File)this.getOutput()).getAbsolutePath();
        }
        Product product = this.getSourceProduct();
        this.writeGeoCoding(product);
    }

    private void writeGeoCoding(Product product) throws IOException {
        if (product.isUsingSingleGeoCoding() && product.getBands().length > 0) {
            this.writeGeoCoding(product.getGeoCoding(), this.filePrefix, String.valueOf(this.filePrefix) + "_" + product.getBands()[0].getName() + ".mpr", product.getBands()[0].getSceneRasterHeight(), product.getBands()[0].getSceneRasterWidth());
        } else {
            Band[] bands = product.getBands();
            int i = 0;
            while (i < bands.length) {
                Band band = bands[i];
                this.writeGeoCoding(band.getGeoCoding(), String.valueOf(this.filePrefix) + "_" + band.getName(), String.valueOf(this.filePrefix) + "_" + band.getName() + ".mpr", band.getSceneRasterHeight(), band.getSceneRasterWidth());
                ++i;
            }
        }
    }

    private void writeGeoCoding(GeoCoding geoCoding, String geoRefFileName, String backgroundMap, int rows, int cols) throws IOException {
        if (geoCoding instanceof TiePointGeoCoding) {
            this.writeGeoCoding((TiePointGeoCoding)geoCoding, geoRefFileName, backgroundMap, rows, cols);
        } else if (geoCoding instanceof MapGeoCoding) {
            this.writeGeoCoding((MapGeoCoding)geoCoding, geoRefFileName, rows, cols);
        } else if (geoCoding instanceof BasicPixelGeoCoding) {
            this.writeGeoCoding((BasicPixelGeoCoding)geoCoding, geoRefFileName, rows, cols);
        } else if (geoCoding instanceof FXYGeoCoding) {
            this.writeGeoCoding((FXYGeoCoding)geoCoding, geoRefFileName, rows, cols);
        } else if (geoCoding instanceof GcpGeoCoding) {
            this.writeGeoCoding((GcpGeoCoding)geoCoding, geoRefFileName, rows, cols);
        } else if (geoCoding instanceof CrsGeoCoding) {
            this.writeGeoCoding((CrsGeoCoding)geoCoding, geoRefFileName, rows, cols);
        }
    }

    private void writeGeoCoding(TiePointGeoCoding geoCoding, String geoRefFileName, String backgroundMap, int rows, int cols) throws IOException {
        GeoRefCTP grctp = new GeoRefCTP(rows, cols);
        TiePointGrid latitudes = geoCoding.getLatGrid();
        TiePointGrid longitudes = geoCoding.getLonGrid();
        float stepX = latitudes.getSubSamplingX();
        float stepY = latitudes.getSubSamplingY();
        float offsetX = latitudes.getOffsetX();
        float offsetY = latitudes.getOffsetY();
        int w = latitudes.getRasterWidth();
        int h = latitudes.getRasterHeight();
        float[] tiePointsLat = latitudes.getTiePoints();
        float[] tiePointsLon = longitudes.getTiePoints();
        int x = 0;
        while (x < w) {
            int y = 0;
            while (y < h) {
                grctp.Add(offsetY + (float)y * stepY, offsetX + (float)x * stepX, tiePointsLon[x + y * w], tiePointsLat[x + y * w]);
                ++y;
            }
            ++x;
        }
        grctp.Store(geoRefFileName, backgroundMap, ILWISProductWriter.getILWISCoordinateSystem(geoCoding));
    }

    private void writeGeoCoding(MapGeoCoding geoCoding, String geoRefFileName, int rows, int cols) {
    }

    private void writeGeoCoding(BasicPixelGeoCoding geoCoding, String geoRefFileName, int rows, int cols) {
    }

    private void writeGeoCoding(FXYGeoCoding geoCoding, String geoRefFileName, int rows, int cols) {
    }

    private void writeGeoCoding(GcpGeoCoding geoCoding, String geoRefFileName, int rows, int cols) {
    }

    private void writeGeoCoding(CrsGeoCoding geoCoding, String geoRefFileName, int rows, int cols) {
    }

    public static String getILWISCoordinateSystem(GeoCoding geoCoding) {
        Datum datum = geoCoding.getDatum();
        datum.getEllipsoid();
        CoordinateReferenceSystem crs = geoCoding.getMapCRS();
        ReferenceIdentifier ref = crs.getName();
        String name = ref.toString();
        if (name.indexOf("WGS84") >= 0) {
            return "LatLonWGS84.csy";
        }
        return "unknown.csy";
    }

    public static String removePath(String filePath) {
        int pos = Math.max(filePath.lastIndexOf(47), filePath.lastIndexOf(92));
        if (pos >= 0) {
            return filePath.substring(pos + 1);
        }
        return filePath;
    }

    private void computeMinMax(byte[] data, MinMax mm) {
        byte[] byArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            byte d = byArray[n2];
            mm.compute(d);
            ++n2;
        }
    }

    private void computeMinMax(short[] data, MinMax mm) {
        short[] sArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            short d = sArray[n2];
            mm.compute(d);
            ++n2;
        }
    }

    private void computeMinMax(int[] data, MinMax mm) {
        int[] nArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            int d = nArray[n2];
            mm.compute(d);
            ++n2;
        }
    }

    private void computeMinMax(float[] data, MinMax mm) {
        float[] fArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            float d = fArray[n2];
            mm.compute(d);
            ++n2;
        }
    }

    private void computeMinMax(double[] data, MinMax mm) {
        double[] dArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            mm.compute(d);
            ++n2;
        }
    }
}

