/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.netcdf3;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.iosp.IospHelper;
import ucar.nc2.iosp.netcdf3.N3streamWriter;

public class N3outputStreamWriter
extends N3streamWriter {
    private int recno = 0;
    private boolean first = true;

    public N3outputStreamWriter(NetcdfFile ncfile) {
        super(ncfile);
    }

    public void writeDataAll(DataOutputStream stream) throws IOException {
        for (N3streamWriter.Vinfo vinfo : this.vinfoList) {
            if (vinfo.isRecord) continue;
            Variable v = vinfo.v;
            assert (this.filePos == (long)vinfo.offset);
            if (this.debugPos) {
                System.out.println(" writing at " + this.filePos + " should be " + vinfo.offset + " " + v.getFullName());
            }
            int nbytes = this.writeDataFast(v, stream, v.read());
            this.filePos += (long)nbytes;
            this.filePos += (long)this.pad(stream, nbytes, (byte)0);
        }
        boolean useRecordDimension = this.ncfile.hasUnlimitedDimension();
        if (useRecordDimension) {
            this.ncfile.sendIospMessage("AddRecordStructure");
        }
        if (useRecordDimension) {
            boolean first = true;
            int nrec = 0;
            Structure recordVar = (Structure)this.ncfile.findVariable("record");
            try (StructureDataIterator ii = recordVar.getStructureIterator();){
                while (ii.hasNext()) {
                    StructureData sdata = ii.next();
                    int count = 0;
                    for (N3streamWriter.Vinfo vinfo : this.vinfoList) {
                        if (!vinfo.isRecord) continue;
                        Variable v = vinfo.v;
                        int nbytes = this.writeDataFast(v, stream, sdata.getArray(v.getShortName()));
                        count += nbytes;
                        count += this.pad(stream, nbytes, (byte)0);
                        if (!first || !this.debugWriteData) continue;
                        System.out.println(v.getShortName() + " wrote " + count + " bytes");
                    }
                    if (first && this.debugWriteData) {
                        System.out.println("wrote " + count + " bytes");
                        first = false;
                    }
                    ++nrec;
                }
            }
            if (this.debugWriteData) {
                System.out.println("wrote " + nrec + " records");
            }
            stream.flush();
            this.ncfile.sendIospMessage("RemoveRecordStructure");
            this.ncfile.finish();
        }
    }

    public void writeNonRecordData(Variable v, DataOutputStream stream, Array data) throws IOException {
        N3streamWriter.Vinfo vinfo = (N3streamWriter.Vinfo)this.vinfoMap.get(v);
        if (this.debugWriteData) {
            System.out.println("Write " + v.getFullName() + " at filePos= " + this.filePos + " vinfo.offset= " + vinfo.offset);
        }
        if (this.filePos != (long)vinfo.offset) {
            throw new IllegalStateException();
        }
        this.filePos += this.writeData(v, stream, data);
        if (vinfo.pad > 0) {
            byte[] dummy = new byte[vinfo.pad];
            stream.write(dummy);
            this.filePos += (long)vinfo.pad;
        }
    }

    public void writeRecordData(DataOutputStream stream, List<Variable> varList) throws IOException {
        long want = (long)this.recStart + (long)this.recno * (long)this.recSize;
        if (this.debugWriteData) {
            System.out.println("Write record at filePos= " + this.filePos + " should be= " + want);
        }
        if (this.filePos != want) {
            throw new IllegalStateException();
        }
        for (Variable v : varList) {
            if (this.first && this.debugWriteData) {
                System.out.println("  write record var " + v.getNameAndDimensions() + " filePos=" + this.filePos);
            }
            this.filePos += this.writeData(v, stream, v.read());
            N3streamWriter.Vinfo vinfo = (N3streamWriter.Vinfo)this.vinfoMap.get(v);
            if (vinfo.pad <= 0) continue;
            byte[] dummy = new byte[vinfo.pad];
            stream.write(dummy);
            this.filePos += (long)vinfo.pad;
        }
        this.first = false;
        ++this.recno;
    }

    private long writeData(Variable v, DataOutputStream stream, Array values) throws IOException {
        DataType dataType = v.getDataType();
        IndexIterator ii = values.getIndexIterator();
        if (dataType == DataType.BYTE) {
            while (ii.hasNext()) {
                stream.write(ii.getByteNext());
            }
            return values.getSize();
        }
        if (dataType == DataType.CHAR) {
            while (ii.hasNext()) {
                stream.write(ii.getByteNext());
            }
            return values.getSize();
        }
        if (dataType == DataType.SHORT) {
            while (ii.hasNext()) {
                stream.writeShort(ii.getShortNext());
            }
            return 2L * values.getSize();
        }
        if (dataType == DataType.INT) {
            while (ii.hasNext()) {
                stream.writeInt(ii.getIntNext());
            }
            return 4L * values.getSize();
        }
        if (dataType == DataType.FLOAT) {
            while (ii.hasNext()) {
                stream.writeFloat(ii.getFloatNext());
            }
            return 4L * values.getSize();
        }
        if (dataType == DataType.DOUBLE) {
            while (ii.hasNext()) {
                stream.writeDouble(ii.getDoubleNext());
            }
            return 8L * values.getSize();
        }
        throw new IllegalStateException("dataType= " + (Object)((Object)dataType));
    }

    private int writeDataFast(Variable v, DataOutputStream stream, Array values) throws IOException {
        DataType dataType = v.getDataType();
        if (dataType == DataType.BYTE) {
            byte[] pa = (byte[])values.get1DJavaArray(Byte.TYPE);
            for (int i = 0; i < pa.length; ++i) {
                stream.write(pa[i]);
            }
            return pa.length;
        }
        if (dataType == DataType.CHAR) {
            byte[] pa = IospHelper.convertCharToByte((char[])values.get1DJavaArray(Character.TYPE));
            for (int i = 0; i < pa.length; ++i) {
                stream.write(pa[i]);
            }
            return pa.length;
        }
        if (dataType == DataType.SHORT) {
            short[] pa = (short[])values.get1DJavaArray(Short.TYPE);
            for (int i = 0; i < pa.length; ++i) {
                stream.writeShort(pa[i]);
            }
            return 2 * pa.length;
        }
        if (dataType == DataType.INT) {
            int[] pa = (int[])values.get1DJavaArray(Integer.TYPE);
            for (int i = 0; i < pa.length; ++i) {
                stream.writeInt(pa[i]);
            }
            return 4 * pa.length;
        }
        if (dataType == DataType.FLOAT) {
            float[] pa = (float[])values.get1DJavaArray(Float.TYPE);
            for (int i = 0; i < pa.length; ++i) {
                stream.writeFloat(pa[i]);
            }
            return 4 * pa.length;
        }
        if (dataType == DataType.DOUBLE) {
            double[] pa = (double[])values.get1DJavaArray(Double.TYPE);
            for (int i = 0; i < pa.length; ++i) {
                stream.writeDouble(pa[i]);
            }
            return 8 * pa.length;
        }
        throw new IllegalStateException("dataType= " + (Object)((Object)dataType));
    }

    public static void writeFromFile(NetcdfFile fileIn, String fileOutName) throws IOException {
        try (DataOutputStream stream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(fileOutName), 10000));){
            N3outputStreamWriter writer = new N3outputStreamWriter(fileIn);
            int numrec = fileIn.getUnlimitedDimension() == null ? 0 : fileIn.getUnlimitedDimension().getLength();
            writer.writeHeader(stream, numrec);
            writer.writeDataAll(stream);
        }
    }

    public static void main(String[] args) throws IOException {
        N3outputStreamWriter.writeFromFile(NetcdfFile.open("C:/data/metars/Surface_METAR_20070331_0000.nc"), "C:/temp/streamOut.nc");
    }
}

