/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import com.google.protobuf.ByteString;
import java.io.IOException;
import org.slf4j.Logger;
import thredds.inventory.MCollection;
import ucar.coord.Coordinate;
import ucar.coord.CoordinateEns;
import ucar.coord.CoordinateRuntime;
import ucar.coord.CoordinateTime;
import ucar.coord.CoordinateTime2D;
import ucar.coord.CoordinateTimeIntv;
import ucar.coord.CoordinateVert;
import ucar.nc2.grib.EnsCoord;
import ucar.nc2.grib.TimeCoord;
import ucar.nc2.grib.VertCoord;
import ucar.nc2.grib.collection.GribCollectionProto;
import ucar.nc2.grib.collection.GribHorizCoordSystem;

class GribCollectionWriter {
    public static final int currentVersion = 1;
    protected final MCollection dcm;
    protected final Logger logger;

    protected GribCollectionWriter(MCollection dcm, Logger logger) {
        this.dcm = dcm;
        this.logger = logger;
    }

    protected GribCollectionProto.Gds writeGdsProto(GribHorizCoordSystem hcs) throws IOException {
        return GribCollectionWriter.writeGdsProto(hcs.getRawGds(), hcs.getPredefinedGridDefinition());
    }

    static GribCollectionProto.Gds writeGdsProto(byte[] rawGds, int predefinedGridDefinition) throws IOException {
        GribCollectionProto.Gds.Builder b = GribCollectionProto.Gds.newBuilder();
        if (predefinedGridDefinition >= 0) {
            b.setPredefinedGridDefinition(predefinedGridDefinition);
        } else {
            b.setGds(ByteString.copyFrom(rawGds));
        }
        return b.build();
    }

    protected GribCollectionProto.Coord writeCoordProto(CoordinateRuntime coord) throws IOException {
        GribCollectionProto.Coord.Builder b = GribCollectionProto.Coord.newBuilder();
        b.setAxisType(GribCollectionWriter.convertAxisType(coord.getType()));
        b.setCode(coord.getCode());
        if (coord.getUnit() != null) {
            b.setUnit(coord.getUnit());
        }
        for (int idx = 0; idx < coord.getSize(); ++idx) {
            long runtime = coord.getRuntime(idx);
            b.addMsecs(runtime);
        }
        return b.build();
    }

    protected GribCollectionProto.Coord writeCoordProto(CoordinateTime coord) throws IOException {
        GribCollectionProto.Coord.Builder b = GribCollectionProto.Coord.newBuilder();
        b.setAxisType(GribCollectionWriter.convertAxisType(coord.getType()));
        b.setCode(coord.getCode());
        b.setUnit(coord.getTimeUnit().toString());
        b.addMsecs(coord.getRefDate().getMillis());
        for (Integer offset : coord.getOffsetSorted()) {
            b.addValues(offset.intValue());
        }
        int[] time2runtime = coord.getTime2runtime();
        if (time2runtime != null) {
            for (int val : time2runtime) {
                b.addTime2Runtime(val);
            }
        }
        return b.build();
    }

    protected GribCollectionProto.Coord writeCoordProto(CoordinateTimeIntv coord) throws IOException {
        GribCollectionProto.Coord.Builder b = GribCollectionProto.Coord.newBuilder();
        b.setAxisType(GribCollectionWriter.convertAxisType(coord.getType()));
        b.setCode(coord.getCode());
        b.setUnit(coord.getTimeUnit().toString());
        b.addMsecs(coord.getRefDate().getMillis());
        for (TimeCoord.Tinv tinv : coord.getTimeIntervals()) {
            b.addValues(tinv.getBounds1());
            b.addBound(tinv.getBounds2());
        }
        int[] time2runtime = coord.getTime2runtime();
        if (time2runtime != null) {
            for (int val : time2runtime) {
                b.addTime2Runtime(val);
            }
        }
        return b.build();
    }

    protected GribCollectionProto.Coord writeCoordProto(CoordinateVert coord) throws IOException {
        GribCollectionProto.Coord.Builder b = GribCollectionProto.Coord.newBuilder();
        b.setAxisType(GribCollectionWriter.convertAxisType(coord.getType()));
        b.setCode(coord.getCode());
        if (coord.getUnit() != null) {
            b.setUnit(coord.getUnit());
        }
        for (VertCoord.Level level : coord.getLevelSorted()) {
            if (coord.isLayer()) {
                b.addValues((float)level.getValue1());
                b.addBound((float)level.getValue2());
                continue;
            }
            b.addValues((float)level.getValue1());
        }
        return b.build();
    }

    protected GribCollectionProto.Coord writeCoordProto(CoordinateEns coord) throws IOException {
        GribCollectionProto.Coord.Builder b = GribCollectionProto.Coord.newBuilder();
        b.setAxisType(GribCollectionWriter.convertAxisType(coord.getType()));
        b.setCode(coord.getCode());
        if (coord.getUnit() != null) {
            b.setUnit(coord.getUnit());
        }
        for (EnsCoord.Coord level : coord.getEnsSorted()) {
            b.addValues(level.getCode());
            b.addBound(level.getEnsMember());
        }
        return b.build();
    }

    protected GribCollectionProto.Coord writeCoordProto(CoordinateTime2D coord) throws IOException {
        GribCollectionProto.Coord.Builder b = GribCollectionProto.Coord.newBuilder();
        b.setAxisType(GribCollectionWriter.convertAxisType(coord.getType()));
        b.setCode(coord.getCode());
        b.setUnit(coord.getTimeUnit().toString());
        CoordinateRuntime runtimeCoord = coord.getRuntimeCoordinate();
        for (int idx = 0; idx < runtimeCoord.getSize(); ++idx) {
            long l = runtimeCoord.getRuntime(idx);
            b.addMsecs(l);
        }
        b.setIsOrthogonal(coord.isOrthogonal());
        b.setIsRegular(coord.isRegular());
        for (Coordinate coordinate : coord.getTimesForSerialization()) {
            if (coordinate.getType() == Coordinate.Type.time) {
                b.addTimes(this.writeCoordProto((CoordinateTime)coordinate));
                continue;
            }
            b.addTimes(this.writeCoordProto((CoordinateTimeIntv)coordinate));
        }
        int[] time2runtime = coord.getTime2runtime();
        if (time2runtime != null) {
            for (int val : time2runtime) {
                b.addTime2Runtime(val);
            }
        }
        return b.build();
    }

    public static GribCollectionProto.GribAxisType convertAxisType(Coordinate.Type type) {
        switch (type) {
            case runtime: {
                return GribCollectionProto.GribAxisType.runtime;
            }
            case time: {
                return GribCollectionProto.GribAxisType.time;
            }
            case time2D: {
                return GribCollectionProto.GribAxisType.time2D;
            }
            case timeIntv: {
                return GribCollectionProto.GribAxisType.timeIntv;
            }
            case ens: {
                return GribCollectionProto.GribAxisType.ens;
            }
            case vert: {
                return GribCollectionProto.GribAxisType.vert;
            }
        }
        throw new IllegalStateException("illegal axis type " + (Object)((Object)type));
    }
}

