/*
 * Decompiled with CFR 0.152.
 */
package org.n52.operation.smac;

import org.n52.math.AbstractAlgorithm;
import org.n52.math.Algorithm;
import org.n52.math.SunTriangulation;
import org.n52.math.TerrainTriangulation;

public class ReflectanceAlgorithm
extends AbstractAlgorithm
implements Algorithm {
    private final double rtoa;
    private static final String[] paramNames = new String[]{"radiance", "lat", "lon"};
    private static final String[] paramDescr = new String[]{"radiance", "latitude in degrees at terrain location", "longitude in degrees at terrain location"};
    private final Algorithm distance;
    private final Algorithm zenithAngle;

    ReflectanceAlgorithm(int year, int month, int day, int hours, int min, double rtoa) {
        this(6378137.0, 298.257223563, year, month, day, hours, min, rtoa);
    }

    ReflectanceAlgorithm(double a, double fInv, int year, int month, int day, int hours, int min, double rtoa) {
        super("Reflectance", "Reflectance based on radiance and position of earth", paramNames, paramDescr);
        TerrainTriangulation terrtria = new TerrainTriangulation(a, fInv);
        this.rtoa = rtoa;
        double time = (double)hours + (double)min / 60.0;
        SunTriangulation sunangle = new SunTriangulation(terrtria, year, month, day, time);
        this.distance = sunangle.getDistanceAlgorithm();
        this.zenithAngle = sunangle.getZenithAngleAlgorithm();
    }

    public double calculate(double[] params) {
        double radiance = params[0];
        double lat = params[1];
        double lon = params[2];
        double[] pars = new double[]{lat, lon};
        double sundist = this.distance.calculate(pars);
        double zenan = this.zenithAngle.calculate(pars) * Math.PI / 180.0;
        double nominator = radiance * sundist * sundist;
        double denominator = this.rtoa * Math.cos(zenan);
        double reflectance = nominator / denominator;
        return reflectance;
    }
}

