/*
 * Decompiled with CFR 0.152.
 */
package org.n52.operation.cropmodeling.test;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import junit.framework.TestCase;
import org.n52.operation.cropmodeling.JulianTime;

public class JulianTimeTest
extends TestCase {
    private JulianTime time;
    private Calendar cal;

    protected void setUp() throws Exception {
        this.time = new JulianTime(52.0, 2001, 4392.0);
        TimeZone zone = TimeZone.getTimeZone("GMT+0");
        this.cal = Calendar.getInstance(zone);
        this.cal.set(2001, 5, 30, 6, 15);
    }

    protected void tearDown() throws Exception {
    }

    public void testJulianTimeDoubleIntDouble() {
        JulianTimeTest.assertEquals((String)"Latitude should be 52", (double)52.0, (double)this.time.getAtLatitude(), (double)0.001);
        JulianTimeTest.assertEquals((String)"Hours from start of year should be 4392 (183*24)", (double)4392.0, (double)this.time.getYearHours(), (double)0.001);
    }

    public void testJulianTimeDoubleCalendar() {
        JulianTime time = new JulianTime(52.0, this.cal);
        JulianTimeTest.assertEquals((String)"Year should be 2000", (int)2001, (int)time.getYear());
        JulianTimeTest.assertEquals((String)"Hours since 1 jan 2000 should be 4326", (double)4326.0, (double)time.getYearHours(), (double)0.001);
    }

    public void testJulianTimeEquals() {
        JulianTime time2 = new JulianTime(52.0, 2001, 4392.0);
        boolean compare = this.time.equals(time2);
        JulianTimeTest.assertTrue((String)"Julian times should be equal", (boolean)compare);
    }

    public void testJulianTimeLess() {
        JulianTime time2 = new JulianTime(52.0, 2001, 4416.0);
        boolean compare = JulianTime.less(this.time, time2);
        JulianTimeTest.assertTrue((String)"time should be smaller than time2", (boolean)compare);
    }

    public void testJulianTimeAdd() {
        JulianTime time2 = JulianTime.add(this.time, 24.0);
        double hours = time2.getYearHours();
        JulianTimeTest.assertEquals((String)"New julian time should be 4416 (184*24)", (double)4416.0, (double)hours, (double)0.001);
    }

    public void testJulianTimeSubtract() {
        JulianTime time2 = JulianTime.subtract(this.time, 24.0);
        double hours = time2.getYearHours();
        JulianTimeTest.assertEquals((String)"New julian time should be 4368 (182*24)", (double)4368.0, (double)hours, (double)0.001);
    }

    public void testJulianTimeGetCurrentDateTime() {
        JulianTime time2 = new JulianTime(52.0, 2001, 3648.0);
        Date date = time2.getCurrentDateTime();
        JulianTimeTest.assertEquals((String)"Sat Jun 02 02:00:00 CEST 2001", (String)date.toString());
    }
}

