/*
 * Decompiled with CFR 0.152.
 */
package org.n52.operation.cropmodeling;

import com.vividsolutions.jts.geom.Coordinate;
import org.n52.operation.cropmodeling.JulianTime;

public class TimeTools {
    protected TimeTools() {
    }

    static double getCCos(double latitude, JulianTime time) {
        double Rad = Math.PI / 180;
        double Dec = -23.45 * Math.cos(Math.PI * 2 * ((double)time.getCurrentJulianDay() + 10.0) / 365.0);
        return Math.cos(latitude * Rad) * Math.cos(Dec * Rad);
    }

    static double getSSin(double latitude, JulianTime time) {
        double Rad = Math.PI / 180;
        double Dec = -23.45 * Math.cos(Math.PI * 2 * ((double)time.getCurrentJulianDay() + 10.0) / 365.0);
        return Math.sin(latitude * Rad) * Math.sin(Dec * Rad);
    }

    static double getSSCC(double latitude, JulianTime time) {
        double Rad = Math.PI / 180;
        double Dec = -23.45 * Math.cos(Math.PI * 2 * ((double)time.getCurrentJulianDay() + 10.0) / 365.0);
        double coscos = Math.cos(latitude * Rad) * Math.cos(Dec * Rad);
        double sinsin = Math.sin(latitude * Rad) * Math.sin(Dec * Rad);
        return sinsin / coscos;
    }

    public static JulianTime getSunRiseToday(Coordinate coord, JulianTime time) {
        double latitude = coord.y;
        double sunRiseTimeToday = (double)time.getCurrentJulianDay() * 24.0 + 12.0 - TimeTools.getDayLength(coord, time) / 2.0;
        return new JulianTime(0.0, time.getYear(), sunRiseTimeToday);
    }

    public static JulianTime getSunSetToday(Coordinate coord, JulianTime time) {
        double latitude = coord.y;
        double sunRiseTimeToday = (double)time.getCurrentJulianDay() * 24.0 + 12.0 + TimeTools.getDayLength(coord, time) / 2.0;
        return new JulianTime(0.0, time.getYear(), sunRiseTimeToday);
    }

    public static double getDayLength(Coordinate coord, JulianTime time) {
        double latitude = coord.y;
        double DayLength = 12.0 * (Math.PI + 2.0 * Math.asin(TimeTools.getSSCC(latitude, time))) / Math.PI;
        return DayLength;
    }
}

