/*
 * Decompiled with CFR 0.152.
 */
package org.n52.operation.cropmodeling;

import org.n52.operation.cropmodeling.JulianTime;
import org.n52.operation.cropmodeling.TimeTemperature;
import org.n52.operation.cropmodeling.WeatherData;

public class SawToothLeg {
    TimeTemperature ttMin;
    TimeTemperature ttMax;

    SawToothLeg() {
        this.ttMin = new TimeTemperature();
        this.ttMax = new TimeTemperature();
    }

    SawToothLeg(JulianTime TiMin, double TempMin, JulianTime TiMax, double TempMax) {
        this.ttMin.setTime(TiMin);
        this.ttMin.setTemperature(TempMin);
        this.ttMax.setTime(TiMax);
        this.ttMax.setTemperature(TempMax);
    }

    TimeTemperature getMinNode() {
        return this.ttMin;
    }

    void setMinNode(TimeTemperature newTemperature) {
        this.ttMin = newTemperature;
    }

    TimeTemperature getMaxNode() {
        return this.ttMax;
    }

    void setMaxNode(TimeTemperature newTemperature) {
        this.ttMax = newTemperature;
    }

    int getLegIndex() {
        JulianTime jt = new JulianTime(this.getMinNode().getTime().getAtLatitude(), this.getMinNode().getTime().getYear(), (this.getMinNode().getTime().getYearHours() + this.getMaxNode().getTime().getYearHours()) / 2.0);
        return jt.getHalfDayIndex();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        if (this.ttMin != null) {
            buf.append(this.ttMin.toString());
        } else {
            buf.append("<null>");
        }
        buf.append(",");
        if (this.ttMax != null) {
            buf.append(this.ttMax.toString());
        } else {
            buf.append("<null>");
        }
        buf.append("]");
        return buf.toString();
    }

    SawToothLeg(JulianTime now, TimeTemperature[] atimetemp, WeatherData data) {
        this.setMaxNode(new TimeTemperature());
        this.setMinNode(new TimeTemperature());
        double tempMin = data.getDayWeatherData(now).getAttributeData("TMin");
        double tempMax = data.getDayWeatherData(now).getAttributeData("TMax");
        if (!Double.isNaN(tempMin) && !Double.isNaN(tempMax)) {
            JulianTime.JulianPeriod period = now.getTimeIntervalBoundaries();
            JulianTime beginDayIndexTime = period.getBeginTime();
            JulianTime endDayIndexTime = period.getEndTime();
            if (now.getHalfDayIndex() % 2 == 0) {
                this.ttMin.setTime(endDayIndexTime);
                this.ttMax.setTime(beginDayIndexTime);
            } else {
                this.ttMin.setTime(beginDayIndexTime);
                this.ttMax.setTime(endDayIndexTime);
            }
            this.ttMin.setTemperature(tempMin);
            this.ttMax.setTemperature(tempMax);
            return;
        }
        this.getMinNode().setTemperature(-1000.0);
        this.getMaxNode().setTemperature(-1000.0);
        int NrObs = atimetemp.length;
        JulianTime[] x = new JulianTime[NrObs];
        double[] y = new double[NrObs];
        double[][] AtA = new double[2][2];
        double[] AtB = new double[2];
        int k = 0;
        while (k < NrObs) {
            x[k] = atimetemp[k].getTime();
            y[k] = atimetemp[k].getTemperature();
            AtA[1][1] = 0.0;
            AtA[1][0] = 0.0;
            AtA[0][1] = 0.0;
            AtA[0][0] = 0.0;
            AtB[1] = 0.0;
            AtB[0] = 0.0;
            ++k;
        }
        k = 0;
        while (k < NrObs) {
            double[] dArray = AtA[0];
            dArray[0] = dArray[0] + x[k].getYearHours() * x[k].getYearHours();
            double[] dArray2 = AtA[1];
            double d = dArray2[0] + x[k].getYearHours();
            dArray2[0] = d;
            AtA[0][1] = d;
            double[] dArray3 = AtA[1];
            dArray3[1] = dArray3[1] + 1.0;
            AtB[0] = AtB[0] + x[k].getYearHours() * y[k];
            AtB[1] = AtB[1] + y[k];
            ++k;
        }
        double detA = AtA[0][0] * AtA[1][1] - AtA[0][1] * AtA[1][0];
        double[][] Inv = new double[2][2];
        Inv[0][0] = AtA[1][1] / detA;
        Inv[0][1] = -AtA[0][1] / detA;
        Inv[1][0] = -AtA[1][0] / detA;
        Inv[1][1] = AtA[0][0] / detA;
        double slope = Inv[0][0] * AtB[0] + Inv[0][1] * AtB[1];
        double intercept = Inv[1][0] * AtB[0] + Inv[1][1] * AtB[1];
        JulianTime tomorrow = JulianTime.add(x[0], 24.0);
        JulianTime ju1 = JulianTime.add(x[0].getMiddayToday(), -24.0);
        JulianTime ju2 = x[0].getSunRiseToday();
        JulianTime ju3 = x[0].getMiddayToday();
        JulianTime ju4 = tomorrow.getSunRiseToday();
        if (JulianTime.less(x[0], ju2)) {
            this.getMinNode().setTime(ju2);
            this.getMinNode().setTemperature(ju2.getYearHours() * slope + intercept);
            this.getMaxNode().setTime(ju1);
            this.getMaxNode().setTemperature(ju1.getYearHours() * slope + intercept);
        } else if (JulianTime.less(x[0], ju3)) {
            this.getMinNode().setTime(ju2);
            this.getMinNode().setTemperature(ju2.getYearHours() * slope + intercept);
            this.getMaxNode().setTime(ju3);
            this.getMaxNode().setTemperature(ju3.getYearHours() * slope + intercept);
        } else {
            this.getMinNode().setTime(ju4);
            this.getMinNode().setTemperature(ju4.getYearHours() * slope + intercept);
            this.getMaxNode().setTime(ju3);
            this.getMaxNode().setTemperature(ju3.getYearHours() * slope + intercept);
        }
    }

    public boolean isValid() {
        return this.ttMin.isValid() && this.ttMax.isValid();
    }
}

