/*
 * Decompiled with CFR 0.152.
 */
package org.n52.operation.cropmodeling;

import org.n52.operation.cropmodeling.JulianTime;
import org.n52.operation.cropmodeling.Weather;

public class Radiation {
    JulianTime MyTime;
    Weather MyWeather;

    public Radiation(JulianTime PTime, Weather PWeather) {
        this.MyTime = PTime;
        this.MyWeather = PWeather;
    }

    double getPhotoSynthActiveOuter() {
        double SolarConstant = 1353.0;
        double Rad = Math.PI / 180;
        double Dec = -23.45 * Math.cos(Math.PI * 2 * (double)(this.MyTime.getCurrentJulianDay() + 10) / 365.0);
        double CCos = Math.cos(this.MyTime.getAtLatitude() * Rad) * Math.cos(Dec * Rad);
        double Ssin = Math.sin(this.MyTime.getAtLatitude() * Rad) * Math.sin(Dec * Rad);
        double Sscc = Ssin / CCos;
        double Rdn = Ssin + 24.0 * CCos * Math.sqrt(1.0 - Sscc * Sscc) / (this.MyTime.getDayLength() * Math.PI);
        double Par = 0.5 * (SolarConstant * (1.0 + 0.033 * Math.cos(Math.PI * 2 * (double)this.MyTime.getCurrentJulianDay() / 365.0))) * Rdn;
        return Par;
    }

    double getPhotoSynthActiveCanopy() {
        double Rha = this.MyWeather.getWeatherData(this.MyTime, "RelativeHumidity");
        double b = 1.25 - Rha;
        double a = 0.29 * Math.cos(Math.PI / 180 * this.MyTime.getAtLatitude());
        double Trans = a + b * this.MyWeather.getWeatherData(this.MyTime, "Sunhours") / this.MyTime.getDayLength();
        double ParCan = this.getPhotoSynthActiveOuter() * Trans;
        return ParCan;
    }

    double getDiffuseRadiation() {
        return 0.0;
    }

    double getDirectRadiation() {
        return 0.0;
    }

    void dailyPhotoActiveRadiation(double hour, double[] result, boolean useGlobal) {
        double rad = 57.29577951308232;
        double sinB = Math.max(0.0, this.MyTime.getSSin() + this.MyTime.getCCos() * (Math.PI * 2 * (hour + 12.0)));
        double dsinB = 3600.0 * (this.MyTime.getDayLength() * this.MyTime.getSSin() + 24.0 * this.MyTime.getCCos() * Math.sqrt(1.0 - this.MyTime.getSSCC() * this.MyTime.getSSCC()) / Math.PI);
        double dsinBe = 3600.0 * (this.MyTime.getDayLength() * (this.MyTime.getSSin() + 0.4 * (this.MyTime.getSSin() * this.MyTime.getSSin() + this.MyTime.getCCos() * this.MyTime.getCCos() * 0.5) + 12.0 * this.MyTime.getCCos() * (2.0 + 1.2000000000000002 * this.MyTime.getSSin()) * Math.sqrt(1.0 - this.MyTime.getSSCC() * this.MyTime.getSSCC()) / Math.PI));
        double solarConstant = 1370.0 * (1.0 + 0.033 * Math.cos(Math.PI * 2 * (double)this.MyTime.getCurrentJulianDay() / 365.0));
        double angot = solarConstant * dsinB;
        double dailyDirectRad = this.MyWeather.getDailyDirectRadiation(this.MyTime);
        double dailyDiffuseRad = this.MyWeather.getDailyDiffuseRadiation(this.MyTime);
        double ffrad = (0.6 + 0.42 * dailyDirectRad / dailyDiffuseRad) / (1.0 + dailyDirectRad / dailyDiffuseRad);
        double photoSyhthRadiationDirect = result[0];
        double photoSyhthRadiationDiffuse = result[1];
        double diffuseLightFraction = 1.0;
        if (useGlobal) {
            double avrad = dailyDirectRad + dailyDiffuseRad;
            double atmosphericTransimission = avrad / angot;
            if (atmosphericTransimission > 0.75) {
                diffuseLightFraction = 0.23;
            } else if (atmosphericTransimission <= 0.75 && atmosphericTransimission > 0.35) {
                diffuseLightFraction = 1.33 - 1.46 * atmosphericTransimission;
            } else if (atmosphericTransimission > 0.07 && atmosphericTransimission <= 0.35) {
                diffuseLightFraction = 1.0 - 2.3 * (atmosphericTransimission - 0.07) * (atmosphericTransimission - 0.07);
            }
            double pAr = ffrad * avrad * sinB * (1.0 + 0.4 * sinB) / dsinBe;
            photoSyhthRadiationDiffuse = Math.min(pAr, sinB * diffuseLightFraction * atmosphericTransimission * ffrad * solarConstant);
            photoSyhthRadiationDirect = pAr - photoSyhthRadiationDiffuse;
        } else {
            photoSyhthRadiationDirect = ffrad * dailyDiffuseRad + sinB * (1.0 + 0.4 * sinB) / dsinBe;
            photoSyhthRadiationDiffuse = ffrad * dailyDirectRad * sinB * (1.0 + 0.4 * sinB) / dsinBe;
        }
        result[0] = photoSyhthRadiationDirect;
        result[1] = photoSyhthRadiationDiffuse;
    }
}

