/*
 * Decompiled with CFR 0.152.
 */
package org.n52.operation.cropmodeling;

import java.util.ArrayList;
import org.n52.operation.cropmodeling.Crop;
import org.n52.operation.cropmodeling.CropData;
import org.n52.operation.cropmodeling.TemporalEnvironmentState;

public class C4Crop
extends Crop {
    public C4Crop(CropData data) {
        super(data);
    }

    double getMaximumAssimilationRate(TemporalEnvironmentState currentState, double temperature) {
        double aMaxRDS = 0.0;
        aMaxRDS = this.getRelativeDevelopmentStage() < 0.5 ? 1.0 : -1.0 * this.getRelativeDevelopmentStage() + 1.5;
        double amx4 = 2.0E-6 * Math.pow(temperature, 4.0);
        double amx3 = 3.0E-4 * Math.pow(temperature, 3.0);
        double amx2 = 0.0152 * Math.pow(temperature, 2.0);
        double amx1 = 0.3525 * temperature;
        double amx0 = 1.996;
        double amx = -amx4 + amx3 - amx2 + amx1 - amx0;
        double AMax = Math.max(0.0, amx * aMaxRDS);
        ArrayList<Double> list = new ArrayList<Double>();
        list.add(temperature);
        list.add(AMax);
        currentState.getCurrentWeather().getWeatherData().writeData(currentState.getTime(), list);
        return AMax;
    }

    double getMaximumAssimilationRate(double ReferenceTemperature, double CurrentTemp) {
        return 0.0;
    }

    public boolean plantIsC3Type() {
        return false;
    }
}

