/*
 * Decompiled with CFR 0.152.
 */
package org.n52.operation;

import org.n52.math.AbstractAlgorithm;
import org.n52.math.Algorithm;

public class NdviAlgorithm
extends AbstractAlgorithm
implements Algorithm {
    private static final String[] paramNames = new String[]{"low", "high"};
    private static final String[] paramDescr = new String[]{"low frequency band", "high frequency band"};

    public NdviAlgorithm() {
        super("NDVI", "Normalized Difference Vegetation Index", paramNames, paramDescr);
    }

    public String getVersion() {
        return "1.0";
    }

    public double calculate(double[] params) {
        double high = params[1];
        double low = params[0];
        double sum = high + low;
        if (sum <= 0.0) {
            return 0.0;
        }
        double ndvi = (high - low) / sum;
        if (ndvi < 0.0) {
            return 0.0;
        }
        if (ndvi > 1.0) {
            return 1.0;
        }
        return ndvi;
    }
}

