/*
 * Decompiled with CFR 0.152.
 */
package org.n52.math.test;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.n52.math.Vector3D;

public class Vector3DTest
extends TestCase {
    private Vector3D v1;
    private Vector3D v2;
    private Vector3D v3;

    public Vector3DTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.v1 = new Vector3D(2.0, 3.0, 5.0);
        this.v2 = new Vector3D(2.0, 3.0, 8.0);
        this.v3 = new Vector3D(2.0, 4.0, -2.0);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testEquals() {
        Assert.assertEquals((Object)((Object)this.v1), (Object)((Object)this.v1));
        Assert.assertTrue((!this.v1.equals((Object)this.v2) ? 1 : 0) != 0);
        Assert.assertTrue((!this.v1.equals(null) ? 1 : 0) != 0);
        Assert.assertEquals((Object)((Object)new Vector3D(2.0, 3.0, 5.0)), (Object)((Object)this.v1));
    }

    public void testDotProduct1() {
        double out12 = this.v1.dotProduct(this.v2);
        Assert.assertEquals((double)53.0, (double)out12, (double)1.0E-9);
    }

    public void testDotProduct2() {
        double out13 = this.v1.dotProduct(this.v3);
        Assert.assertEquals((double)6.0, (double)out13, (double)1.0E-9);
    }

    public void testDotProduct3() {
        double out23 = this.v2.dotProduct(this.v3);
        Assert.assertEquals((double)0.0, (double)out23, (double)1.0E-9);
    }

    public void testDotProduct4() {
        double out22 = this.v2.dotProduct(this.v2);
        Assert.assertEquals((double)77.0, (double)out22, (double)1.0E-9);
    }

    public void testLength() {
        double out22 = this.v2.length();
        Assert.assertEquals((double)Math.sqrt(77.0), (double)out22, (double)1.0E-9);
    }

    public void testPlus1() {
        Vector3D out12 = this.v1.plus(this.v2);
        Vector3D v4 = new Vector3D(4.0, 6.0, 13.0);
        Assert.assertTrue((boolean)out12.equals((Object)v4));
        Assert.assertEquals((Object)((Object)new Vector3D(4.0, 6.0, 13.0)), (Object)((Object)out12));
    }

    public void testPlus2() {
        Vector3D out13 = this.v1.plus(this.v3);
        Assert.assertEquals((Object)((Object)new Vector3D(4.0, 7.0, 3.0)), (Object)((Object)out13));
        Vector3D out23 = this.v2.plus(this.v3);
        Assert.assertEquals((Object)((Object)new Vector3D(4.0, 7.0, 6.0)), (Object)((Object)out23));
        Vector3D out22 = this.v2.plus(this.v2);
        Assert.assertEquals((Object)((Object)new Vector3D(4.0, 6.0, 16.0)), (Object)((Object)out22));
    }

    public void testMinus() {
        Vector3D out12 = this.v1.minus(this.v2);
        Assert.assertEquals((Object)((Object)new Vector3D(0.0, 0.0, -3.0)), (Object)((Object)out12));
        Vector3D out13 = this.v1.minus(this.v3);
        Assert.assertEquals((Object)((Object)new Vector3D(0.0, -1.0, 7.0)), (Object)((Object)out13));
        Vector3D out23 = this.v2.minus(this.v3);
        Assert.assertEquals((Object)((Object)new Vector3D(0.0, -1.0, 10.0)), (Object)((Object)out23));
        Vector3D out22 = this.v2.minus(this.v2);
        Assert.assertEquals((Object)((Object)new Vector3D(0.0, 0.0, 0.0)), (Object)((Object)out22));
    }

    public void testTimes() {
        Vector3D v4 = new Vector3D(2.0, 3.0, -8.5);
        Vector3D out1 = v4.times(3.0);
        Vector3D v01 = new Vector3D(6.0, 9.0, -25.5);
        Assert.assertEquals((Object)((Object)v01), (Object)((Object)out1));
        Vector3D out2 = v4.times(0.0);
        Vector3D v02 = new Vector3D(0.0, 0.0, 0.0);
        Assert.assertEquals((Object)((Object)v02), (Object)((Object)out2));
    }

    public void testCrossProduct() {
        Vector3D v4 = new Vector3D(2.0, 3.0, -8.5);
        Vector3D v5 = new Vector3D(2.0, 3.0, 5.0);
        Vector3D v6 = new Vector3D(6.28, 9.42, 15.7);
        Vector3D out54 = v5.crossProduct(v4);
        Vector3D v54 = new Vector3D(-40.5, 27.0, 0.0);
        Assert.assertEquals((Object)((Object)v54), (Object)((Object)out54));
        Vector3D out45 = v4.crossProduct(v5);
        Vector3D v45 = new Vector3D(40.5, -27.0, 0.0);
        Assert.assertEquals((Object)((Object)v45), (Object)((Object)out45));
        Vector3D out44 = v4.crossProduct(v4);
        Vector3D v04 = new Vector3D(0.0, 0.0, 0.0);
        Assert.assertEquals((Object)((Object)v04), (Object)((Object)out44));
        Vector3D out5_6 = v5.crossProduct(v6);
        Vector3D v56 = new Vector3D(0.0, 0.0, 0.0);
        Assert.assertEquals((Object)((Object)v56), (Object)((Object)out5_6));
    }
}

