/*
 * Decompiled with CFR 0.152.
 */
package org.n52.operation.smac;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import org.n52.math.Algorithm;
import org.n52.operation.smac.RadianceFromDN;

public class RadianceFromDNforMSG {
    double[] slope = new double[12];
    double[] offset = new double[12];

    public RadianceFromDNforMSG(String prologueFileName) throws IOException {
        FileInputStream fis = new FileInputStream(prologueFileName);
        DataInputStream dis = new DataInputStream(fis);
        try {
            dis.skip(387155L);
            int i = 0;
            while (i < 12) {
                this.slope[i] = dis.readDouble();
                this.offset[i] = dis.readDouble();
                ++i;
            }
        }
        finally {
            dis.close();
        }
    }

    public Algorithm getRadianceFromDN(int channel) {
        int index = channel - 1;
        return new RadianceFromDN(this.slope[index], this.offset[index]);
    }
}

