/*
 * Decompiled with CFR 0.152.
 */
package org.n52.operation.cropmodeling;

import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class JulianTime
implements Cloneable {
    private int currentYear;
    protected double currentJulianTime;
    private double currentLatitude;

    public double getDayLength() {
        double DayLength = 12.0 * (Math.PI + 2.0 * Math.asin(this.getSSCC())) / Math.PI;
        return DayLength;
    }

    double getCCos() {
        double Rad = Math.PI / 180;
        double Dec = -23.45 * Math.cos(Math.PI * 2 * ((double)this.getCurrentJulianDay() + 10.0) / 365.0);
        return Math.cos(this.currentLatitude * Rad) * Math.cos(Dec * Rad);
    }

    double getSSin() {
        double Rad = Math.PI / 180;
        double Dec = -23.45 * Math.cos(Math.PI * 2 * ((double)this.getCurrentJulianDay() + 10.0) / 365.0);
        return Math.sin(this.currentLatitude * Rad) * Math.sin(Dec * Rad);
    }

    double getSSCC() {
        return this.getSSin() / this.getCCos();
    }

    public JulianTime(double latitude, int year, double time) {
        this.currentLatitude = latitude;
        this.currentJulianTime = time;
        this.currentYear = year;
    }

    public JulianTime(double latitude, Calendar dt) {
        this.currentLatitude = latitude;
        this.currentYear = dt.get(1);
        TimeZone zone = TimeZone.getTimeZone("GMT+0");
        Calendar cal = Calendar.getInstance(zone);
        cal.set(this.currentYear, 0, 1, 0, 0, 0);
        cal.getTimeInMillis();
        double hr1 = dt.getTimeInMillis() / 3600000L;
        double hr2 = cal.getTimeInMillis() / 3600000L;
        this.currentJulianTime = hr1 - hr2;
    }

    public JulianTime clone() {
        return new JulianTime(this.getAtLatitude(), this.getYear(), this.getYearHours());
    }

    public static JulianTime add(JulianTime time1, double time2) {
        return new JulianTime(time1.getAtLatitude(), time1.getYear(), time1.getYearHours() + time2);
    }

    public static JulianTime subtract(JulianTime time1, double time2) {
        return new JulianTime(time1.getAtLatitude(), time1.getYear(), time1.getYearHours() - time2);
    }

    public static JulianTime divide(JulianTime time1, double divider) {
        return new JulianTime(time1.getAtLatitude(), time1.getYear(), time1.getYearHours() / divider);
    }

    public static boolean less(JulianTime time1, JulianTime time2) {
        if (time1.getYear() < time2.getYear()) {
            return true;
        }
        if (time1.getYear() == time2.getYear()) {
            return time1.getYearHours() < time2.getYearHours();
        }
        return false;
    }

    public static boolean lesseq(JulianTime time1, JulianTime time2) {
        if (time1.getYear() < time2.getYear()) {
            return true;
        }
        if (time1.getYear() == time2.getYear()) {
            if (Math.abs(time1.getYearHours() - time2.getYearHours()) < 2.777777777777778E-4) {
                return true;
            }
            return time1.getYearHours() <= time2.getYearHours();
        }
        return false;
    }

    public static boolean more(JulianTime time1, JulianTime time2) {
        if (time1.getYear() > time2.getYear()) {
            return true;
        }
        if (time1.getYear() == time2.getYear()) {
            return time1.getYearHours() > time2.getYearHours();
        }
        return false;
    }

    public static boolean moreeq(JulianTime time1, JulianTime time2) {
        if (time1.getYear() > time2.getYear()) {
            return true;
        }
        if (time1.getYear() == time2.getYear()) {
            if (Math.abs(time1.getYearHours() - time2.getYearHours()) < 2.777777777777778E-4) {
                return true;
            }
            return time1.getYearHours() >= time2.getYearHours();
        }
        return false;
    }

    public static boolean eq(JulianTime time1, JulianTime time2) {
        if (time1.getYear() != time2.getYear()) {
            return false;
        }
        return Math.abs(time1.getYearHours() - time2.getYearHours()) < 2.777777777777778E-4;
    }

    public static boolean ineq(JulianTime time1, JulianTime time2) {
        if (time1.getYear() != time2.getYear()) {
            return true;
        }
        return Math.abs(time1.getYearHours() - time2.getYearHours()) >= 2.777777777777778E-4;
    }

    public boolean equals(Object obj) {
        JulianTime time = (JulianTime)obj;
        return this.getYearHours() == time.getYearHours() && time.getYear() == this.getYear();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public int getCurrentJulianDay() {
        return (int)(this.currentJulianTime / 24.0);
    }

    public double getAtLatitude() {
        return this.currentLatitude;
    }

    public void setAtLatitude(double newLat) {
        this.currentLatitude = newLat;
    }

    public int getHalfDayIndex() {
        int index = JulianTime.less(this, this.getSunRiseToday()) ? 2 * this.getCurrentJulianDay() : (JulianTime.less(this, this.getMiddayToday()) ? 2 * this.getCurrentJulianDay() + 1 : 2 * this.getCurrentJulianDay() + 2);
        return index;
    }

    public double getYearHours() {
        return this.currentJulianTime;
    }

    public void setYearHours(double newTime) {
        this.currentJulianTime = newTime;
    }

    public int getYear() {
        return this.currentYear;
    }

    public void setYear(int newYear) {
        this.currentYear = newYear;
    }

    JulianTime getMostRecentSunRise() {
        JulianTime sameTimeYesterday = new JulianTime(this.currentLatitude, this.currentYear, this.currentJulianTime - 24.0);
        double dayLengthYesterday = sameTimeYesterday.getDayLength();
        double sunRiseTimeYesterday = (double)this.getCurrentJulianDay() * 24.0 - 12.0 - dayLengthYesterday / 2.0;
        double sunRiseTimeToday = (double)this.getCurrentJulianDay() * 24.0 + 12.0 - this.getDayLength() / 2.0;
        if (sunRiseTimeToday < this.currentJulianTime) {
            return new JulianTime(this.currentLatitude, this.currentYear, sunRiseTimeToday);
        }
        return new JulianTime(this.currentLatitude, this.currentYear, sunRiseTimeYesterday);
    }

    JulianTime getSunRiseToday() {
        double sunRiseTimeToday = (double)this.getCurrentJulianDay() * 24.0 + 12.0 - this.getDayLength() / 2.0;
        return new JulianTime(this.currentLatitude, this.currentYear, sunRiseTimeToday);
    }

    JulianTime getSunSetToday() {
        double sunRiseTimeToday = (double)this.getCurrentJulianDay() * 24.0 + 12.0 + this.getDayLength() / 2.0;
        return new JulianTime(this.currentLatitude, this.currentYear, sunRiseTimeToday);
    }

    JulianTime getMostRecent2oClockPM() {
        double twoPMYesterday = (double)((int)this.currentJulianTime / 24 * 24) - 10.0;
        double twoPM = (double)((int)this.currentJulianTime / 24 * 24) + 14.0;
        if (twoPM < this.currentJulianTime) {
            return new JulianTime(this.currentLatitude, this.currentYear, twoPM);
        }
        return new JulianTime(this.currentLatitude, this.currentYear, twoPMYesterday);
    }

    JulianTime Get12pmYesterday() {
        double twelvePMY = (double)((int)this.currentJulianTime / 24 * 24) + 0.0;
        return new JulianTime(this.currentLatitude, this.currentYear, twelvePMY);
    }

    JulianTime get12pmToday() {
        double twelvePMToday = (double)((int)this.currentJulianTime / 24 * 24) + 24.0;
        return new JulianTime(this.currentLatitude, this.currentYear, twelvePMToday);
    }

    JulianTime getMiddayToday() {
        double twoPM = (double)((int)this.currentJulianTime / 24 * 24) + 14.0;
        return new JulianTime(this.currentLatitude, this.currentYear, twoPM);
    }

    JulianTime getTwoPmToday() {
        double twoPM = (double)((int)this.currentJulianTime / 24 * 24) + 14.0;
        return new JulianTime(this.currentLatitude, this.currentYear, twoPM);
    }

    JulianTime getTimeInNextInterval() {
        JulianTime tSunRise = this.getSunRiseToday();
        JulianTime timeInNextInterval = JulianTime.less(this, tSunRise) ? JulianTime.subtract(this.getMiddayToday(), 1.0) : (JulianTime.less(this, this.getMiddayToday()) ? JulianTime.add(this.getMiddayToday(), 1.0) : JulianTime.add(this.getMiddayToday(), 23.0));
        return timeInNextInterval;
    }

    JulianTime getTimeInPreviousInterval() {
        JulianTime tSunRise = this.getSunRiseToday();
        JulianTime timeInPreviousInterval = JulianTime.less(this, tSunRise) ? JulianTime.subtract(this.getMiddayToday(), 25.0) : (JulianTime.less(this, this.getMiddayToday()) ? JulianTime.subtract(tSunRise, 1.0) : JulianTime.subtract(this.getMiddayToday(), 1.0));
        return timeInPreviousInterval;
    }

    public Date getCurrentDateTime() {
        TimeZone zone = TimeZone.getTimeZone("GMT+0");
        Calendar cal = Calendar.getInstance(zone);
        long millis = (long)(this.getYearHours() * 3600000.0);
        cal.setTimeInMillis(millis);
        cal.set(1, this.currentYear);
        return cal.getTime();
    }

    JulianPeriod getTimeIntervalBoundaries() {
        JulianTime secondMoment;
        JulianTime firstMoment;
        JulianTime juSun = this.getSunRiseToday();
        JulianTime ju2pm = this.getMiddayToday();
        JulianTime tomorrow = JulianTime.add(this.getSunRiseToday(), 24.0);
        if (JulianTime.less(this, juSun)) {
            firstMoment = JulianTime.subtract(ju2pm, 24.0);
            secondMoment = juSun;
        } else if (JulianTime.less(this, ju2pm)) {
            firstMoment = juSun;
            secondMoment = ju2pm;
        } else {
            firstMoment = ju2pm;
            secondMoment = tomorrow.getSunRiseToday();
        }
        return new JulianPeriod(firstMoment, secondMoment);
    }

    public String toString() {
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setMaximumFractionDigits(3);
        return String.valueOf(Integer.toString(this.currentYear)) + "-" + Integer.toString((int)(this.currentJulianTime / 24.0)) + "-" + format.format(this.currentJulianTime - (double)((int)this.currentJulianTime / 24 * 24));
    }

    class JulianPeriod {
        JulianTime beginTime;
        JulianTime endTime;

        public String toString() {
            return String.valueOf(this.beginTime.toString()) + "," + this.endTime.toString();
        }

        public JulianPeriod(JulianTime begin, JulianTime end) {
            this.beginTime = begin;
            this.endTime = end;
        }

        public JulianTime getBeginTime() {
            return this.beginTime;
        }

        public void setBeginTime(JulianTime beginTime) {
            this.beginTime = beginTime;
        }

        public JulianTime getEndTime() {
            return this.endTime;
        }

        public void setEndTime(JulianTime endTime) {
            this.endTime = endTime;
        }
    }
}

