/*
 * Decompiled with CFR 0.152.
 */
package org.n52.operation.cropmodeling;

import java.util.Hashtable;
import org.n52.operation.cropmodeling.C3Crop;
import org.n52.operation.cropmodeling.C4Crop;
import org.n52.operation.cropmodeling.Crop;
import org.n52.operation.cropmodeling.CropData;
import org.n52.operation.cropmodeling.GrowthParameters;
import org.n52.operation.cropmodeling.JulianTime;
import org.n52.operation.cropmodeling.SpatialLocationCell;
import org.n52.operation.cropmodeling.SpatialLocationCellCollection;
import org.n52.operation.cropmodeling.TemporalEnvironmentState;
import org.n52.operation.cropmodeling.WeatherData;

public class GrowthProcess {
    private CropData dataCrop;
    GrowthParameters growthParameters;
    private Hashtable cropEvolution;
    public static final double UNDEF = Double.NaN;

    public GrowthProcess(GrowthParameters gp) {
        try {
            this.growthParameters = gp;
            this.cropEvolution = new Hashtable();
            this.dataCrop = new CropData(this.growthParameters.getCropDataSource(), this.growthParameters.getCrop());
            this.growthParameters.getBeginSimulationPeriod();
            this.growthParameters.getEndSimulationPeriod();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void RunSimulation() {
        try {
            if (this.growthParameters.getSpatialDataType() == "") {
                this.RunSimulationForGridCell(null);
            }
            SpatialLocationCellCollection col = SpatialLocationCellCollection.create(this.growthParameters);
            for (SpatialLocationCell cell : col) {
                this.RunSimulationForGridCell(cell);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void RunSimulationForGridCell(SpatialLocationCell cell) {
        WeatherData weatherData = WeatherData.create(this.growthParameters, cell);
        TemporalEnvironmentState startGrowth = new TemporalEnvironmentState(this.growthParameters.getWeatherMethod(), weatherData, this.growthParameters.getYear(), this.growthParameters.getBeginSimulationPeriod());
        TemporalEnvironmentState endGrowth = new TemporalEnvironmentState(this.growthParameters.getWeatherMethod(), weatherData, this.growthParameters.getYear(), this.growthParameters.getEndSimulationPeriod());
        Crop cropPrevious = new Crop(this.dataCrop);
        TemporalEnvironmentState currentMoment = startGrowth;
        while (JulianTime.less(currentMoment.getTime(), endGrowth.getTime())) {
            Crop cropCurrent = this.dataCrop.isC3Crop() ? new C3Crop(this.dataCrop) : new C4Crop(this.dataCrop);
            cropCurrent.setPreviousCropState(cropPrevious);
            cropCurrent.calculateCropState(currentMoment);
            this.cropEvolution.put(currentMoment.getTime(), cropCurrent);
            cropPrevious = cropCurrent;
            TemporalEnvironmentState.increment(currentMoment);
        }
        weatherData.Update();
    }

    public Crop getCrop(JulianTime time) {
        return (Crop)this.cropEvolution.get(time);
    }
}

