/*
 * Decompiled with CFR 0.152.
 */
package org.n52.operation.cropmodeling;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import org.n52.operation.cropmodeling.AttributeData;

public class CropData
extends AttributeData {
    double[][] pSAllocation;
    double[] relativeMaintenanceRespiration;
    double[] conversionEfficiency;
    boolean c3Crop;

    public CropData(String dataFileName, String cropName) {
        if (dataFileName == null || dataFileName.length() == 0) {
            throw new IllegalArgumentException("Must specify a valid file name");
        }
        if (cropName == null || cropName.length() == 0) {
            throw new IllegalArgumentException("Must specify a valid crop type name");
        }
        FileInputStream input = null;
        try {
            input = new FileInputStream(dataFileName);
        }
        catch (FileNotFoundException e) {
            File file = new File(dataFileName);
            String string = file.getAbsoluteFile().getParent();
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        this.c3Crop = true;
        this.relativeMaintenanceRespiration = new double[4];
        this.conversionEfficiency = new double[4];
        this.name = this.findCrop(reader, cropName);
        String[] parts = this.getAttributes(reader);
        this.partsCheck(parts, 9);
        if (parts[0] == "C4") {
            this.c3Crop = false;
        }
        this.attributes.put("ThresholdTemperature", Double.parseDouble(parts[1]));
        this.attributes.put("HeatRequirement", Double.parseDouble(parts[2]));
        this.attributes.put("HeatRequirementLeaves", Double.parseDouble(parts[3]));
        parts = this.getAttributes(reader);
        this.partsCheck(parts, 9);
        this.attributes.put("MaxSpecificLeafArea", Double.parseDouble(parts[0]));
        this.attributes.put("MinSpecificLeafArea", Double.parseDouble(parts[1]));
        this.attributes.put("ExtinctionCoefficient", Double.parseDouble(parts[2]));
        int i = 4;
        while (i <= 7) {
            this.relativeMaintenanceRespiration[i - 4] = Double.parseDouble(parts[i]);
            ++i;
        }
        parts = this.getAttributes(reader);
        this.partsCheck(parts, 8);
        this.conversionEfficiency[0] = Double.parseDouble(parts[0]);
        this.conversionEfficiency[1] = Double.parseDouble(parts[1]);
        this.conversionEfficiency[2] = Double.parseDouble(parts[2]);
        this.conversionEfficiency[3] = Double.parseDouble(parts[3]);
        parts = this.getAttributes(reader);
        String[] RDSs = this.getAttributes(reader);
        this.pSAllocation = new double[5][RDSs.length];
        int stage = 0;
        while (stage < RDSs.length) {
            this.pSAllocation[0][stage] = Double.parseDouble(RDSs[stage]);
            ++stage;
        }
        int Organ = 0;
        while (Organ < 4) {
            parts = this.getAttributes(reader);
            this.partsCheck(parts, 6);
            int Stage = 0;
            while (Stage < RDSs.length) {
                this.pSAllocation[Organ + 1][Stage] = Double.parseDouble(parts[Organ]);
                ++Stage;
            }
            ++Organ;
        }
        try {
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void partsCheck(String[] parts, int expectedNumber) {
        if (parts.length != expectedNumber) {
            return;
        }
    }

    String findCrop(BufferedReader reader, String cropName) {
        String line = "";
        try {
            while (!line.equalsIgnoreCase(cropName)) {
                line = reader.readLine();
                if (line == null || line.length() == 0) {
                    return "";
                }
                if (line.charAt(0) != '\"') continue;
                line = line.substring(1, line.length() - 1);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return line;
    }

    public double getAllocatedMassFraction(int organIndex, double relativeDevelopmentStage) {
        int stage = 0;
        while (stage < this.pSAllocation[0].length) {
            if (this.pSAllocation[0][stage] > relativeDevelopmentStage) {
                int selectedStage = stage - 1;
                return this.pSAllocation[organIndex + 1][selectedStage];
            }
            ++stage;
        }
        return Double.NaN;
    }

    public double getIndexedAttribute(String attributeName, int index) {
        if (attributeName.equals("MaintenanceRespiration")) {
            return this.relativeMaintenanceRespiration[index];
        }
        if (attributeName.equals("ConversionEfficiency")) {
            return this.conversionEfficiency[index];
        }
        return super.getIndexedAttribute(attributeName, index);
    }

    public boolean isC3Crop() {
        return this.c3Crop;
    }
}

