# __init__ for osgeo package.

# unofficial Windows binaries: set GDAL environment variables if necessary
import os

try:
    if 'GDAL_DATA' not in os.environ:
        os.environ['GDAL_DATA'] = os.path.join(os.path.dirname(__file__), 'data', 'gdal')
        # uncomment the next line to enable plugins
        #os.environ['GDAL_DRIVER_PATH'] = os.path.join(os.path.dirname(__file__), 'gdalplugins')
        os.environ['PATH'] = os.path.dirname(__file__) + ';' + os.environ['PATH']
except Exception:
    pass

del os

# making the osgeo package version the same as the gdal version:
from sys import version_info
if version_info >= (2,6,0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_gdal', [dirname(__file__)])
        except ImportError:
            import _gdal
            return _gdal
        if fp is not None:
            try:
                _mod = imp.load_module('_gdal', fp, pathname, description)
            finally:
                fp.close()
            return _mod
    _gdal = swig_import_helper()
    del swig_import_helper
else:
    import _gdal

__version__ = _gdal.__version__ = _gdal.VersionInfo("RELEASE_NAME")

