import os
import sys

path = os.path.dirname(__file__)
os.environ["PATH"] = path + os.pathsep + os.environ["PATH"]
sys.path.append(path)
# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""The Python API for ILWIS Objects"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_ilwisobjects')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_ilwisobjects')
    _ilwisobjects = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_ilwisobjects', [dirname(__file__)])
        except ImportError:
            import _ilwisobjects
            return _ilwisobjects
        try:
            _mod = imp.load_module('_ilwisobjects', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _ilwisobjects = swig_import_helper()
    del swig_import_helper
else:
    import _ilwisobjects
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0


IlwisException = _ilwisobjects.IlwisException
InvalidObjectException = _ilwisobjects.InvalidObjectException
FeatureCreationError = _ilwisobjects.FeatureCreationError
try:
    if not path is None:
        if not _ilwisobjects._initIlwisObjects(path):
            raise ImportError("ILWIS couldn't be initialized!")
except NameError:
    if not _ilwisobjects._initIlwisObjects(""):
        raise ImportError("ILWIS couldn't be initialized!")


def _initIlwisObjects(ilwisDir):
    """_initIlwisObjects(char const * ilwisDir) -> bool"""
    return _ilwisobjects._initIlwisObjects(ilwisDir)

def _exitIlwisObjects():
    """_exitIlwisObjects()"""
    return _ilwisobjects._exitIlwisObjects()

def disconnectIssueLogger():
    """disconnectIssueLogger()"""
    return _ilwisobjects.disconnectIssueLogger()

def connectIssueLogger():
    """connectIssueLogger()"""
    return _ilwisobjects.connectIssueLogger()
class it(_object):
    """Proxy of C++ pythonapi::it class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, it, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, it, name)
    __repr__ = _swig_repr
    FEATURE = _ilwisobjects.it_FEATURE
    RASTER = _ilwisobjects.it_RASTER
    COVERAGE = _ilwisobjects.it_COVERAGE
    TABLE = _ilwisobjects.it_TABLE
    GEOREF = _ilwisobjects.it_GEOREF
    COORDSYSTEM = _ilwisobjects.it_COORDSYSTEM
    ILWDOMAIN = _ilwisobjects.it_ILWDOMAIN
    NUMERICDOMAIN = _ilwisobjects.it_NUMERICDOMAIN
    ITEMDOMAIN = _ilwisobjects.it_ITEMDOMAIN
    SINGLEOPERATION = _ilwisobjects.it_SINGLEOPERATION
    WORKFLOW = _ilwisobjects.it_WORKFLOW
    PROJECTION = _ilwisobjects.it_PROJECTION
    ELLIPSOID = _ilwisobjects.it_ELLIPSOID
    CATALOG = _ilwisobjects.it_CATALOG
    CONTINUOUSCOLOR = _ilwisobjects.it_CONTINUOUSCOLOR
    PALETTECOLOR = _ilwisobjects.it_PALETTECOLOR
    VALUERANGE = _ilwisobjects.it_VALUERANGE
    COLLECTION = _ilwisobjects.it_COLLECTION
    ANY = _ilwisobjects.it_ANY

    def __init__(self):
        """__init__(pythonapi::it self) -> it"""
        this = _ilwisobjects.new_it()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _ilwisobjects.delete_it
    __del__ = lambda self: None
it_swigregister = _ilwisobjects.it_swigregister
it_swigregister(it)


def object_cast(obj):
    type = obj.ilwisType()
    if it.RASTER & type != 0:
        return RasterCoverage.toRasterCoverage(obj)
    elif it.FEATURE & type != 0:
        return FeatureCoverage.toFeatureCoverage(obj)
    elif it.GEOREF & type != 0:
        return GeoReference.toGeoReference(obj)
    elif it.TABLE & type != 0:
        return Table.toTable(obj)
    elif it.NUMERICDOMAIN & type != 0:
      return NumericDomain.toNumericDomain(obj)
    elif it.ILWDOMAIN & type != 0:
      return Domain.toDomain(obj)
    elif it.COORDSYSTEM & type != 0:
        return CoordinateSystem.toCoordinateSystem(obj)
#    elif it.OPERATIONMETADATA & type != 0:
#        return OperationMetaData.toOperationMetaData(obj)
#    elif it.PROJECTION & type != 0:
#        return Projection.toProjection(obj)
#    elif it.ELLIPSOID & type != 0:
#        return Ellipsoid.toEllipsoid(obj)
    elif it.CATALOG & type != 0:
        return Catalog.toCatalog(obj)
    elif it.COLLECTION & type != 0:
        return Collection.toCollection(obj)
    elif type == 0:
        raise TypeError("unknown IlwisType")
    else:
        return obj

class Object(_object):
    """Proxy of C++ pythonapi::Object class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Object, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Object, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _ilwisobjects.delete_Object
    __del__ = lambda self: None

    def __bool__(self):
        """__bool__(Object self) -> bool"""
        return _ilwisobjects.Object___bool__(self)


    def __str__(self):
        """__str__(Object self) -> std::string"""
        return _ilwisobjects.Object___str__(self)


    def ilwisType(self):
        """ilwisType(Object self) -> IlwisTypes"""
        return _ilwisobjects.Object_ilwisType(self)

Object_swigregister = _ilwisobjects.Object_swigregister
Object_swigregister(Object)

class Engine(_object):
    """Proxy of C++ pythonapi::Engine class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Engine, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Engine, name)
    __repr__ = _swig_repr

    def __init__(self):
        """__init__(pythonapi::Engine self) -> Engine"""
        this = _ilwisobjects.new_Engine()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def _do2(*args):
        """
        _do2(std::string output_name, std::string operation, std::string c3, std::string c4, std::string c5, std::string c6, std::string c7, std::string c8, std::string c9, std::string c10, std::string c11) -> qint64
        _do2(std::string output_name, std::string operation, std::string c3, std::string c4, std::string c5, std::string c6, std::string c7, std::string c8, std::string c9, std::string c10) -> qint64
        _do2(std::string output_name, std::string operation, std::string c3, std::string c4, std::string c5, std::string c6, std::string c7, std::string c8, std::string c9) -> qint64
        _do2(std::string output_name, std::string operation, std::string c3, std::string c4, std::string c5, std::string c6, std::string c7, std::string c8) -> qint64
        _do2(std::string output_name, std::string operation, std::string c3, std::string c4, std::string c5, std::string c6, std::string c7) -> qint64
        _do2(std::string output_name, std::string operation, std::string c3, std::string c4, std::string c5, std::string c6) -> qint64
        _do2(std::string output_name, std::string operation, std::string c3, std::string c4, std::string c5) -> qint64
        _do2(std::string output_name, std::string operation, std::string c3, std::string c4) -> qint64
        _do2(std::string output_name, std::string operation, std::string c3) -> qint64
        _do2(std::string output_name, std::string operation) -> qint64
        """
        return _ilwisobjects.Engine__do2(*args)

    _do2 = staticmethod(_do2)

    def _do(*args):
        """
        _do(std::string output_name, std::string operation, std::string c3, std::string c4, std::string c5, std::string c6, std::string c7, std::string c8, std::string c9, std::string c10, std::string c11) -> Object
        _do(std::string output_name, std::string operation, std::string c3, std::string c4, std::string c5, std::string c6, std::string c7, std::string c8, std::string c9, std::string c10) -> Object
        _do(std::string output_name, std::string operation, std::string c3, std::string c4, std::string c5, std::string c6, std::string c7, std::string c8, std::string c9) -> Object
        _do(std::string output_name, std::string operation, std::string c3, std::string c4, std::string c5, std::string c6, std::string c7, std::string c8) -> Object
        _do(std::string output_name, std::string operation, std::string c3, std::string c4, std::string c5, std::string c6, std::string c7) -> Object
        _do(std::string output_name, std::string operation, std::string c3, std::string c4, std::string c5, std::string c6) -> Object
        _do(std::string output_name, std::string operation, std::string c3, std::string c4, std::string c5) -> Object
        _do(std::string output_name, std::string operation, std::string c3, std::string c4) -> Object
        _do(std::string output_name, std::string operation, std::string c3) -> Object
        _do(std::string output_name, std::string operation) -> Object
        """
        return _ilwisobjects.Engine__do(*args)

    _do = staticmethod(_do)

    def setWorkingCatalog(location):
        """setWorkingCatalog(std::string const & location)"""
        return _ilwisobjects.Engine_setWorkingCatalog(location)

    setWorkingCatalog = staticmethod(setWorkingCatalog)

    def getLocation():
        """getLocation() -> std::string"""
        return _ilwisobjects.Engine_getLocation()

    getLocation = staticmethod(getLocation)

    def operations():
        """operations() -> PyObject *"""
        return _ilwisobjects.Engine_operations()

    operations = staticmethod(operations)

    def operationMetaData(*args):
        """
        operationMetaData(std::string const & name, std::string const & element) -> std::string
        operationMetaData(std::string const & name) -> std::string
        """
        return _ilwisobjects.Engine_operationMetaData(*args)

    operationMetaData = staticmethod(operationMetaData)

    def _catalogItems(filter):
        """_catalogItems(quint64 filter) -> PyObject *"""
        return _ilwisobjects.Engine__catalogItems(filter)

    _catalogItems = staticmethod(_catalogItems)

    @staticmethod
    def do(operation,arg1="",arg2="",arg3="",arg4="",arg5="",arg6="",arg7="",arg8="",arg9="",out=""):
        if str(operation) != "":
            if (type(arg1)==str and len(arg1) > 0):
                arg1 = "'" + arg1 + "'"
            if (type(arg2)==str and len(arg2) > 0):
                arg2 = "'" + arg2 + "'"
            if (type(arg3)==str and len(arg3) > 0):
                arg3 = "'" + arg3 + "'"
            if (type(arg4)==str and len(arg4) > 0):
                arg4 = "'" + arg4 + "'"
            if (type(arg5)==str and len(arg5) > 0):
                arg5 = "'" + arg5 + "'"
            if (type(arg6)==str and len(arg6) > 0):
                arg6 = "'" + arg6 + "'"
            if (type(arg7)==str and len(arg7) > 0):
                arg7 = "'" + arg7 + "'"
            if (type(arg8)==str and len(arg8) > 0):
                arg8 = "'" + arg8 + "'"
            if (type(arg9)==str and len(arg9) > 0):
                arg9 = "'" + arg9 + "'"
            obj = Engine__do(str(out),str(operation),str(arg1),str(arg2),str(arg3),str(arg4),str(arg5),str(arg6),str(arg7),str(arg8),str(arg9))
        else:
            raise IlwisException("no operation given!")
        return object_cast(obj)

    @staticmethod
    def do2(operation,arg1="",arg2="",arg3="",arg4="",arg5="",arg6="",arg7="",arg8="",arg9="",out=""):
        if str(operation) != "":
            if (type(arg1)==str and len(arg1) > 0):
                arg1 = "'" + arg1 + "'"
            if (type(arg2)==str and len(arg2) > 0):
                arg2 = "'" + arg2 + "'"
            if (type(arg3)==str and len(arg3) > 0):
                arg3 = "'" + arg3 + "'"
            if (type(arg4)==str and len(arg4) > 0):
                arg4 = "'" + arg4 + "'"
            if (type(arg5)==str and len(arg5) > 0):
                arg5 = "'" + arg5 + "'"
            if (type(arg6)==str and len(arg6) > 0):
                arg6 = "'" + arg6 + "'"
            if (type(arg7)==str and len(arg7) > 0):
                arg7 = "'" + arg7 + "'"
            if (type(arg8)==str and len(arg8) > 0):
                arg8 = "'" + arg8 + "'"
            if (type(arg9)==str and len(arg9) > 0):
                arg9 = "'" + arg9 + "'"
            obj = Engine__do2(str(out),str(operation),str(arg1),str(arg2),str(arg3),str(arg4),str(arg5),str(arg6),str(arg7),str(arg8),str(arg9))
        else:
            raise IlwisException("no operation given!")
        return obj

    @staticmethod
    def catalogItems(filter):
        return sorted(Engine__catalogItems(filter), key = str.lower)

    __swig_destroy__ = _ilwisobjects.delete_Engine
    __del__ = lambda self: None
Engine_swigregister = _ilwisobjects.Engine_swigregister
Engine_swigregister(Engine)

def Engine__do2(*args):
    """
    _do2(std::string output_name, std::string operation, std::string c3, std::string c4, std::string c5, std::string c6, std::string c7, std::string c8, std::string c9, std::string c10, std::string c11) -> qint64
    _do2(std::string output_name, std::string operation, std::string c3, std::string c4, std::string c5, std::string c6, std::string c7, std::string c8, std::string c9, std::string c10) -> qint64
    _do2(std::string output_name, std::string operation, std::string c3, std::string c4, std::string c5, std::string c6, std::string c7, std::string c8, std::string c9) -> qint64
    _do2(std::string output_name, std::string operation, std::string c3, std::string c4, std::string c5, std::string c6, std::string c7, std::string c8) -> qint64
    _do2(std::string output_name, std::string operation, std::string c3, std::string c4, std::string c5, std::string c6, std::string c7) -> qint64
    _do2(std::string output_name, std::string operation, std::string c3, std::string c4, std::string c5, std::string c6) -> qint64
    _do2(std::string output_name, std::string operation, std::string c3, std::string c4, std::string c5) -> qint64
    _do2(std::string output_name, std::string operation, std::string c3, std::string c4) -> qint64
    _do2(std::string output_name, std::string operation, std::string c3) -> qint64
    Engine__do2(std::string output_name, std::string operation) -> qint64
    """
    return _ilwisobjects.Engine__do2(*args)

def Engine__do(*args):
    """
    _do(std::string output_name, std::string operation, std::string c3, std::string c4, std::string c5, std::string c6, std::string c7, std::string c8, std::string c9, std::string c10, std::string c11) -> Object
    _do(std::string output_name, std::string operation, std::string c3, std::string c4, std::string c5, std::string c6, std::string c7, std::string c8, std::string c9, std::string c10) -> Object
    _do(std::string output_name, std::string operation, std::string c3, std::string c4, std::string c5, std::string c6, std::string c7, std::string c8, std::string c9) -> Object
    _do(std::string output_name, std::string operation, std::string c3, std::string c4, std::string c5, std::string c6, std::string c7, std::string c8) -> Object
    _do(std::string output_name, std::string operation, std::string c3, std::string c4, std::string c5, std::string c6, std::string c7) -> Object
    _do(std::string output_name, std::string operation, std::string c3, std::string c4, std::string c5, std::string c6) -> Object
    _do(std::string output_name, std::string operation, std::string c3, std::string c4, std::string c5) -> Object
    _do(std::string output_name, std::string operation, std::string c3, std::string c4) -> Object
    _do(std::string output_name, std::string operation, std::string c3) -> Object
    Engine__do(std::string output_name, std::string operation) -> Object
    """
    return _ilwisobjects.Engine__do(*args)

def Engine_setWorkingCatalog(location):
    """Engine_setWorkingCatalog(std::string const & location)"""
    return _ilwisobjects.Engine_setWorkingCatalog(location)

def Engine_getLocation():
    """Engine_getLocation() -> std::string"""
    return _ilwisobjects.Engine_getLocation()

def Engine_operations():
    """Engine_operations() -> PyObject *"""
    return _ilwisobjects.Engine_operations()

def Engine_operationMetaData(*args):
    """
    operationMetaData(std::string const & name, std::string const & element) -> std::string
    Engine_operationMetaData(std::string const & name) -> std::string
    """
    return _ilwisobjects.Engine_operationMetaData(*args)

def Engine__catalogItems(filter):
    """Engine__catalogItems(quint64 filter) -> PyObject *"""
    return _ilwisobjects.Engine__catalogItems(filter)

class Collection(Object):
    """Proxy of C++ pythonapi::Collection class."""

    __swig_setmethods__ = {}
    for _s in [Object]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Collection, name, value)
    __swig_getmethods__ = {}
    for _s in [Object]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Collection, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def __bool__(self):
        """__bool__(Collection self) -> bool"""
        return _ilwisobjects.Collection___bool__(self)


    def __str__(self):
        """__str__(Collection self) -> std::string"""
        return _ilwisobjects.Collection___str__(self)


    def ilwisType(self):
        """ilwisType(Collection self) -> IlwisTypes"""
        return _ilwisobjects.Collection_ilwisType(self)


    def __len__(self):
        """__len__(Collection self) -> int"""
        return _ilwisobjects.Collection___len__(self)


    def _getitem(self, colIndex):
        """_getitem(Collection self, quint32 colIndex) -> Object"""
        return _ilwisobjects.Collection__getitem(self, colIndex)


    def toCollection(obj):
        """toCollection(Object obj) -> Collection"""
        return _ilwisobjects.Collection_toCollection(obj)

    toCollection = staticmethod(toCollection)

    def __getitem__(self, name):
        return object_cast(self._getitem(name))

    __swig_destroy__ = _ilwisobjects.delete_Collection
    __del__ = lambda self: None
Collection_swigregister = _ilwisobjects.Collection_swigregister
Collection_swigregister(Collection)

def Collection_toCollection(obj):
    """Collection_toCollection(Object obj) -> Collection"""
    return _ilwisobjects.Collection_toCollection(obj)

class IlwisObject(Object):
    """Proxy of C++ pythonapi::IlwisObject class."""

    __swig_setmethods__ = {}
    for _s in [Object]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, IlwisObject, name, value)
    __swig_getmethods__ = {}
    for _s in [Object]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, IlwisObject, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    cmINPUT = _ilwisobjects.IlwisObject_cmINPUT
    cmOUTPUT = _ilwisobjects.IlwisObject_cmOUTPUT
    cmEXTENDED = _ilwisobjects.IlwisObject_cmEXTENDED
    smMETADATA = _ilwisobjects.IlwisObject_smMETADATA
    smBINARYDATA = _ilwisobjects.IlwisObject_smBINARYDATA
    __swig_destroy__ = _ilwisobjects.delete_IlwisObject
    __del__ = lambda self: None

    def open(self, *args):
        """
        open(IlwisObject self, std::string const & url, std::string const & format, std::string const & fnamespace, IOOptions options)
        open(IlwisObject self, std::string const & url, std::string const & format, std::string const & fnamespace)
        open(IlwisObject self, std::string const & url, std::string const & format)
        open(IlwisObject self, std::string const & url)
        """
        return _ilwisobjects.IlwisObject_open(self, *args)


    def store(self, *args):
        """
        store(IlwisObject self, std::string const & url, std::string const & format, std::string const & fnamespace, IOOptions options)
        store(IlwisObject self, std::string const & url, std::string const & format, std::string const & fnamespace)
        store(IlwisObject self, std::string const & url, std::string const & format)
        store(IlwisObject self, std::string const & url)
        """
        return _ilwisobjects.IlwisObject_store(self, *args)


    def __bool__(self):
        """__bool__(IlwisObject self) -> bool"""
        return _ilwisobjects.IlwisObject___bool__(self)


    def __str__(self):
        """__str__(IlwisObject self) -> std::string"""
        return _ilwisobjects.IlwisObject___str__(self)


    def __add__(self, value):
        """__add__(IlwisObject self, std::string value) -> std::string"""
        return _ilwisobjects.IlwisObject___add__(self, value)


    def __radd__(self, value):
        """__radd__(IlwisObject self, std::string value) -> std::string"""
        return _ilwisobjects.IlwisObject___radd__(self, value)


    def name(self, *args):
        """
        name(IlwisObject self) -> std::string
        name(IlwisObject self, std::string name)
        """
        return _ilwisobjects.IlwisObject_name(self, *args)


    def isInternal(self):
        """isInternal(IlwisObject self) -> bool"""
        return _ilwisobjects.IlwisObject_isInternal(self)


    def type(self):
        """type(IlwisObject self) -> std::string"""
        return _ilwisobjects.IlwisObject_type(self)


    def type2Name(self, ilwType):
        """type2Name(IlwisObject self, IlwisTypes ilwType) -> std::string"""
        return _ilwisobjects.IlwisObject_type2Name(self, ilwType)


    def ilwisID(self):
        """ilwisID(IlwisObject self) -> quint64"""
        return _ilwisobjects.IlwisObject_ilwisID(self)


    def ilwisType(self):
        """ilwisType(IlwisObject self) -> IlwisTypes"""
        return _ilwisobjects.IlwisObject_ilwisType(self)

IlwisObject_swigregister = _ilwisobjects.IlwisObject_swigregister
IlwisObject_swigregister(IlwisObject)

class CoordinateSystem(IlwisObject):
    """Proxy of C++ pythonapi::CoordinateSystem class."""

    __swig_setmethods__ = {}
    for _s in [IlwisObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, CoordinateSystem, name, value)
    __swig_getmethods__ = {}
    for _s in [IlwisObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, CoordinateSystem, name)
    __repr__ = _swig_repr

    def __init__(self, resource):
        """__init__(pythonapi::CoordinateSystem self, std::string const & resource) -> CoordinateSystem"""
        this = _ilwisobjects.new_CoordinateSystem(resource)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def envelope(self):
        """envelope(CoordinateSystem self) -> Envelope"""
        return _ilwisobjects.CoordinateSystem_envelope(self)


    def setEnvelope(self, env):
        """setEnvelope(CoordinateSystem self, Envelope env)"""
        return _ilwisobjects.CoordinateSystem_setEnvelope(self, env)


    def __eq__(self, csy):
        """__eq__(CoordinateSystem self, CoordinateSystem csy) -> bool"""
        return _ilwisobjects.CoordinateSystem___eq__(self, csy)


    def __ne__(self, csy):
        """__ne__(CoordinateSystem self, CoordinateSystem csy) -> bool"""
        return _ilwisobjects.CoordinateSystem___ne__(self, csy)


    def toWKT(self):
        """toWKT(CoordinateSystem self) -> std::string"""
        return _ilwisobjects.CoordinateSystem_toWKT(self)


    def toProj4(self):
        """toProj4(CoordinateSystem self) -> std::string"""
        return _ilwisobjects.CoordinateSystem_toProj4(self)


    def convertEnvelope(self, pyCsy, pyEnv):
        """convertEnvelope(CoordinateSystem self, CoordinateSystem pyCsy, Envelope pyEnv) -> Envelope"""
        return _ilwisobjects.CoordinateSystem_convertEnvelope(self, pyCsy, pyEnv)


    def coord2coord(self, pyCsy, pyCoord):
        """coord2coord(CoordinateSystem self, CoordinateSystem pyCsy, Coordinate pyCoord) -> Coordinate"""
        return _ilwisobjects.CoordinateSystem_coord2coord(self, pyCsy, pyCoord)


    def toCoordinateSystem(obj):
        """toCoordinateSystem(Object obj) -> CoordinateSystem"""
        return _ilwisobjects.CoordinateSystem_toCoordinateSystem(obj)

    toCoordinateSystem = staticmethod(toCoordinateSystem)
    __swig_destroy__ = _ilwisobjects.delete_CoordinateSystem
    __del__ = lambda self: None
CoordinateSystem_swigregister = _ilwisobjects.CoordinateSystem_swigregister
CoordinateSystem_swigregister(CoordinateSystem)

def CoordinateSystem_toCoordinateSystem(obj):
    """CoordinateSystem_toCoordinateSystem(Object obj) -> CoordinateSystem"""
    return _ilwisobjects.CoordinateSystem_toCoordinateSystem(obj)

class Coordinate(_object):
    """Proxy of C++ pythonapi::Coordinate class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Coordinate, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Coordinate, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(pythonapi::Coordinate self, double x, double y) -> Coordinate
        __init__(pythonapi::Coordinate self, double x, double y, double z) -> Coordinate
        __init__(pythonapi::Coordinate self, Coordinate crd) -> Coordinate
        """
        this = _ilwisobjects.new_Coordinate(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def x(self):
        """x(Coordinate self) -> double"""
        return _ilwisobjects.Coordinate_x(self)


    def y(self):
        """y(Coordinate self) -> double"""
        return _ilwisobjects.Coordinate_y(self)


    def z(self):
        """z(Coordinate self) -> double"""
        return _ilwisobjects.Coordinate_z(self)


    def setX(self, v):
        """setX(Coordinate self, double v)"""
        return _ilwisobjects.Coordinate_setX(self, v)


    def setY(self, v):
        """setY(Coordinate self, double v)"""
        return _ilwisobjects.Coordinate_setY(self, v)


    def setZ(self, v):
        """setZ(Coordinate self, double v)"""
        return _ilwisobjects.Coordinate_setZ(self, v)


    def is3D(self):
        """is3D(Coordinate self) -> bool"""
        return _ilwisobjects.Coordinate_is3D(self)


    def __imul__(self, n):
        """__imul__(Coordinate self, double n) -> Coordinate"""
        return _ilwisobjects.Coordinate___imul__(self, n)


    def __itruediv__(self, n):
        """__itruediv__(Coordinate self, double n) -> Coordinate"""
        return _ilwisobjects.Coordinate___itruediv__(self, n)


    def __eq__(self, other):
        """__eq__(Coordinate self, Coordinate other) -> bool"""
        return _ilwisobjects.Coordinate___eq__(self, other)


    def __ne__(self, other):
        """__ne__(Coordinate self, Coordinate other) -> bool"""
        return _ilwisobjects.Coordinate___ne__(self, other)


    def __str__(self):
        """__str__(Coordinate self) -> std::string"""
        return _ilwisobjects.Coordinate___str__(self)


    def __bool__(self):
        """__bool__(Coordinate self) -> bool"""
        return _ilwisobjects.Coordinate___bool__(self)


    __swig_getmethods__["x"] = x
    __swig_getmethods__["y"] = y
    __swig_getmethods__["z"] = z
    __swig_setmethods__["x"] = setX
    __swig_setmethods__["y"] = setY
    __swig_setmethods__["z"] = setZ
    if _newclass:
        x = property(x,setX)
        y = property(y,setY)
        z = property(z,setZ)

    __swig_destroy__ = _ilwisobjects.delete_Coordinate
    __del__ = lambda self: None
Coordinate_swigregister = _ilwisobjects.Coordinate_swigregister
Coordinate_swigregister(Coordinate)

class PropertySets(_object):
    """Proxy of C++ pythonapi::Properties class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, PropertySets, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, PropertySets, name)
    __repr__ = _swig_repr
    pNONE = _ilwisobjects.PropertySets_pNONE
    pBASIC = _ilwisobjects.PropertySets_pBASIC
    pMIN = _ilwisobjects.PropertySets_pMIN
    pMAX = _ilwisobjects.PropertySets_pMAX
    pDISTANCE = _ilwisobjects.PropertySets_pDISTANCE
    pDELTA = _ilwisobjects.PropertySets_pDELTA
    pNETTOCOUNT = _ilwisobjects.PropertySets_pNETTOCOUNT
    pCOUNT = _ilwisobjects.PropertySets_pCOUNT
    pSUM = _ilwisobjects.PropertySets_pSUM
    pMEAN = _ilwisobjects.PropertySets_pMEAN
    pMEDIAN = _ilwisobjects.PropertySets_pMEDIAN
    pPREDOMINANT = _ilwisobjects.PropertySets_pPREDOMINANT
    pSTDEV = _ilwisobjects.PropertySets_pSTDEV
    pHISTOGRAM = _ilwisobjects.PropertySets_pHISTOGRAM
    pLAST = _ilwisobjects.PropertySets_pLAST
    pALL = _ilwisobjects.PropertySets_pALL

    def __init__(self):
        """__init__(pythonapi::Properties self) -> PropertySets"""
        this = _ilwisobjects.new_PropertySets()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _ilwisobjects.delete_PropertySets
    __del__ = lambda self: None
PropertySets_swigregister = _ilwisobjects.PropertySets_swigregister
PropertySets_swigregister(PropertySets)

class IOOptions(_object):
    """Proxy of C++ pythonapi::IOOptions class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, IOOptions, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, IOOptions, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(pythonapi::IOOptions self) -> IOOptions
        __init__(pythonapi::IOOptions self, std::string const & key, PyObject * value) -> IOOptions
        """
        this = _ilwisobjects.new_IOOptions(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def contains(self, option):
        """contains(IOOptions self, std::string const & option) -> bool"""
        return _ilwisobjects.IOOptions_contains(self, option)


    def size(self):
        """size(IOOptions self) -> quint32"""
        return _ilwisobjects.IOOptions_size(self)


    def __getitem__(self, option):
        """__getitem__(IOOptions self, std::string const & option) -> PyObject *"""
        return _ilwisobjects.IOOptions___getitem__(self, option)


    def addOption(self, key, value):
        """addOption(IOOptions self, std::string const & key, PyObject * value) -> IOOptions"""
        return _ilwisobjects.IOOptions_addOption(self, key, value)

    __swig_destroy__ = _ilwisobjects.delete_IOOptions
    __del__ = lambda self: None
IOOptions_swigregister = _ilwisobjects.IOOptions_swigregister
IOOptions_swigregister(IOOptions)

class ColorModel(_object):
    """Proxy of C++ pythonapi::ColorModelNS class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ColorModel, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ColorModel, name)
    __repr__ = _swig_repr
    cmNONE = _ilwisobjects.ColorModel_cmNONE
    cmRGBA = _ilwisobjects.ColorModel_cmRGBA
    cmHSLA = _ilwisobjects.ColorModel_cmHSLA
    cmCYMKA = _ilwisobjects.ColorModel_cmCYMKA
    cmGREYSCALE = _ilwisobjects.ColorModel_cmGREYSCALE

    def __init__(self):
        """__init__(pythonapi::ColorModelNS self) -> ColorModel"""
        this = _ilwisobjects.new_ColorModel()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _ilwisobjects.delete_ColorModel
    __del__ = lambda self: None
ColorModel_swigregister = _ilwisobjects.ColorModel_swigregister
ColorModel_swigregister(ColorModel)

class Color(_object):
    """Proxy of C++ pythonapi::Color class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Color, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Color, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(pythonapi::Color self) -> Color
        __init__(pythonapi::Color self, pythonapi::ColorModel type, PyObject * obj, std::string const & name) -> Color
        __init__(pythonapi::Color self, pythonapi::ColorModel type, PyObject * obj) -> Color
        __init__(pythonapi::Color self, std::string const & typeStr, PyObject * obj, std::string const & name) -> Color
        __init__(pythonapi::Color self, std::string const & typeStr, PyObject * obj) -> Color
        """
        this = _ilwisobjects.new_Color(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def getItem(self, key):
        """getItem(Color self, std::string key) -> double"""
        return _ilwisobjects.Color_getItem(self, key)


    def setName(self, name):
        """setName(Color self, std::string const & name)"""
        return _ilwisobjects.Color_setName(self, name)


    def getName(self):
        """getName(Color self) -> std::string"""
        return _ilwisobjects.Color_getName(self)


    def getColorModel(self):
        """getColorModel(Color self) -> pythonapi::ColorModel"""
        return _ilwisobjects.Color_getColorModel(self)


    def toString(self):
        """toString(Color self) -> std::string"""
        return _ilwisobjects.Color_toString(self)


    def __str__(self):
        """__str__(Color self) -> std::string"""
        return _ilwisobjects.Color___str__(self)

    __swig_destroy__ = _ilwisobjects.delete_Color
    __del__ = lambda self: None
Color_swigregister = _ilwisobjects.Color_swigregister
Color_swigregister(Color)

class Pixel(_object):
    """Proxy of C++ pythonapi::PixelTemplate<(qint32)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Pixel, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Pixel, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(pythonapi::PixelTemplate<(qint32)> self, Pixel pixel) -> Pixel
        __init__(pythonapi::PixelTemplate<(qint32)> self, PixelD pixel) -> Pixel
        __init__(pythonapi::PixelTemplate<(qint32)> self, int x, int y) -> Pixel
        __init__(pythonapi::PixelTemplate<(qint32)> self, int x, int y, int z) -> Pixel
        """
        this = _ilwisobjects.new_Pixel(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def x(self):
        """x(Pixel self) -> int"""
        return _ilwisobjects.Pixel_x(self)


    def y(self):
        """y(Pixel self) -> int"""
        return _ilwisobjects.Pixel_y(self)


    def z(self):
        """z(Pixel self) -> int"""
        return _ilwisobjects.Pixel_z(self)


    def setX(self, v):
        """setX(Pixel self, int v)"""
        return _ilwisobjects.Pixel_setX(self, v)


    def setY(self, v):
        """setY(Pixel self, int v)"""
        return _ilwisobjects.Pixel_setY(self, v)


    def setZ(self, v):
        """setZ(Pixel self, int v)"""
        return _ilwisobjects.Pixel_setZ(self, v)


    def is3D(self):
        """is3D(Pixel self) -> bool"""
        return _ilwisobjects.Pixel_is3D(self)


    def __imul__(self, n):
        """__imul__(Pixel self, int n) -> Pixel"""
        return _ilwisobjects.Pixel___imul__(self, n)


    def __itruediv__(self, n):
        """__itruediv__(Pixel self, int n) -> Pixel"""
        return _ilwisobjects.Pixel___itruediv__(self, n)


    def __eq__(self, other):
        """__eq__(Pixel self, Pixel other) -> bool"""
        return _ilwisobjects.Pixel___eq__(self, other)


    def __ne__(self, other):
        """__ne__(Pixel self, Pixel other) -> bool"""
        return _ilwisobjects.Pixel___ne__(self, other)


    def __str__(self):
        """__str__(Pixel self) -> std::string"""
        return _ilwisobjects.Pixel___str__(self)


    def __bool__(self):
        """__bool__(Pixel self) -> bool"""
        return _ilwisobjects.Pixel___bool__(self)


    __swig_getmethods__["x"] = x
    __swig_getmethods__["y"] = y
    __swig_getmethods__["z"] = z
    __swig_setmethods__["x"] = setX
    __swig_setmethods__["y"] = setY
    __swig_setmethods__["z"] = setZ
    if _newclass:
        x = property(x,setX)
        y = property(y,setY)
        z = property(z,setZ)

    __swig_destroy__ = _ilwisobjects.delete_Pixel
    __del__ = lambda self: None
Pixel_swigregister = _ilwisobjects.Pixel_swigregister
Pixel_swigregister(Pixel)

class PixelD(_object):
    """Proxy of C++ pythonapi::PixelTemplate<(double)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, PixelD, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, PixelD, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(pythonapi::PixelTemplate<(double)> self, Pixel pixel) -> PixelD
        __init__(pythonapi::PixelTemplate<(double)> self, PixelD pixel) -> PixelD
        __init__(pythonapi::PixelTemplate<(double)> self, double x, double y) -> PixelD
        __init__(pythonapi::PixelTemplate<(double)> self, double x, double y, double z) -> PixelD
        """
        this = _ilwisobjects.new_PixelD(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def x(self):
        """x(PixelD self) -> double"""
        return _ilwisobjects.PixelD_x(self)


    def y(self):
        """y(PixelD self) -> double"""
        return _ilwisobjects.PixelD_y(self)


    def z(self):
        """z(PixelD self) -> double"""
        return _ilwisobjects.PixelD_z(self)


    def setX(self, v):
        """setX(PixelD self, double v)"""
        return _ilwisobjects.PixelD_setX(self, v)


    def setY(self, v):
        """setY(PixelD self, double v)"""
        return _ilwisobjects.PixelD_setY(self, v)


    def setZ(self, v):
        """setZ(PixelD self, double v)"""
        return _ilwisobjects.PixelD_setZ(self, v)


    def is3D(self):
        """is3D(PixelD self) -> bool"""
        return _ilwisobjects.PixelD_is3D(self)


    def __imul__(self, n):
        """__imul__(PixelD self, double n) -> PixelD"""
        return _ilwisobjects.PixelD___imul__(self, n)


    def __itruediv__(self, n):
        """__itruediv__(PixelD self, double n) -> PixelD"""
        return _ilwisobjects.PixelD___itruediv__(self, n)


    def __eq__(self, other):
        """__eq__(PixelD self, PixelD other) -> bool"""
        return _ilwisobjects.PixelD___eq__(self, other)


    def __ne__(self, other):
        """__ne__(PixelD self, PixelD other) -> bool"""
        return _ilwisobjects.PixelD___ne__(self, other)


    def __str__(self):
        """__str__(PixelD self) -> std::string"""
        return _ilwisobjects.PixelD___str__(self)


    def __bool__(self):
        """__bool__(PixelD self) -> bool"""
        return _ilwisobjects.PixelD___bool__(self)


    __swig_getmethods__["x"] = x
    __swig_getmethods__["y"] = y
    __swig_getmethods__["z"] = z
    __swig_setmethods__["x"] = setX
    __swig_setmethods__["y"] = setY
    __swig_setmethods__["z"] = setZ
    if _newclass:
        x = property(x,setX)
        y = property(y,setY)
        z = property(z,setZ)

    __swig_destroy__ = _ilwisobjects.delete_PixelD
    __del__ = lambda self: None
PixelD_swigregister = _ilwisobjects.PixelD_swigregister
PixelD_swigregister(PixelD)

class Size(_object):
    """Proxy of C++ pythonapi::SizeTemplate<(quint32)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Size, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Size, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(pythonapi::SizeTemplate<(quint32)> self, unsigned int xSizeT, unsigned int ySizeT, unsigned int zSizeT=1) -> Size
        __init__(pythonapi::SizeTemplate<(quint32)> self, unsigned int xSizeT, unsigned int ySizeT) -> Size
        __init__(pythonapi::SizeTemplate<(quint32)> self, Size size) -> Size
        __init__(pythonapi::SizeTemplate<(quint32)> self, SizeD size) -> Size
        """
        this = _ilwisobjects.new_Size(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def xsize(self):
        """xsize(Size self) -> unsigned int"""
        return _ilwisobjects.Size_xsize(self)


    def ysize(self):
        """ysize(Size self) -> unsigned int"""
        return _ilwisobjects.Size_ysize(self)


    def zsize(self):
        """zsize(Size self) -> unsigned int"""
        return _ilwisobjects.Size_zsize(self)


    def setXsize(self, x):
        """setXsize(Size self, unsigned int x)"""
        return _ilwisobjects.Size_setXsize(self, x)


    def setYsize(self, y):
        """setYsize(Size self, unsigned int y)"""
        return _ilwisobjects.Size_setYsize(self, y)


    def setZsize(self, z):
        """setZsize(Size self, unsigned int z)"""
        return _ilwisobjects.Size_setZsize(self, z)


    def linearSize(self):
        """linearSize(Size self) -> quint64"""
        return _ilwisobjects.Size_linearSize(self)


    def __iadd__(self, sz):
        """__iadd__(Size self, Size sz) -> Size"""
        return _ilwisobjects.Size___iadd__(self, sz)


    def __isub__(self, sz):
        """__isub__(Size self, Size sz) -> Size"""
        return _ilwisobjects.Size___isub__(self, sz)


    def __imul__(self, f):
        """__imul__(Size self, double f) -> Size"""
        return _ilwisobjects.Size___imul__(self, f)


    def __eq__(self, sz):
        """__eq__(Size self, Size sz) -> bool"""
        return _ilwisobjects.Size___eq__(self, sz)


    def __ne__(self, sz):
        """__ne__(Size self, Size sz) -> bool"""
        return _ilwisobjects.Size___ne__(self, sz)


    def __contains__(self, *args):
        """
        __contains__(Size self, Coordinate pix) -> bool
        __contains__(Size self, Pixel pix) -> bool
        __contains__(Size self, PixelD pix) -> bool
        """
        return _ilwisobjects.Size___contains__(self, *args)


    def __str__(self):
        """__str__(Size self) -> std::string"""
        return _ilwisobjects.Size___str__(self)


    def __bool__(self):
        """__bool__(Size self) -> bool"""
        return _ilwisobjects.Size___bool__(self)


    __swig_getmethods__["xsize"] = xsize
    __swig_getmethods__["ysize"] = ysize
    __swig_getmethods__["zsize"] = zsize
    __swig_setmethods__["xsize"] = setXsize
    __swig_setmethods__["ysize"] = setYsize
    __swig_setmethods__["zsize"] = setZsize
    if _newclass:
        xsize = property(xsize,setXsize)
        ysize = property(ysize,setYsize)
        zsize = property(zsize,setZsize)

    __swig_destroy__ = _ilwisobjects.delete_Size
    __del__ = lambda self: None
Size_swigregister = _ilwisobjects.Size_swigregister
Size_swigregister(Size)

class SizeD(_object):
    """Proxy of C++ pythonapi::SizeTemplate<(double)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SizeD, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SizeD, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(pythonapi::SizeTemplate<(double)> self, double xSizeT, double ySizeT, double zSizeT=1) -> SizeD
        __init__(pythonapi::SizeTemplate<(double)> self, double xSizeT, double ySizeT) -> SizeD
        __init__(pythonapi::SizeTemplate<(double)> self, Size size) -> SizeD
        __init__(pythonapi::SizeTemplate<(double)> self, SizeD size) -> SizeD
        """
        this = _ilwisobjects.new_SizeD(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def xsize(self):
        """xsize(SizeD self) -> double"""
        return _ilwisobjects.SizeD_xsize(self)


    def ysize(self):
        """ysize(SizeD self) -> double"""
        return _ilwisobjects.SizeD_ysize(self)


    def zsize(self):
        """zsize(SizeD self) -> double"""
        return _ilwisobjects.SizeD_zsize(self)


    def setXsize(self, x):
        """setXsize(SizeD self, double x)"""
        return _ilwisobjects.SizeD_setXsize(self, x)


    def setYsize(self, y):
        """setYsize(SizeD self, double y)"""
        return _ilwisobjects.SizeD_setYsize(self, y)


    def setZsize(self, z):
        """setZsize(SizeD self, double z)"""
        return _ilwisobjects.SizeD_setZsize(self, z)


    def linearSize(self):
        """linearSize(SizeD self) -> quint64"""
        return _ilwisobjects.SizeD_linearSize(self)


    def __iadd__(self, sz):
        """__iadd__(SizeD self, SizeD sz) -> SizeD"""
        return _ilwisobjects.SizeD___iadd__(self, sz)


    def __isub__(self, sz):
        """__isub__(SizeD self, SizeD sz) -> SizeD"""
        return _ilwisobjects.SizeD___isub__(self, sz)


    def __imul__(self, f):
        """__imul__(SizeD self, double f) -> SizeD"""
        return _ilwisobjects.SizeD___imul__(self, f)


    def __eq__(self, sz):
        """__eq__(SizeD self, SizeD sz) -> bool"""
        return _ilwisobjects.SizeD___eq__(self, sz)


    def __ne__(self, sz):
        """__ne__(SizeD self, SizeD sz) -> bool"""
        return _ilwisobjects.SizeD___ne__(self, sz)


    def __contains__(self, *args):
        """
        __contains__(SizeD self, Coordinate pix) -> bool
        __contains__(SizeD self, Pixel pix) -> bool
        __contains__(SizeD self, PixelD pix) -> bool
        """
        return _ilwisobjects.SizeD___contains__(self, *args)


    def __str__(self):
        """__str__(SizeD self) -> std::string"""
        return _ilwisobjects.SizeD___str__(self)


    def __bool__(self):
        """__bool__(SizeD self) -> bool"""
        return _ilwisobjects.SizeD___bool__(self)


    __swig_getmethods__["xsize"] = xsize
    __swig_getmethods__["ysize"] = ysize
    __swig_getmethods__["zsize"] = zsize
    __swig_setmethods__["xsize"] = setXsize
    __swig_setmethods__["ysize"] = setYsize
    __swig_setmethods__["zsize"] = setZsize
    if _newclass:
        xsize = property(xsize,setXsize)
        ysize = property(ysize,setYsize)
        zsize = property(zsize,setZsize)

    __swig_destroy__ = _ilwisobjects.delete_SizeD
    __del__ = lambda self: None
SizeD_swigregister = _ilwisobjects.SizeD_swigregister
SizeD_swigregister(SizeD)

class Box(_object):
    """Proxy of C++ pythonapi::BoxTemplate<(Ilwis::Location<(qint32,false)>,pythonapi::PixelTemplate<(qint32)>,quint32)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Box, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Box, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(pythonapi::BoxTemplate<(Ilwis::Location<(qint32,false)>,pythonapi::PixelTemplate<(qint32)>,quint32)> self) -> Box
        __init__(pythonapi::BoxTemplate<(Ilwis::Location<(qint32,false)>,pythonapi::PixelTemplate<(qint32)>,quint32)> self, std::string const & envelope) -> Box
        __init__(pythonapi::BoxTemplate<(Ilwis::Location<(qint32,false)>,pythonapi::PixelTemplate<(qint32)>,quint32)> self, Pixel min, Pixel max) -> Box
        __init__(pythonapi::BoxTemplate<(Ilwis::Location<(qint32,false)>,pythonapi::PixelTemplate<(qint32)>,quint32)> self, Size size) -> Box
        """
        this = _ilwisobjects.new_Box(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def minCorner(self):
        """minCorner(Box self) -> Pixel"""
        return _ilwisobjects.Box_minCorner(self)


    def maxCorner(self):
        """maxCorner(Box self) -> Pixel"""
        return _ilwisobjects.Box_maxCorner(self)


    def size(self):
        """size(Box self) -> Size"""
        return _ilwisobjects.Box_size(self)


    def is3D(self):
        """is3D(Box self) -> bool"""
        return _ilwisobjects.Box_is3D(self)


    def __contains__(self, *args):
        """
        __contains__(Box self, Pixel point) -> bool
        __contains__(Box self, Box box) -> bool
        """
        return _ilwisobjects.Box___contains__(self, *args)


    def __eq__(self, other):
        """__eq__(Box self, Box other) -> bool"""
        return _ilwisobjects.Box___eq__(self, other)


    def __ne__(self, other):
        """__ne__(Box self, Box other) -> bool"""
        return _ilwisobjects.Box___ne__(self, other)


    def __str__(self):
        """__str__(Box self) -> std::string"""
        return _ilwisobjects.Box___str__(self)


    def __bool__(self):
        """__bool__(Box self) -> bool"""
        return _ilwisobjects.Box___bool__(self)

    __swig_destroy__ = _ilwisobjects.delete_Box
    __del__ = lambda self: None
Box_swigregister = _ilwisobjects.Box_swigregister
Box_swigregister(Box)

class Envelope(_object):
    """Proxy of C++ pythonapi::BoxTemplate<(Ilwis::Coordinate,pythonapi::Coordinate,double)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Envelope, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Envelope, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(pythonapi::BoxTemplate<(Ilwis::Coordinate,pythonapi::Coordinate,double)> self) -> Envelope
        __init__(pythonapi::BoxTemplate<(Ilwis::Coordinate,pythonapi::Coordinate,double)> self, std::string const & envelope) -> Envelope
        __init__(pythonapi::BoxTemplate<(Ilwis::Coordinate,pythonapi::Coordinate,double)> self, Coordinate min, Coordinate max) -> Envelope
        __init__(pythonapi::BoxTemplate<(Ilwis::Coordinate,pythonapi::Coordinate,double)> self, SizeD size) -> Envelope
        """
        this = _ilwisobjects.new_Envelope(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def minCorner(self):
        """minCorner(Envelope self) -> Coordinate"""
        return _ilwisobjects.Envelope_minCorner(self)


    def maxCorner(self):
        """maxCorner(Envelope self) -> Coordinate"""
        return _ilwisobjects.Envelope_maxCorner(self)


    def size(self):
        """size(Envelope self) -> SizeD"""
        return _ilwisobjects.Envelope_size(self)


    def is3D(self):
        """is3D(Envelope self) -> bool"""
        return _ilwisobjects.Envelope_is3D(self)


    def __contains__(self, *args):
        """
        __contains__(Envelope self, Coordinate point) -> bool
        __contains__(Envelope self, Envelope box) -> bool
        """
        return _ilwisobjects.Envelope___contains__(self, *args)


    def __eq__(self, other):
        """__eq__(Envelope self, Envelope other) -> bool"""
        return _ilwisobjects.Envelope___eq__(self, other)


    def __ne__(self, other):
        """__ne__(Envelope self, Envelope other) -> bool"""
        return _ilwisobjects.Envelope___ne__(self, other)


    def __str__(self):
        """__str__(Envelope self) -> std::string"""
        return _ilwisobjects.Envelope___str__(self)


    def __bool__(self):
        """__bool__(Envelope self) -> bool"""
        return _ilwisobjects.Envelope___bool__(self)

    __swig_destroy__ = _ilwisobjects.delete_Envelope
    __del__ = lambda self: None
Envelope_swigregister = _ilwisobjects.Envelope_swigregister
Envelope_swigregister(Envelope)

class NumericStatistics(_object):
    """Proxy of C++ pythonapi::ContainerStatistics<(double)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, NumericStatistics, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, NumericStatistics, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(pythonapi::ContainerStatistics<(double)> self) -> NumericStatistics
        __init__(pythonapi::ContainerStatistics<(double)> self, Ilwis::ContainerStatistics< double > const & conStat) -> NumericStatistics
        """
        this = _ilwisobjects.new_NumericStatistics(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def significantDigits(self):
        """significantDigits(NumericStatistics self) -> quint16"""
        return _ilwisobjects.NumericStatistics_significantDigits(self)


    def findSignificantDigits(self, distance):
        """findSignificantDigits(NumericStatistics self, double distance)"""
        return _ilwisobjects.NumericStatistics_findSignificantDigits(self, distance)


    def binCount(self, value):
        """binCount(NumericStatistics self, quint32 value)"""
        return _ilwisobjects.NumericStatistics_binCount(self, value)


    def __bool__(self):
        """__bool__(NumericStatistics self) -> bool"""
        return _ilwisobjects.NumericStatistics___bool__(self)


    def stretchLinear(self, input, stretchRange):
        """stretchLinear(NumericStatistics self, double input, int stretchRange) -> double"""
        return _ilwisobjects.NumericStatistics_stretchLinear(self, input, stretchRange)


    def stretchLimits(self, percent):
        """stretchLimits(NumericStatistics self, double percent) -> PyObject *"""
        return _ilwisobjects.NumericStatistics_stretchLimits(self, percent)


    def __getitem__(self, pyMethod):
        """__getitem__(NumericStatistics self, pythonapi::PropertySets pyMethod) -> double"""
        return _ilwisobjects.NumericStatistics___getitem__(self, pyMethod)


    def prop(self, pyMethod):
        """prop(NumericStatistics self, pythonapi::PropertySets pyMethod) -> double"""
        return _ilwisobjects.NumericStatistics_prop(self, pyMethod)


    def histogram(self):
        """histogram(NumericStatistics self) -> PyObject *"""
        return _ilwisobjects.NumericStatistics_histogram(self)

    __swig_destroy__ = _ilwisobjects.delete_NumericStatistics
    __del__ = lambda self: None
NumericStatistics_swigregister = _ilwisobjects.NumericStatistics_swigregister
NumericStatistics_swigregister(NumericStatistics)

class Table(IlwisObject):
    """Proxy of C++ pythonapi::Table class."""

    __swig_setmethods__ = {}
    for _s in [IlwisObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Table, name, value)
    __swig_getmethods__ = {}
    for _s in [IlwisObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Table, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(pythonapi::Table self) -> Table
        __init__(pythonapi::Table self, std::string resource, IOOptions opt) -> Table
        __init__(pythonapi::Table self, std::string resource) -> Table
        """
        this = _ilwisobjects.new_Table(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def columnCount(self):
        """columnCount(Table self) -> quint32"""
        return _ilwisobjects.Table_columnCount(self)


    def columns(self):
        """columns(Table self) -> PyObject *"""
        return _ilwisobjects.Table_columns(self)


    def addColumn(self, *args):
        """
        addColumn(Table self, std::string const & name, std::string const & domain)
        addColumn(Table self, ColumnDefinition coldef)
        """
        return _ilwisobjects.Table_addColumn(self, *args)


    def columnIndex(self, name):
        """columnIndex(Table self, std::string const & name) -> qint32"""
        return _ilwisobjects.Table_columnIndex(self, name)


    def column(self, *args):
        """
        column(Table self, std::string const & name) -> PyObject
        column(Table self, quint32 columnIndex) -> PyObject *
        """
        return _ilwisobjects.Table_column(self, *args)


    def recordCount(self):
        """recordCount(Table self) -> quint32"""
        return _ilwisobjects.Table_recordCount(self)


    def select(self, conditions):
        """select(Table self, std::string const & conditions) -> PyObject *"""
        return _ilwisobjects.Table_select(self, conditions)


    def record(self, rec):
        """record(Table self, quint32 rec) -> PyObject *"""
        return _ilwisobjects.Table_record(self, rec)


    def cell(self, *args):
        """
        cell(Table self, std::string const & name, quint32 rec) -> PyObject
        cell(Table self, quint32 colIndex, quint32 rec) -> PyObject *
        """
        return _ilwisobjects.Table_cell(self, *args)


    def setCell(self, *args):
        """
        setCell(Table self, std::string const & name, quint32 rec, PyObject const * value)
        setCell(Table self, quint32 colIndex, quint32 rec, PyObject const * value)
        setCell(Table self, std::string const & name, quint32 rec, qint64 value)
        setCell(Table self, quint32 colIndex, quint32 rec, qint64 value)
        setCell(Table self, std::string const & name, quint32 rec, std::string value)
        setCell(Table self, quint32 colIndex, quint32 rec, std::string value)
        setCell(Table self, std::string const & name, quint32 rec, double value)
        setCell(Table self, quint32 colIndex, quint32 rec, double value)
        """
        return _ilwisobjects.Table_setCell(self, *args)


    def toTable(obj):
        """toTable(Object obj) -> Table"""
        return _ilwisobjects.Table_toTable(obj)

    toTable = staticmethod(toTable)

    def columnDefinition(self, *args):
        """
        columnDefinition(Table self, std::string const & name) -> ColumnDefinition
        columnDefinition(Table self, quint32 index) -> ColumnDefinition
        """
        return _ilwisobjects.Table_columnDefinition(self, *args)


    def setColumnDefinition(self, *args):
        """
        setColumnDefinition(Table self, ColumnDefinition coldef)
        setColumnDefinition(Table self, std::string const & name, ColumnDefinition coldef)
        setColumnDefinition(Table self, quint32 index, ColumnDefinition coldef)
        """
        return _ilwisobjects.Table_setColumnDefinition(self, *args)

    __swig_destroy__ = _ilwisobjects.delete_Table
    __del__ = lambda self: None
Table_swigregister = _ilwisobjects.Table_swigregister
Table_swigregister(Table)

def Table_toTable(obj):
    """Table_toTable(Object obj) -> Table"""
    return _ilwisobjects.Table_toTable(obj)

class Coverage(IlwisObject):
    """Proxy of C++ pythonapi::Coverage class."""

    __swig_setmethods__ = {}
    for _s in [IlwisObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Coverage, name, value)
    __swig_getmethods__ = {}
    for _s in [IlwisObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Coverage, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    atCOVERAGE = _ilwisobjects.Coverage_atCOVERAGE
    atINDEX = _ilwisobjects.Coverage_atINDEX
    __swig_destroy__ = _ilwisobjects.delete_Coverage
    __del__ = lambda self: None

    def coordinateSystem(self):
        """coordinateSystem(Coverage self) -> CoordinateSystem"""
        return _ilwisobjects.Coverage_coordinateSystem(self)


    def envelope(self):
        """envelope(Coverage self) -> Envelope"""
        return _ilwisobjects.Coverage_envelope(self)


    def setEnvelope(self, env):
        """setEnvelope(Coverage self, Envelope env)"""
        return _ilwisobjects.Coverage_setEnvelope(self, env)

Coverage_swigregister = _ilwisobjects.Coverage_swigregister
Coverage_swigregister(Coverage)

class Geometry(Object):
    """Proxy of C++ pythonapi::Geometry class."""

    __swig_setmethods__ = {}
    for _s in [Object]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Geometry, name, value)
    __swig_getmethods__ = {}
    for _s in [Object]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Geometry, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(pythonapi::Geometry self, std::string wkt, CoordinateSystem csy) -> Geometry
        __init__(pythonapi::Geometry self, Feature feature) -> Geometry
        """
        this = _ilwisobjects.new_Geometry(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _ilwisobjects.delete_Geometry
    __del__ = lambda self: None

    def __bool__(self):
        """__bool__(Geometry self) -> bool"""
        return _ilwisobjects.Geometry___bool__(self)


    def __str__(self):
        """__str__(Geometry self) -> std::string"""
        return _ilwisobjects.Geometry___str__(self)


    def ilwisType(self):
        """ilwisType(Geometry self) -> IlwisTypes"""
        return _ilwisobjects.Geometry_ilwisType(self)


    def fromWKT(self, wkt):
        """fromWKT(Geometry self, std::string const & wkt)"""
        return _ilwisobjects.Geometry_fromWKT(self, wkt)


    def fromWKTReader(self, wkt):
        """fromWKTReader(Geometry self, std::string const & wkt) -> geos::geom::Geometry *"""
        return _ilwisobjects.Geometry_fromWKTReader(self, wkt)


    def toWKT(self):
        """toWKT(Geometry self) -> std::string"""
        return _ilwisobjects.Geometry_toWKT(self)


    def coordinateSystem(self):
        """coordinateSystem(Geometry self) -> CoordinateSystem"""
        return _ilwisobjects.Geometry_coordinateSystem(self)


    def setCoordinateSystem(self, cs):
        """setCoordinateSystem(Geometry self, CoordinateSystem cs)"""
        return _ilwisobjects.Geometry_setCoordinateSystem(self, cs)


    def transform(self, cs):
        """transform(Geometry self, CoordinateSystem cs) -> Geometry"""
        return _ilwisobjects.Geometry_transform(self, cs)


    def envelope(self):
        """envelope(Geometry self) -> Envelope"""
        return _ilwisobjects.Geometry_envelope(self)


    def __iter__(self):
        """__iter__(Geometry self) -> VertexIterator"""
        return _ilwisobjects.Geometry___iter__(self)


    def isSimple(self):
        """isSimple(Geometry self) -> bool"""
        return _ilwisobjects.Geometry_isSimple(self)


    def within(self, geometry):
        """within(Geometry self, Geometry geometry) -> bool"""
        return _ilwisobjects.Geometry_within(self, geometry)


    def contains(self, geometry):
        """contains(Geometry self, Geometry geometry) -> bool"""
        return _ilwisobjects.Geometry_contains(self, geometry)


    def disjoint(self, geometry):
        """disjoint(Geometry self, Geometry geometry) -> bool"""
        return _ilwisobjects.Geometry_disjoint(self, geometry)


    def touches(self, geometry):
        """touches(Geometry self, Geometry geometry) -> bool"""
        return _ilwisobjects.Geometry_touches(self, geometry)


    def intersects(self, geometry):
        """intersects(Geometry self, Geometry geometry) -> bool"""
        return _ilwisobjects.Geometry_intersects(self, geometry)


    def crosses(self, geometry):
        """crosses(Geometry self, Geometry geometry) -> bool"""
        return _ilwisobjects.Geometry_crosses(self, geometry)


    def overlaps(self, geometry):
        """overlaps(Geometry self, Geometry geometry) -> bool"""
        return _ilwisobjects.Geometry_overlaps(self, geometry)


    def equals(self, geometry):
        """equals(Geometry self, Geometry geometry) -> bool"""
        return _ilwisobjects.Geometry_equals(self, geometry)


    def equalsExact(self, geometry, tolerance=0):
        """
        equalsExact(Geometry self, Geometry geometry, double tolerance=0) -> bool
        equalsExact(Geometry self, Geometry geometry) -> bool
        """
        return _ilwisobjects.Geometry_equalsExact(self, geometry, tolerance)


    def covers(self, geometry):
        """covers(Geometry self, Geometry geometry) -> bool"""
        return _ilwisobjects.Geometry_covers(self, geometry)


    def coveredBy(self, geometry):
        """coveredBy(Geometry self, Geometry geometry) -> bool"""
        return _ilwisobjects.Geometry_coveredBy(self, geometry)


    def relate(self, geometry, DE9IM_pattern):
        """relate(Geometry self, Geometry geometry, std::string const & DE9IM_pattern) -> bool"""
        return _ilwisobjects.Geometry_relate(self, geometry, DE9IM_pattern)


    def distance(self, geometry):
        """distance(Geometry self, Geometry geometry) -> double"""
        return _ilwisobjects.Geometry_distance(self, geometry)


    def getArea(self):
        """getArea(Geometry self) -> double"""
        return _ilwisobjects.Geometry_getArea(self)


    def getLength(self):
        """getLength(Geometry self) -> double"""
        return _ilwisobjects.Geometry_getLength(self)


    def isWithinDistance(self, geometry, cDistance):
        """isWithinDistance(Geometry self, Geometry geometry, double cDistance) -> bool"""
        return _ilwisobjects.Geometry_isWithinDistance(self, geometry, cDistance)


    def buffer(self, distance):
        """buffer(Geometry self, double distance) -> Geometry"""
        return _ilwisobjects.Geometry_buffer(self, distance)


    def convexHull(self):
        """convexHull(Geometry self) -> Geometry"""
        return _ilwisobjects.Geometry_convexHull(self)


    def intersection(self, geometry):
        """intersection(Geometry self, Geometry geometry) -> Geometry"""
        return _ilwisobjects.Geometry_intersection(self, geometry)


    def Union(self, geometry):
        """Union(Geometry self, Geometry geometry) -> Geometry"""
        return _ilwisobjects.Geometry_Union(self, geometry)


    def difference(self, geometry):
        """difference(Geometry self, Geometry geometry) -> Geometry"""
        return _ilwisobjects.Geometry_difference(self, geometry)


    def symDifference(self, geometry):
        """symDifference(Geometry self, Geometry geometry) -> Geometry"""
        return _ilwisobjects.Geometry_symDifference(self, geometry)

Geometry_swigregister = _ilwisobjects.Geometry_swigregister
Geometry_swigregister(Geometry)

class Feature(Object):
    """Proxy of C++ pythonapi::Feature class."""

    __swig_setmethods__ = {}
    for _s in [Object]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Feature, name, value)
    __swig_getmethods__ = {}
    for _s in [Object]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Feature, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def __bool__(self):
        """__bool__(Feature self) -> bool"""
        return _ilwisobjects.Feature___bool__(self)


    def __str__(self):
        """__str__(Feature self) -> std::string"""
        return _ilwisobjects.Feature___str__(self)


    def __iter__(self):
        """__iter__(Feature self) -> VertexIterator"""
        return _ilwisobjects.Feature___iter__(self)


    def createSubFeature(self, subFeatureIndex, geom):
        """createSubFeature(Feature self, PyObject * subFeatureIndex, Geometry geom) -> Feature"""
        return _ilwisobjects.Feature_createSubFeature(self, subFeatureIndex, geom)


    def __getitem__(self, *args):
        """
        __getitem__(Feature self, std::string name) -> PyObject
        __getitem__(Feature self, quint32 colIndex) -> PyObject *
        """
        return _ilwisobjects.Feature___getitem__(self, *args)


    def attribute(self, *args):
        """
        attribute(Feature self, std::string name, qint64 defaultValue) -> PyObject
        attribute(Feature self, std::string name, double defaultValue) -> PyObject
        attribute(Feature self, std::string name, std::string defaultValue) -> PyObject *
        """
        return _ilwisobjects.Feature_attribute(self, *args)


    def __setitem__(self, *args):
        """
        __setitem__(Feature self, std::string name, PyObject const * value)
        __setitem__(Feature self, std::string name, qint64 value)
        __setitem__(Feature self, std::string name, double value)
        __setitem__(Feature self, std::string name, std::string value)
        """
        return _ilwisobjects.Feature___setitem__(self, *args)


    def setAttribute(self, *args):
        """
        setAttribute(Feature self, std::string name, PyObject const * value)
        setAttribute(Feature self, std::string name, qint64 value)
        setAttribute(Feature self, std::string name, double value)
        setAttribute(Feature self, std::string name, std::string value)
        """
        return _ilwisobjects.Feature_setAttribute(self, *args)


    def ilwisType(self):
        """ilwisType(Feature self) -> IlwisTypes"""
        return _ilwisobjects.Feature_ilwisType(self)


    def geometry(self, *args):
        """
        geometry(Feature self) -> Geometry
        geometry(Feature self, Geometry geom)
        """
        return _ilwisobjects.Feature_geometry(self, *args)


    def geometryType(self):
        """geometryType(Feature self) -> IlwisTypes"""
        return _ilwisobjects.Feature_geometryType(self)


    def featureId(self):
        """featureId(Feature self) -> quint64"""
        return _ilwisobjects.Feature_featureId(self)


    def attributeDefinition(self, *args):
        """
        attributeDefinition(Feature self, std::string const & name) -> ColumnDefinition
        attributeDefinition(Feature self, quint32 index) -> ColumnDefinition
        """
        return _ilwisobjects.Feature_attributeDefinition(self, *args)


    def attributeColumnCount(self):
        """attributeColumnCount(Feature self) -> quint32"""
        return _ilwisobjects.Feature_attributeColumnCount(self)


    def removeSubFeature(self, *args):
        """
        removeSubFeature(Feature self, std::string const & subFeatureIndex)
        removeSubFeature(Feature self, double subFeatureIndex)
        """
        return _ilwisobjects.Feature_removeSubFeature(self, *args)


    def setSubFeature(self, *args):
        """
        setSubFeature(Feature self, std::string const & subFeatureIndex, Feature feature)
        setSubFeature(Feature self, double subFeatureIndex, Feature feature)
        """
        return _ilwisobjects.Feature_setSubFeature(self, *args)


    def subFeatureCount(self):
        """subFeatureCount(Feature self) -> quint32"""
        return _ilwisobjects.Feature_subFeatureCount(self)


    def setRecord(self, pyValues, offset=0):
        """
        setRecord(Feature self, PyObject * pyValues, quint32 offset=0)
        setRecord(Feature self, PyObject * pyValues)
        """
        return _ilwisobjects.Feature_setRecord(self, pyValues, offset)


    def record(self):
        """record(Feature self) -> PyObject *"""
        return _ilwisobjects.Feature_record(self)


    def begin(self):
        """begin(Feature self) -> VertexIterator"""
        return _ilwisobjects.Feature_begin(self)


    def end(self):
        """end(Feature self) -> VertexIterator"""
        return _ilwisobjects.Feature_end(self)

    __swig_destroy__ = _ilwisobjects.delete_Feature
    __del__ = lambda self: None
Feature_swigregister = _ilwisobjects.Feature_swigregister
Feature_swigregister(Feature)
cvar = _ilwisobjects.cvar
COVERAGEATRIB = cvar.COVERAGEATRIB

class FeatureIterator(_object):
    """Proxy of C++ pythonapi::FeatureIterator class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, FeatureIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, FeatureIterator, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(pythonapi::FeatureIterator self, FeatureCoverage fc) -> FeatureIterator
        __init__(pythonapi::FeatureIterator self, FeatureIterator it) -> FeatureIterator
        """
        this = _ilwisobjects.new_FeatureIterator(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __next__(self):
        """__next__(FeatureIterator self) -> Feature"""
        return _ilwisobjects.FeatureIterator___next__(self)


    def current(self):
        """current(FeatureIterator self) -> Feature"""
        return _ilwisobjects.FeatureIterator_current(self)


    def __getitem__(self, pos):
        """__getitem__(FeatureIterator self, quint32 pos) -> Feature"""
        return _ilwisobjects.FeatureIterator___getitem__(self, pos)


    def __iter__(self):
        """__iter__(FeatureIterator self) -> FeatureIterator"""
        return _ilwisobjects.FeatureIterator___iter__(self)


    def __str__(self):
        """__str__(FeatureIterator self) -> std::string"""
        return _ilwisobjects.FeatureIterator___str__(self)


    def __bool__(self):
        """__bool__(FeatureIterator self) -> bool"""
        return _ilwisobjects.FeatureIterator___bool__(self)


    def __eq__(self, other):
        """__eq__(FeatureIterator self, FeatureIterator other) -> bool"""
        return _ilwisobjects.FeatureIterator___eq__(self, other)


    def __ne__(self, other):
        """__ne__(FeatureIterator self, FeatureIterator other) -> bool"""
        return _ilwisobjects.FeatureIterator___ne__(self, other)


    def __add__(self, n):
        """__add__(FeatureIterator self, int n) -> FeatureIterator"""
        return _ilwisobjects.FeatureIterator___add__(self, n)


    def __radd__(self, n):
        """__radd__(FeatureIterator self, int n) -> FeatureIterator"""
        return _ilwisobjects.FeatureIterator___radd__(self, n)


    def __sub__(self, n):
        """__sub__(FeatureIterator self, int n) -> FeatureIterator"""
        return _ilwisobjects.FeatureIterator___sub__(self, n)

    __swig_destroy__ = _ilwisobjects.delete_FeatureIterator
    __del__ = lambda self: None
FeatureIterator_swigregister = _ilwisobjects.FeatureIterator_swigregister
FeatureIterator_swigregister(FeatureIterator)

class FeatureCoverage(Coverage):
    """Proxy of C++ pythonapi::FeatureCoverage class."""

    __swig_setmethods__ = {}
    for _s in [Coverage]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FeatureCoverage, name, value)
    __swig_getmethods__ = {}
    for _s in [Coverage]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, FeatureCoverage, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(pythonapi::FeatureCoverage self) -> FeatureCoverage
        __init__(pythonapi::FeatureCoverage self, std::string const & resource) -> FeatureCoverage
        """
        this = _ilwisobjects.new_FeatureCoverage(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __iter__(self):
        """__iter__(FeatureCoverage self) -> FeatureIterator"""
        return _ilwisobjects.FeatureCoverage___iter__(self)


    def featureTypes(self, *args):
        """
        featureTypes(FeatureCoverage self) -> IlwisTypes
        featureTypes(FeatureCoverage self, IlwisTypes type)
        """
        return _ilwisobjects.FeatureCoverage_featureTypes(self, *args)


    def featureCount(self):
        """featureCount(FeatureCoverage self) -> unsigned int"""
        return _ilwisobjects.FeatureCoverage_featureCount(self)


    def setFeatureCount(self, type, geomCnt):
        """setFeatureCount(FeatureCoverage self, IlwisTypes type, quint32 geomCnt)"""
        return _ilwisobjects.FeatureCoverage_setFeatureCount(self, type, geomCnt)


    def newFeature(self, *args):
        """
        newFeature(FeatureCoverage self, std::string const & wkt, CoordinateSystem csy, bool load=True) -> Feature
        newFeature(FeatureCoverage self, std::string const & wkt, CoordinateSystem csy) -> Feature
        newFeature(FeatureCoverage self, Geometry geometry) -> Feature
        """
        return _ilwisobjects.FeatureCoverage_newFeature(self, *args)


    def newFeatureFrom(self, feat, csy):
        """newFeatureFrom(FeatureCoverage self, Feature feat, CoordinateSystem csy) -> Feature"""
        return _ilwisobjects.FeatureCoverage_newFeatureFrom(self, feat, csy)


    def reprojectFeatures(self, csy):
        """reprojectFeatures(FeatureCoverage self, CoordinateSystem csy)"""
        return _ilwisobjects.FeatureCoverage_reprojectFeatures(self, csy)


    def attributeTable(self):
        """attributeTable(FeatureCoverage self) -> Table"""
        return _ilwisobjects.FeatureCoverage_attributeTable(self)


    def attributesFromTable(self, otherTable):
        """attributesFromTable(FeatureCoverage self, Table otherTable)"""
        return _ilwisobjects.FeatureCoverage_attributesFromTable(self, otherTable)


    def addColumn(self, *args):
        """
        addColumn(FeatureCoverage self, ColumnDefinition coldef)
        addColumn(FeatureCoverage self, std::string const & name, std::string const & domainname)
        """
        return _ilwisobjects.FeatureCoverage_addColumn(self, *args)


    def columndefinition(self, *args):
        """
        columndefinition(FeatureCoverage self, std::string const & nme) -> ColumnDefinition
        columndefinition(FeatureCoverage self, quint32 index) -> ColumnDefinition
        """
        return _ilwisobjects.FeatureCoverage_columndefinition(self, *args)


    def setColumndefinition(self, coldef):
        """setColumndefinition(FeatureCoverage self, ColumnDefinition coldef)"""
        return _ilwisobjects.FeatureCoverage_setColumndefinition(self, coldef)


    def columnIndex(self, nme):
        """columnIndex(FeatureCoverage self, std::string const & nme) -> quint32"""
        return _ilwisobjects.FeatureCoverage_columnIndex(self, nme)


    def __getitem__(self, index):
        """__getitem__(FeatureCoverage self, quint32 index) -> ColumnDefinition"""
        return _ilwisobjects.FeatureCoverage___getitem__(self, index)


    def checkInput(self, inputVar, columnIndex):
        """checkInput(FeatureCoverage self, PyObject * inputVar, quint32 columnIndex) -> PyObject *"""
        return _ilwisobjects.FeatureCoverage_checkInput(self, inputVar, columnIndex)


    def definitionCount(self):
        """definitionCount(FeatureCoverage self) -> quint32"""
        return _ilwisobjects.FeatureCoverage_definitionCount(self)


    def setStackDefinition(self, dom, items):
        """setStackDefinition(FeatureCoverage self, Domain dom, PyObject * items)"""
        return _ilwisobjects.FeatureCoverage_setStackDefinition(self, dom, items)


    def indexOf(self, *args):
        """
        indexOf(FeatureCoverage self, std::string const & variantId) -> quint32
        indexOf(FeatureCoverage self, double domainItem) -> quint32
        indexOf(FeatureCoverage self, PyObject * obj) -> quint32
        """
        return _ilwisobjects.FeatureCoverage_indexOf(self, *args)


    def atIndex(self, idx):
        """atIndex(FeatureCoverage self, quint32 idx) -> std::string"""
        return _ilwisobjects.FeatureCoverage_atIndex(self, idx)


    def indexes(self):
        """indexes(FeatureCoverage self) -> PyObject *"""
        return _ilwisobjects.FeatureCoverage_indexes(self)


    def countStackDomainItems(self):
        """countStackDomainItems(FeatureCoverage self) -> quint32"""
        return _ilwisobjects.FeatureCoverage_countStackDomainItems(self)


    def stackDomain(self):
        """stackDomain(FeatureCoverage self) -> Domain"""
        return _ilwisobjects.FeatureCoverage_stackDomain(self)


    def clear(self):
        """clear(FeatureCoverage self)"""
        return _ilwisobjects.FeatureCoverage_clear(self)


    def toFeatureCoverage(obj):
        """toFeatureCoverage(Object obj) -> FeatureCoverage"""
        return _ilwisobjects.FeatureCoverage_toFeatureCoverage(obj)

    toFeatureCoverage = staticmethod(toFeatureCoverage)

    def select(self, spatialQuery):
        """select(FeatureCoverage self, std::string const & spatialQuery) -> PyObject *"""
        return _ilwisobjects.FeatureCoverage_select(self, spatialQuery)


    def clone(self):
        """clone(FeatureCoverage self) -> FeatureCoverage"""
        return _ilwisobjects.FeatureCoverage_clone(self)


    def geometryType(self, geom):
        """geometryType(FeatureCoverage self, Geometry geom) -> IlwisTypes"""
        return _ilwisobjects.FeatureCoverage_geometryType(self, geom)


    def setCoordinateSystem(self, cs):
        """setCoordinateSystem(FeatureCoverage self, CoordinateSystem cs)"""
        return _ilwisobjects.FeatureCoverage_setCoordinateSystem(self, cs)

    __swig_destroy__ = _ilwisobjects.delete_FeatureCoverage
    __del__ = lambda self: None
FeatureCoverage_swigregister = _ilwisobjects.FeatureCoverage_swigregister
FeatureCoverage_swigregister(FeatureCoverage)

def FeatureCoverage_toFeatureCoverage(obj):
    """FeatureCoverage_toFeatureCoverage(Object obj) -> FeatureCoverage"""
    return _ilwisobjects.FeatureCoverage_toFeatureCoverage(obj)

class Flow(_object):
    """Proxy of C++ pythonapi::FlowVal class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Flow, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Flow, name)
    __repr__ = _swig_repr
    XYZ = _ilwisobjects.Flow_XYZ
    YXZ = _ilwisobjects.Flow_YXZ
    XZY = _ilwisobjects.Flow_XZY
    YZX = _ilwisobjects.Flow_YZX
    ZXY = _ilwisobjects.Flow_ZXY
    ZYX = _ilwisobjects.Flow_ZYX

    def __init__(self):
        """__init__(pythonapi::FlowVal self) -> Flow"""
        this = _ilwisobjects.new_Flow()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _ilwisobjects.delete_Flow
    __del__ = lambda self: None
Flow_swigregister = _ilwisobjects.Flow_swigregister
Flow_swigregister(Flow)

class PixelIterator(_object):
    """Proxy of C++ pythonapi::PixelIterator class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, PixelIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, PixelIterator, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(pythonapi::PixelIterator self, PixelIterator pi) -> PixelIterator
        __init__(pythonapi::PixelIterator self, RasterCoverage rc, Box b) -> PixelIterator
        __init__(pythonapi::PixelIterator self, RasterCoverage rc) -> PixelIterator
        __init__(pythonapi::PixelIterator self, RasterCoverage rc, Geometry geom) -> PixelIterator
        __init__(pythonapi::PixelIterator self, Ilwis::PixelIterator * ilwIt) -> PixelIterator
        """
        this = _ilwisobjects.new_PixelIterator(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _ilwisobjects.delete_PixelIterator
    __del__ = lambda self: None

    def __iter__(self):
        """__iter__(PixelIterator self) -> PixelIterator"""
        return _ilwisobjects.PixelIterator___iter__(self)


    def __next__(self):
        """__next__(PixelIterator self) -> double"""
        return _ilwisobjects.PixelIterator___next__(self)


    def __bool__(self):
        """__bool__(PixelIterator self) -> bool"""
        return _ilwisobjects.PixelIterator___bool__(self)


    def __str__(self):
        """__str__(PixelIterator self) -> std::string"""
        return _ilwisobjects.PixelIterator___str__(self)


    def __float__(self):
        """__float__(PixelIterator self) -> double"""
        return _ilwisobjects.PixelIterator___float__(self)


    def __int__(self):
        """__int__(PixelIterator self) -> quint64"""
        return _ilwisobjects.PixelIterator___int__(self)


    def __contains__(self, vox):
        """__contains__(PixelIterator self, Pixel vox) -> bool"""
        return _ilwisobjects.PixelIterator___contains__(self, vox)


    def box(self):
        """box(PixelIterator self) -> Box"""
        return _ilwisobjects.PixelIterator_box(self)


    def position(self):
        """position(PixelIterator self) -> Pixel"""
        return _ilwisobjects.PixelIterator_position(self)


    def setFlow(self, flw):
        """setFlow(PixelIterator self, pythonapi::Flow flw)"""
        return _ilwisobjects.PixelIterator_setFlow(self, flw)


    def xChanged(self):
        """xChanged(PixelIterator self) -> bool"""
        return _ilwisobjects.PixelIterator_xChanged(self)


    def yChanged(self):
        """yChanged(PixelIterator self) -> bool"""
        return _ilwisobjects.PixelIterator_yChanged(self)


    def zChanged(self):
        """zChanged(PixelIterator self) -> bool"""
        return _ilwisobjects.PixelIterator_zChanged(self)


    def __set__(self, ohterIt):
        """__set__(PixelIterator self, PixelIterator ohterIt) -> PixelIterator"""
        return _ilwisobjects.PixelIterator___set__(self, ohterIt)


    def __getitem__(self, *args):
        """
        __getitem__(PixelIterator self, Pixel vox) -> PixelIterator
        __getitem__(PixelIterator self, quint32 linearPosition) -> double
        """
        return _ilwisobjects.PixelIterator___getitem__(self, *args)


    def __setitem__(self, linearPosition, value):
        """__setitem__(PixelIterator self, quint32 linearPosition, double value)"""
        return _ilwisobjects.PixelIterator___setitem__(self, linearPosition, value)


    def __add__(self, n):
        """__add__(PixelIterator self, int n) -> PixelIterator"""
        return _ilwisobjects.PixelIterator___add__(self, n)


    def __radd__(self, n):
        """__radd__(PixelIterator self, int n) -> PixelIterator"""
        return _ilwisobjects.PixelIterator___radd__(self, n)


    def __iadd__(self, n):
        """__iadd__(PixelIterator self, int n) -> PixelIterator"""
        return _ilwisobjects.PixelIterator___iadd__(self, n)


    def __eq__(self, other):
        """__eq__(PixelIterator self, PixelIterator other) -> bool"""
        return _ilwisobjects.PixelIterator___eq__(self, other)


    def __ne__(self, other):
        """__ne__(PixelIterator self, PixelIterator other) -> bool"""
        return _ilwisobjects.PixelIterator___ne__(self, other)


    def __le__(self, other):
        """__le__(PixelIterator self, PixelIterator other) -> bool"""
        return _ilwisobjects.PixelIterator___le__(self, other)


    def __lt__(self, other):
        """__lt__(PixelIterator self, PixelIterator other) -> bool"""
        return _ilwisobjects.PixelIterator___lt__(self, other)


    def __ge__(self, other):
        """__ge__(PixelIterator self, PixelIterator other) -> bool"""
        return _ilwisobjects.PixelIterator___ge__(self, other)


    def __gt__(self, other):
        """__gt__(PixelIterator self, PixelIterator other) -> bool"""
        return _ilwisobjects.PixelIterator___gt__(self, other)


    def end(self):
        """end(PixelIterator self) -> PixelIterator"""
        return _ilwisobjects.PixelIterator_end(self)


    def asBuffer(self):
        """asBuffer(PixelIterator self) -> Py_buffer *"""
        return _ilwisobjects.PixelIterator_asBuffer(self)


    def raster(self):
        """raster(PixelIterator self) -> RasterCoverage"""
        return _ilwisobjects.PixelIterator_raster(self)

PixelIterator_swigregister = _ilwisobjects.PixelIterator_swigregister
PixelIterator_swigregister(PixelIterator)

class GeoReference(IlwisObject):
    """Proxy of C++ pythonapi::GeoReference class."""

    __swig_setmethods__ = {}
    for _s in [IlwisObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, GeoReference, name, value)
    __swig_getmethods__ = {}
    for _s in [IlwisObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, GeoReference, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(pythonapi::GeoReference self, std::string const & resource) -> GeoReference
        __init__(pythonapi::GeoReference self, std::string const & csyCode, Envelope env, Size psize) -> GeoReference
        """
        this = _ilwisobjects.new_GeoReference(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def toGeoReference(obj):
        """toGeoReference(Object obj) -> GeoReference"""
        return _ilwisobjects.GeoReference_toGeoReference(obj)

    toGeoReference = staticmethod(toGeoReference)

    def coordinateSystem(self):
        """coordinateSystem(GeoReference self) -> CoordinateSystem"""
        return _ilwisobjects.GeoReference_coordinateSystem(self)


    def setCoordinateSystem(self, csy):
        """setCoordinateSystem(GeoReference self, CoordinateSystem csy)"""
        return _ilwisobjects.GeoReference_setCoordinateSystem(self, csy)


    def pixel2Coord(self, *args):
        """
        pixel2Coord(GeoReference self, PixelD pixel) -> Coordinate
        pixel2Coord(GeoReference self, Pixel pixel) -> Coordinate
        """
        return _ilwisobjects.GeoReference_pixel2Coord(self, *args)


    def coord2Pixel(self, coord):
        """coord2Pixel(GeoReference self, Coordinate coord) -> PixelD"""
        return _ilwisobjects.GeoReference_coord2Pixel(self, coord)


    def box2Envelope(self, box):
        """box2Envelope(GeoReference self, Box box) -> Envelope"""
        return _ilwisobjects.GeoReference_box2Envelope(self, box)


    def envelope2Box(self, box):
        """envelope2Box(GeoReference self, Envelope box) -> Box"""
        return _ilwisobjects.GeoReference_envelope2Box(self, box)


    def pixelSize(self):
        """pixelSize(GeoReference self) -> double"""
        return _ilwisobjects.GeoReference_pixelSize(self)


    def size(self):
        """size(GeoReference self) -> Size"""
        return _ilwisobjects.GeoReference_size(self)


    def setSize(self, sz):
        """setSize(GeoReference self, Size sz)"""
        return _ilwisobjects.GeoReference_setSize(self, sz)


    def centerOfPixel(self):
        """centerOfPixel(GeoReference self) -> bool"""
        return _ilwisobjects.GeoReference_centerOfPixel(self)


    def setCenterOfPixel(self, yesno):
        """setCenterOfPixel(GeoReference self, bool yesno)"""
        return _ilwisobjects.GeoReference_setCenterOfPixel(self, yesno)


    def isCompatible(self, other):
        """isCompatible(GeoReference self, GeoReference other) -> bool"""
        return _ilwisobjects.GeoReference_isCompatible(self, other)


    def compute(self):
        """compute(GeoReference self) -> bool"""
        return _ilwisobjects.GeoReference_compute(self)


    def ilwisType(self):
        """ilwisType(GeoReference self) -> IlwisTypes"""
        return _ilwisobjects.GeoReference_ilwisType(self)

    __swig_destroy__ = _ilwisobjects.delete_GeoReference
    __del__ = lambda self: None
GeoReference_swigregister = _ilwisobjects.GeoReference_swigregister
GeoReference_swigregister(GeoReference)

def GeoReference_toGeoReference(obj):
    """GeoReference_toGeoReference(Object obj) -> GeoReference"""
    return _ilwisobjects.GeoReference_toGeoReference(obj)

class RasterCoverage(Coverage):
    """Proxy of C++ pythonapi::RasterCoverage class."""

    __swig_setmethods__ = {}
    for _s in [Coverage]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, RasterCoverage, name, value)
    __swig_getmethods__ = {}
    for _s in [Coverage]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, RasterCoverage, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(pythonapi::RasterCoverage self) -> RasterCoverage
        __init__(pythonapi::RasterCoverage self, std::string resource) -> RasterCoverage
        """
        this = _ilwisobjects.new_RasterCoverage(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _ilwisobjects.delete_RasterCoverage
    __del__ = lambda self: None

    def __add__(self, *args):
        """
        __add__(RasterCoverage self, RasterCoverage rc) -> RasterCoverage
        __add__(RasterCoverage self, double value) -> RasterCoverage
        """
        return _ilwisobjects.RasterCoverage___add__(self, *args)


    def __radd__(self, value):
        """__radd__(RasterCoverage self, double value) -> RasterCoverage"""
        return _ilwisobjects.RasterCoverage___radd__(self, value)


    def __sub__(self, *args):
        """
        __sub__(RasterCoverage self, RasterCoverage rc) -> RasterCoverage
        __sub__(RasterCoverage self, double value) -> RasterCoverage
        """
        return _ilwisobjects.RasterCoverage___sub__(self, *args)


    def __rsub__(self, value):
        """__rsub__(RasterCoverage self, double value) -> RasterCoverage"""
        return _ilwisobjects.RasterCoverage___rsub__(self, value)


    def __mul__(self, *args):
        """
        __mul__(RasterCoverage self, RasterCoverage rc) -> RasterCoverage
        __mul__(RasterCoverage self, double value) -> RasterCoverage
        """
        return _ilwisobjects.RasterCoverage___mul__(self, *args)


    def __rmul__(self, value):
        """__rmul__(RasterCoverage self, double value) -> RasterCoverage"""
        return _ilwisobjects.RasterCoverage___rmul__(self, value)


    def __truediv__(self, *args):
        """
        __truediv__(RasterCoverage self, RasterCoverage rc) -> RasterCoverage
        __truediv__(RasterCoverage self, double value) -> RasterCoverage
        """
        return _ilwisobjects.RasterCoverage___truediv__(self, *args)


    def __rtruediv__(self, value):
        """__rtruediv__(RasterCoverage self, double value) -> RasterCoverage"""
        return _ilwisobjects.RasterCoverage___rtruediv__(self, value)


    def __gt__(self, *args):
        """
        __gt__(RasterCoverage self, double value) -> RasterCoverage
        __gt__(RasterCoverage self, RasterCoverage rc) -> RasterCoverage
        """
        return _ilwisobjects.RasterCoverage___gt__(self, *args)


    def __lt__(self, *args):
        """
        __lt__(RasterCoverage self, double value) -> RasterCoverage
        __lt__(RasterCoverage self, RasterCoverage rc) -> RasterCoverage
        """
        return _ilwisobjects.RasterCoverage___lt__(self, *args)


    def __ge__(self, *args):
        """
        __ge__(RasterCoverage self, double value) -> RasterCoverage
        __ge__(RasterCoverage self, RasterCoverage rc) -> RasterCoverage
        """
        return _ilwisobjects.RasterCoverage___ge__(self, *args)


    def __le__(self, *args):
        """
        __le__(RasterCoverage self, double value) -> RasterCoverage
        __le__(RasterCoverage self, RasterCoverage rc) -> RasterCoverage
        """
        return _ilwisobjects.RasterCoverage___le__(self, *args)


    def __rand__(self, value):
        """__rand__(RasterCoverage self, double value) -> RasterCoverage"""
        return _ilwisobjects.RasterCoverage___rand__(self, value)


    def __ror__(self, value):
        """__ror__(RasterCoverage self, double value) -> RasterCoverage"""
        return _ilwisobjects.RasterCoverage___ror__(self, value)


    def __rxor__(self, value):
        """__rxor__(RasterCoverage self, double value) -> RasterCoverage"""
        return _ilwisobjects.RasterCoverage___rxor__(self, value)


    def __and__(self, *args):
        """
        __and__(RasterCoverage self, double value) -> RasterCoverage
        __and__(RasterCoverage self, RasterCoverage rc) -> RasterCoverage
        """
        return _ilwisobjects.RasterCoverage___and__(self, *args)


    def __or__(self, *args):
        """
        __or__(RasterCoverage self, double value) -> RasterCoverage
        __or__(RasterCoverage self, RasterCoverage rc) -> RasterCoverage
        """
        return _ilwisobjects.RasterCoverage___or__(self, *args)


    def __xor__(self, *args):
        """
        __xor__(RasterCoverage self, double value) -> RasterCoverage
        __xor__(RasterCoverage self, RasterCoverage rc) -> RasterCoverage
        """
        return _ilwisobjects.RasterCoverage___xor__(self, *args)


    def __eq__(self, *args):
        """
        __eq__(RasterCoverage self, double value) -> RasterCoverage
        __eq__(RasterCoverage self, RasterCoverage rc) -> RasterCoverage
        """
        return _ilwisobjects.RasterCoverage___eq__(self, *args)


    def __ne__(self, *args):
        """
        __ne__(RasterCoverage self, double value) -> RasterCoverage
        __ne__(RasterCoverage self, RasterCoverage rc) -> RasterCoverage
        """
        return _ilwisobjects.RasterCoverage___ne__(self, *args)


    def min(*args):
        """
        min(RasterCoverage rc1, RasterCoverage rc2) -> RasterCoverage
        min(RasterCoverage rc1, double value) -> RasterCoverage
        min(double value, RasterCoverage rc2) -> RasterCoverage
        """
        return _ilwisobjects.RasterCoverage_min(*args)

    min = staticmethod(min)

    def max(*args):
        """
        max(RasterCoverage rc1, RasterCoverage rc2) -> RasterCoverage
        max(RasterCoverage rc1, double value) -> RasterCoverage
        max(double value, RasterCoverage rc2) -> RasterCoverage
        """
        return _ilwisobjects.RasterCoverage_max(*args)

    max = staticmethod(max)

    def __iter__(self):
        """__iter__(RasterCoverage self) -> PixelIterator"""
        return _ilwisobjects.RasterCoverage___iter__(self)


    def _array2Raster(self, container, band):
        """_array2Raster(RasterCoverage self, PyObject * container, int band)"""
        return _ilwisobjects.RasterCoverage__array2Raster(self, container, band)


    def _list2Raster(self, container, band):
        """_list2Raster(RasterCoverage self, PyObject * container, int band)"""
        return _ilwisobjects.RasterCoverage__list2Raster(self, container, band)


    def coord2value(self, c):
        """coord2value(RasterCoverage self, Coordinate c) -> double"""
        return _ilwisobjects.RasterCoverage_coord2value(self, c)


    def pix2value(self, *args):
        """
        pix2value(RasterCoverage self, Pixel pix) -> double
        pix2value(RasterCoverage self, PixelD pix) -> double
        """
        return _ilwisobjects.RasterCoverage_pix2value(self, *args)


    def size(self):
        """size(RasterCoverage self) -> Size"""
        return _ilwisobjects.RasterCoverage_size(self)


    def setSize(self, sz):
        """setSize(RasterCoverage self, Size sz)"""
        return _ilwisobjects.RasterCoverage_setSize(self, sz)


    def unload(self):
        """unload(RasterCoverage self)"""
        return _ilwisobjects.RasterCoverage_unload(self)


    def coordinateSystem(self):
        """coordinateSystem(RasterCoverage self) -> CoordinateSystem"""
        return _ilwisobjects.RasterCoverage_coordinateSystem(self)


    def geoReference(self):
        """geoReference(RasterCoverage self) -> GeoReference"""
        return _ilwisobjects.RasterCoverage_geoReference(self)


    def setGeoReference(self, gr):
        """setGeoReference(RasterCoverage self, GeoReference gr)"""
        return _ilwisobjects.RasterCoverage_setGeoReference(self, gr)


    def datadef(self):
        """datadef(RasterCoverage self) -> DataDefinition"""
        return _ilwisobjects.RasterCoverage_datadef(self)


    def setDataDef(self, *args):
        """
        setDataDef(RasterCoverage self, DataDefinition datdef)
        setDataDef(RasterCoverage self, Domain dm)
        """
        return _ilwisobjects.RasterCoverage_setDataDef(self, *args)


    def statistics(self, mode=0, bins=0):
        """
        statistics(RasterCoverage self, int mode=0, int bins=0) -> NumericStatistics
        statistics(RasterCoverage self, int mode=0) -> NumericStatistics
        statistics(RasterCoverage self) -> NumericStatistics
        """
        return _ilwisobjects.RasterCoverage_statistics(self, mode, bins)


    def toRasterCoverage(obj):
        """toRasterCoverage(Object obj) -> RasterCoverage"""
        return _ilwisobjects.RasterCoverage_toRasterCoverage(obj)

    toRasterCoverage = staticmethod(toRasterCoverage)

    def begin(self):
        """begin(RasterCoverage self) -> PixelIterator"""
        return _ilwisobjects.RasterCoverage_begin(self)


    def end(self):
        """end(RasterCoverage self) -> PixelIterator"""
        return _ilwisobjects.RasterCoverage_end(self)


    def band(self, pyTrackIndex):
        """band(RasterCoverage self, PyObject * pyTrackIndex) -> PixelIterator"""
        return _ilwisobjects.RasterCoverage_band(self, pyTrackIndex)


    def addBand(self, pyTrackIndex, pyIter):
        """addBand(RasterCoverage self, PyObject * pyTrackIndex, PixelIterator pyIter)"""
        return _ilwisobjects.RasterCoverage_addBand(self, pyTrackIndex, pyIter)


    def setBandDefinition(self, pyTrackIndex, datdef):
        """setBandDefinition(RasterCoverage self, PyObject * pyTrackIndex, DataDefinition datdef)"""
        return _ilwisobjects.RasterCoverage_setBandDefinition(self, pyTrackIndex, datdef)


    def setStackDefinition(self, dom, items):
        """setStackDefinition(RasterCoverage self, Domain dom, PyObject * items)"""
        return _ilwisobjects.RasterCoverage_setStackDefinition(self, dom, items)


    def indexOf(self, *args):
        """
        indexOf(RasterCoverage self, std::string const & variantId) -> quint32
        indexOf(RasterCoverage self, double domainItem) -> quint32
        indexOf(RasterCoverage self, PyObject * obj) -> quint32
        """
        return _ilwisobjects.RasterCoverage_indexOf(self, *args)


    def atIndex(self, idx):
        """atIndex(RasterCoverage self, quint32 idx) -> std::string"""
        return _ilwisobjects.RasterCoverage_atIndex(self, idx)


    def indexes(self):
        """indexes(RasterCoverage self) -> PyObject *"""
        return _ilwisobjects.RasterCoverage_indexes(self)


    def countStackDomainItems(self):
        """countStackDomainItems(RasterCoverage self) -> quint32"""
        return _ilwisobjects.RasterCoverage_countStackDomainItems(self)


    def stackDomain(self):
        """stackDomain(RasterCoverage self) -> Domain"""
        return _ilwisobjects.RasterCoverage_stackDomain(self)


    def clear(self):
        """clear(RasterCoverage self)"""
        return _ilwisobjects.RasterCoverage_clear(self)


    def select(self, *args):
        """
        select(RasterCoverage self, std::string geomWkt) -> RasterCoverage
        select(RasterCoverage self, Geometry geom) -> RasterCoverage
        """
        return _ilwisobjects.RasterCoverage_select(self, *args)


    def reprojectRaster(self, newName, epsg, interpol):
        """reprojectRaster(RasterCoverage self, std::string newName, quint32 epsg, std::string interpol) -> RasterCoverage"""
        return _ilwisobjects.RasterCoverage_reprojectRaster(self, newName, epsg, interpol)


    def clone(self):
        """clone(RasterCoverage self) -> RasterCoverage"""
        return _ilwisobjects.RasterCoverage_clone(self)


    def envelope(self):
        """envelope(RasterCoverage self) -> Envelope"""
        return _ilwisobjects.RasterCoverage_envelope(self)


    def array2raster(self, dataContainer, band=-1):
        self._array2Raster(dataContainer, band)


    def list2raster(self, dataContainer, band=-1):
        self._list2Raster(dataContainer, band)

RasterCoverage_swigregister = _ilwisobjects.RasterCoverage_swigregister
RasterCoverage_swigregister(RasterCoverage)

def RasterCoverage_min(*args):
    """
    min(RasterCoverage rc1, RasterCoverage rc2) -> RasterCoverage
    min(RasterCoverage rc1, double value) -> RasterCoverage
    RasterCoverage_min(double value, RasterCoverage rc2) -> RasterCoverage
    """
    return _ilwisobjects.RasterCoverage_min(*args)

def RasterCoverage_max(*args):
    """
    max(RasterCoverage rc1, RasterCoverage rc2) -> RasterCoverage
    max(RasterCoverage rc1, double value) -> RasterCoverage
    RasterCoverage_max(double value, RasterCoverage rc2) -> RasterCoverage
    """
    return _ilwisobjects.RasterCoverage_max(*args)

def RasterCoverage_toRasterCoverage(obj):
    """RasterCoverage_toRasterCoverage(Object obj) -> RasterCoverage"""
    return _ilwisobjects.RasterCoverage_toRasterCoverage(obj)

class Catalog(Object):
    """Proxy of C++ pythonapi::Catalog class."""

    __swig_setmethods__ = {}
    for _s in [Object]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Catalog, name, value)
    __swig_getmethods__ = {}
    for _s in [Object]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Catalog, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(pythonapi::Catalog self, std::string const & url, std::string const & arg3) -> Catalog
        __init__(pythonapi::Catalog self, std::string const & url) -> Catalog
        """
        this = _ilwisobjects.new_Catalog(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _ilwisobjects.delete_Catalog
    __del__ = lambda self: None

    def __bool__(self):
        """__bool__(Catalog self) -> bool"""
        return _ilwisobjects.Catalog___bool__(self)


    def __str__(self):
        """__str__(Catalog self) -> std::string"""
        return _ilwisobjects.Catalog___str__(self)


    def ilwisType(self):
        """ilwisType(Catalog self) -> IlwisTypes"""
        return _ilwisobjects.Catalog_ilwisType(self)


    def items(self):
        """items(Catalog self) -> PyObject *"""
        return _ilwisobjects.Catalog_items(self)


    def _getitem(self, name):
        """_getitem(Catalog self, std::string const & name) -> Object"""
        return _ilwisobjects.Catalog__getitem(self, name)


    def toCatalog(obj):
        """toCatalog(Object obj) -> Catalog"""
        return _ilwisobjects.Catalog_toCatalog(obj)

    toCatalog = staticmethod(toCatalog)

    def __getitem__(self, name):
        return object_cast(self._getitem(name))

Catalog_swigregister = _ilwisobjects.Catalog_swigregister
Catalog_swigregister(Catalog)

def Catalog_toCatalog(obj):
    """Catalog_toCatalog(Object obj) -> Catalog"""
    return _ilwisobjects.Catalog_toCatalog(obj)

class Domain(IlwisObject):
    """Proxy of C++ pythonapi::Domain class."""

    __swig_setmethods__ = {}
    for _s in [IlwisObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Domain, name, value)
    __swig_getmethods__ = {}
    for _s in [IlwisObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Domain, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    cSELF = _ilwisobjects.Domain_cSELF
    cPARENT = _ilwisobjects.Domain_cPARENT
    cDECLARED = _ilwisobjects.Domain_cDECLARED
    cNONE = _ilwisobjects.Domain_cNONE
    __swig_destroy__ = _ilwisobjects.delete_Domain
    __del__ = lambda self: None

    def isStrict(self):
        """isStrict(Domain self) -> bool"""
        return _ilwisobjects.Domain_isStrict(self)


    def setStrict(self, yesno):
        """setStrict(Domain self, bool yesno)"""
        return _ilwisobjects.Domain_setStrict(self, yesno)


    def impliedValue(self, value):
        """impliedValue(Domain self, PyObject * value) -> PyObject *"""
        return _ilwisobjects.Domain_impliedValue(self, value)


    def parent(self):
        """parent(Domain self) -> Domain"""
        return _ilwisobjects.Domain_parent(self)


    def setParent(self, dom):
        """setParent(Domain self, Domain dom)"""
        return _ilwisobjects.Domain_setParent(self, dom)


    def getRange(self):
        """getRange(Domain self) -> Range"""
        return _ilwisobjects.Domain_getRange(self)


    def contains(self, value):
        """contains(Domain self, PyObject * value) -> std::string"""
        return _ilwisobjects.Domain_contains(self, value)


    def isCompatibleWith(self, dom):
        """isCompatibleWith(Domain self, Domain dom) -> bool"""
        return _ilwisobjects.Domain_isCompatibleWith(self, dom)


    def setRange(self, rng):
        """setRange(Domain self, Range rng)"""
        return _ilwisobjects.Domain_setRange(self, rng)


    def valueType(self):
        """valueType(Domain self) -> IlwisTypes"""
        return _ilwisobjects.Domain_valueType(self)


    def toDomain(obj):
        """toDomain(Object obj) -> Domain"""
        return _ilwisobjects.Domain_toDomain(obj)

    toDomain = staticmethod(toDomain)
Domain_swigregister = _ilwisobjects.Domain_swigregister
Domain_swigregister(Domain)

def Domain_toDomain(obj):
    """Domain_toDomain(Object obj) -> Domain"""
    return _ilwisobjects.Domain_toDomain(obj)

class NumericDomain(Domain):
    """Proxy of C++ pythonapi::NumericDomain class."""

    __swig_setmethods__ = {}
    for _s in [Domain]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, NumericDomain, name, value)
    __swig_getmethods__ = {}
    for _s in [Domain]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, NumericDomain, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(pythonapi::NumericDomain self) -> NumericDomain
        __init__(pythonapi::NumericDomain self, std::string const & resource) -> NumericDomain
        """
        this = _ilwisobjects.new_NumericDomain(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def toNumericDomain(obj):
        """toNumericDomain(Object obj) -> NumericDomain"""
        return _ilwisobjects.NumericDomain_toNumericDomain(obj)

    toNumericDomain = staticmethod(toNumericDomain)
    __swig_destroy__ = _ilwisobjects.delete_NumericDomain
    __del__ = lambda self: None
NumericDomain_swigregister = _ilwisobjects.NumericDomain_swigregister
NumericDomain_swigregister(NumericDomain)

def NumericDomain_toNumericDomain(obj):
    """NumericDomain_toNumericDomain(Object obj) -> NumericDomain"""
    return _ilwisobjects.NumericDomain_toNumericDomain(obj)

class ItemDomain(Domain):
    """Proxy of C++ pythonapi::ItemDomain class."""

    __swig_setmethods__ = {}
    for _s in [Domain]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ItemDomain, name, value)
    __swig_getmethods__ = {}
    for _s in [Domain]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ItemDomain, name)
    __repr__ = _swig_repr

    def __init__(self, rng):
        """__init__(pythonapi::ItemDomain self, Range rng) -> ItemDomain"""
        this = _ilwisobjects.new_ItemDomain(rng)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def count(self):
        """count(ItemDomain self) -> quint32"""
        return _ilwisobjects.ItemDomain_count(self)


    def setTheme(self, theme):
        """setTheme(ItemDomain self, std::string const & theme)"""
        return _ilwisobjects.ItemDomain_setTheme(self, theme)


    def theme(self):
        """theme(ItemDomain self) -> std::string"""
        return _ilwisobjects.ItemDomain_theme(self)


    def removeItem(self, nme):
        """removeItem(ItemDomain self, std::string const & nme)"""
        return _ilwisobjects.ItemDomain_removeItem(self, nme)


    def addItem(self, value):
        """addItem(ItemDomain self, PyObject * value)"""
        return _ilwisobjects.ItemDomain_addItem(self, value)


    def item(self, index, labelOnly):
        """item(ItemDomain self, int index, bool labelOnly) -> PyObject *"""
        return _ilwisobjects.ItemDomain_item(self, index, labelOnly)


    def range(self, rng):
        """range(ItemDomain self, Range rng)"""
        return _ilwisobjects.ItemDomain_range(self, rng)

    __swig_destroy__ = _ilwisobjects.delete_ItemDomain
    __del__ = lambda self: None
ItemDomain_swigregister = _ilwisobjects.ItemDomain_swigregister
ItemDomain_swigregister(ItemDomain)

class ColorDomain(Domain):
    """Proxy of C++ pythonapi::ColorDomain class."""

    __swig_setmethods__ = {}
    for _s in [Domain]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ColorDomain, name, value)
    __swig_getmethods__ = {}
    for _s in [Domain]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ColorDomain, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(pythonapi::ColorDomain self) -> ColorDomain
        __init__(pythonapi::ColorDomain self, std::string const & resource) -> ColorDomain
        """
        this = _ilwisobjects.new_ColorDomain(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def ilwisType(self):
        """ilwisType(ColorDomain self) -> IlwisTypes"""
        return _ilwisobjects.ColorDomain_ilwisType(self)


    def containsColor(self, value):
        """containsColor(ColorDomain self, Color value) -> std::string"""
        return _ilwisobjects.ColorDomain_containsColor(self, value)

    __swig_destroy__ = _ilwisobjects.delete_ColorDomain
    __del__ = lambda self: None
ColorDomain_swigregister = _ilwisobjects.ColorDomain_swigregister
ColorDomain_swigregister(ColorDomain)

class TextDomain(Domain):
    """Proxy of C++ pythonapi::TextDomain class."""

    __swig_setmethods__ = {}
    for _s in [Domain]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, TextDomain, name, value)
    __swig_getmethods__ = {}
    for _s in [Domain]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, TextDomain, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(pythonapi::TextDomain self) -> TextDomain
        __init__(pythonapi::TextDomain self, std::string const & resource) -> TextDomain
        """
        this = _ilwisobjects.new_TextDomain(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _ilwisobjects.delete_TextDomain
    __del__ = lambda self: None
TextDomain_swigregister = _ilwisobjects.TextDomain_swigregister
TextDomain_swigregister(TextDomain)

class TimeDomain(Domain):
    """Proxy of C++ pythonapi::TimeDomain class."""

    __swig_setmethods__ = {}
    for _s in [Domain]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, TimeDomain, name, value)
    __swig_getmethods__ = {}
    for _s in [Domain]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, TimeDomain, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(pythonapi::TimeDomain self) -> TimeDomain
        __init__(pythonapi::TimeDomain self, std::string const & resource) -> TimeDomain
        __init__(pythonapi::TimeDomain self, Range rng) -> TimeDomain
        """
        this = _ilwisobjects.new_TimeDomain(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _ilwisobjects.delete_TimeDomain
    __del__ = lambda self: None
TimeDomain_swigregister = _ilwisobjects.TimeDomain_swigregister
TimeDomain_swigregister(TimeDomain)

class Range(Object):
    """Proxy of C++ pythonapi::Range class."""

    __swig_setmethods__ = {}
    for _s in [Object]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Range, name, value)
    __swig_getmethods__ = {}
    for _s in [Object]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Range, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def __bool__(self):
        """__bool__(Range self) -> bool"""
        return _ilwisobjects.Range___bool__(self)


    def __str__(self):
        """__str__(Range self) -> std::string"""
        return _ilwisobjects.Range___str__(self)


    def ilwisType(self):
        """ilwisType(Range self) -> IlwisTypes"""
        return _ilwisobjects.Range_ilwisType(self)


    def valueType(self):
        """valueType(Range self) -> IlwisTypes"""
        return _ilwisobjects.Range_valueType(self)


    def ensure(self, v, inclusive=True):
        """
        ensure(Range self, PyObject const * v, bool inclusive=True) -> PyObject
        ensure(Range self, PyObject const * v) -> PyObject *
        """
        return _ilwisobjects.Range_ensure(self, v, inclusive)


    def contains(self, value, inclusive=True):
        """
        contains(Range self, PyObject const * value, bool inclusive=True) -> bool
        contains(Range self, PyObject const * value) -> bool
        """
        return _ilwisobjects.Range_contains(self, value, inclusive)


    def isContinuous(self):
        """isContinuous(Range self) -> bool"""
        return _ilwisobjects.Range_isContinuous(self)


    def impliedValue(self, value):
        """impliedValue(Range self, PyObject const * value) -> PyObject *"""
        return _ilwisobjects.Range_impliedValue(self, value)

Range_swigregister = _ilwisobjects.Range_swigregister
Range_swigregister(Range)

class NumericRange(Range):
    """Proxy of C++ pythonapi::NumericRange class."""

    __swig_setmethods__ = {}
    for _s in [Range]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, NumericRange, name, value)
    __swig_getmethods__ = {}
    for _s in [Range]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, NumericRange, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(pythonapi::NumericRange self, double mi, double ma, double resolution=0) -> NumericRange
        __init__(pythonapi::NumericRange self, double mi, double ma) -> NumericRange
        __init__(pythonapi::NumericRange self, NumericRange vr) -> NumericRange
        __init__(pythonapi::NumericRange self, Ilwis::NumericRange * nr) -> NumericRange
        __init__(pythonapi::NumericRange self) -> NumericRange
        """
        this = _ilwisobjects.new_NumericRange(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _ilwisobjects.delete_NumericRange
    __del__ = lambda self: None

    def contains(self, v, inclusive=True):
        """
        contains(NumericRange self, double v, bool inclusive=True) -> bool
        contains(NumericRange self, double v) -> bool
        """
        return _ilwisobjects.NumericRange_contains(self, v, inclusive)


    def max(self):
        """max(NumericRange self) -> double"""
        return _ilwisobjects.NumericRange_max(self)


    def setMax(self, v):
        """setMax(NumericRange self, double v)"""
        return _ilwisobjects.NumericRange_setMax(self, v)


    def min(self):
        """min(NumericRange self) -> double"""
        return _ilwisobjects.NumericRange_min(self)


    def setMin(self, v):
        """setMin(NumericRange self, double v)"""
        return _ilwisobjects.NumericRange_setMin(self, v)


    def distance(self):
        """distance(NumericRange self) -> double"""
        return _ilwisobjects.NumericRange_distance(self)


    def setResolution(self, resolution):
        """setResolution(NumericRange self, double resolution)"""
        return _ilwisobjects.NumericRange_setResolution(self, resolution)


    def resolution(self):
        """resolution(NumericRange self) -> double"""
        return _ilwisobjects.NumericRange_resolution(self)


    def set(self, vr):
        """set(NumericRange self, NumericRange vr)"""
        return _ilwisobjects.NumericRange_set(self, vr)


    def __iter__(self):
        """__iter__(NumericRange self) -> pythonapi::NumericRangeIterator"""
        return _ilwisobjects.NumericRange___iter__(self)


    def begin(self):
        """begin(NumericRange self) -> pythonapi::NumericRangeIterator"""
        return _ilwisobjects.NumericRange_begin(self)


    def end(self):
        """end(NumericRange self) -> pythonapi::NumericRangeIterator"""
        return _ilwisobjects.NumericRange_end(self)


    def clear(self):
        """clear(NumericRange self)"""
        return _ilwisobjects.NumericRange_clear(self)

NumericRange_swigregister = _ilwisobjects.NumericRange_swigregister
NumericRange_swigregister(NumericRange)

class ItemRange(Range):
    """Proxy of C++ pythonapi::ItemRange class."""

    __swig_setmethods__ = {}
    for _s in [Range]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ItemRange, name, value)
    __swig_getmethods__ = {}
    for _s in [Range]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ItemRange, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    def add(self, dItem):
        """add(ItemRange self, PyObject * dItem)"""
        return _ilwisobjects.ItemRange_add(self, dItem)


    def count(self):
        """count(ItemRange self) -> quint32"""
        return _ilwisobjects.ItemRange_count(self)


    def remove(self, name):
        """remove(ItemRange self, std::string const & name)"""
        return _ilwisobjects.ItemRange_remove(self, name)


    def clear(self):
        """clear(ItemRange self)"""
        return _ilwisobjects.ItemRange_clear(self)

    __swig_destroy__ = _ilwisobjects.delete_ItemRange
    __del__ = lambda self: None
ItemRange_swigregister = _ilwisobjects.ItemRange_swigregister
ItemRange_swigregister(ItemRange)

class NumericItemRange(ItemRange):
    """Proxy of C++ pythonapi::NumericItemRange class."""

    __swig_setmethods__ = {}
    for _s in [ItemRange]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, NumericItemRange, name, value)
    __swig_getmethods__ = {}
    for _s in [ItemRange]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, NumericItemRange, name)
    __repr__ = _swig_repr

    def __init__(self):
        """__init__(pythonapi::NumericItemRange self) -> NumericItemRange"""
        this = _ilwisobjects.new_NumericItemRange()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def add(self, *args):
        """
        add(NumericItemRange self, std::string name, double min, double max, double resolution=0)
        add(NumericItemRange self, std::string name, double min, double max)
        add(NumericItemRange self, PyObject * item)
        """
        return _ilwisobjects.NumericItemRange_add(self, *args)


    def listAll(self):
        """listAll(NumericItemRange self) -> PyObject *"""
        return _ilwisobjects.NumericItemRange_listAll(self)


    def item(self, index):
        """item(NumericItemRange self, quint32 index) -> DomainItem"""
        return _ilwisobjects.NumericItemRange_item(self, index)


    def gotoIndex(self, index, step):
        """gotoIndex(NumericItemRange self, qint32 index, qint32 step) -> qint32"""
        return _ilwisobjects.NumericItemRange_gotoIndex(self, index, step)


    def clone(self):
        """clone(NumericItemRange self) -> NumericItemRange"""
        return _ilwisobjects.NumericItemRange_clone(self)

    __swig_destroy__ = _ilwisobjects.delete_NumericItemRange
    __del__ = lambda self: None
NumericItemRange_swigregister = _ilwisobjects.NumericItemRange_swigregister
NumericItemRange_swigregister(NumericItemRange)

class IndexedItemRange(ItemRange):
    """Proxy of C++ pythonapi::IndexedItemRange class."""

    __swig_setmethods__ = {}
    for _s in [ItemRange]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, IndexedItemRange, name, value)
    __swig_getmethods__ = {}
    for _s in [ItemRange]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, IndexedItemRange, name)
    __repr__ = _swig_repr

    def __init__(self):
        """__init__(pythonapi::IndexedItemRange self) -> IndexedItemRange"""
        this = _ilwisobjects.new_IndexedItemRange()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def add(self, item):
        """add(IndexedItemRange self, PyObject * item)"""
        return _ilwisobjects.IndexedItemRange_add(self, item)


    def gotoIndex(self, index, step):
        """gotoIndex(IndexedItemRange self, qint32 index, qint32 step) -> qint32"""
        return _ilwisobjects.IndexedItemRange_gotoIndex(self, index, step)


    def clone(self):
        """clone(IndexedItemRange self) -> IndexedItemRange"""
        return _ilwisobjects.IndexedItemRange_clone(self)

    __swig_destroy__ = _ilwisobjects.delete_IndexedItemRange
    __del__ = lambda self: None
IndexedItemRange_swigregister = _ilwisobjects.IndexedItemRange_swigregister
IndexedItemRange_swigregister(IndexedItemRange)

class NamedItemRange(ItemRange):
    """Proxy of C++ pythonapi::NamedItemRange class."""

    __swig_setmethods__ = {}
    for _s in [ItemRange]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, NamedItemRange, name, value)
    __swig_getmethods__ = {}
    for _s in [ItemRange]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, NamedItemRange, name)
    __repr__ = _swig_repr

    def __init__(self):
        """__init__(pythonapi::NamedItemRange self) -> NamedItemRange"""
        this = _ilwisobjects.new_NamedItemRange()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def add(self, item):
        """add(NamedItemRange self, PyObject * item)"""
        return _ilwisobjects.NamedItemRange_add(self, item)


    def listAll(self):
        """listAll(NamedItemRange self) -> PyObject *"""
        return _ilwisobjects.NamedItemRange_listAll(self)


    def gotoIndex(self, index, step):
        """gotoIndex(NamedItemRange self, qint32 index, qint32 step) -> qint32"""
        return _ilwisobjects.NamedItemRange_gotoIndex(self, index, step)


    def clone(self):
        """clone(NamedItemRange self) -> NamedItemRange"""
        return _ilwisobjects.NamedItemRange_clone(self)

    __swig_destroy__ = _ilwisobjects.delete_NamedItemRange
    __del__ = lambda self: None
NamedItemRange_swigregister = _ilwisobjects.NamedItemRange_swigregister
NamedItemRange_swigregister(NamedItemRange)

class ThematicRange(ItemRange):
    """Proxy of C++ pythonapi::ThematicRange class."""

    __swig_setmethods__ = {}
    for _s in [ItemRange]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ThematicRange, name, value)
    __swig_getmethods__ = {}
    for _s in [ItemRange]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ThematicRange, name)
    __repr__ = _swig_repr

    def __init__(self):
        """__init__(pythonapi::ThematicRange self) -> ThematicRange"""
        this = _ilwisobjects.new_ThematicRange()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def add(self, *args):
        """
        add(ThematicRange self, std::string name, std::string id, std::string descr)
        add(ThematicRange self, std::string name, std::string id)
        add(ThematicRange self, std::string name)
        add(ThematicRange self, PyObject * item)
        """
        return _ilwisobjects.ThematicRange_add(self, *args)


    def listAll(self):
        """listAll(ThematicRange self) -> PyObject *"""
        return _ilwisobjects.ThematicRange_listAll(self)


    def clone(self):
        """clone(ThematicRange self) -> ThematicRange"""
        return _ilwisobjects.ThematicRange_clone(self)

    __swig_destroy__ = _ilwisobjects.delete_ThematicRange
    __del__ = lambda self: None
ThematicRange_swigregister = _ilwisobjects.ThematicRange_swigregister
ThematicRange_swigregister(ThematicRange)

class ColorRange(Range):
    """Proxy of C++ pythonapi::ColorRange class."""

    __swig_setmethods__ = {}
    for _s in [Range]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ColorRange, name, value)
    __swig_getmethods__ = {}
    for _s in [Range]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ColorRange, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(pythonapi::ColorRange self) -> ColorRange
        __init__(pythonapi::ColorRange self, IlwisTypes tp, pythonapi::ColorModel clrmodel) -> ColorRange
        """
        this = _ilwisobjects.new_ColorRange(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def defaultColorModel(self, *args):
        """
        defaultColorModel(ColorRange self) -> pythonapi::ColorModel
        defaultColorModel(ColorRange self, pythonapi::ColorModel m)
        """
        return _ilwisobjects.ColorRange_defaultColorModel(self, *args)


    def toColor(*args):
        """
        toColor(quint64 clrint, pythonapi::ColorModel clrModel, std::string const & name) -> Color
        toColor(quint64 clrint, pythonapi::ColorModel clrModel) -> Color
        toColor(PyObject * v, pythonapi::ColorModel colortype, std::string const & name) -> Color
        toColor(PyObject * v, pythonapi::ColorModel colortype) -> Color
        """
        return _ilwisobjects.ColorRange_toColor(*args)

    toColor = staticmethod(toColor)
    __swig_destroy__ = _ilwisobjects.delete_ColorRange
    __del__ = lambda self: None
ColorRange_swigregister = _ilwisobjects.ColorRange_swigregister
ColorRange_swigregister(ColorRange)

def ColorRange_toColor(*args):
    """
    toColor(quint64 clrint, pythonapi::ColorModel clrModel, std::string const & name) -> Color
    toColor(quint64 clrint, pythonapi::ColorModel clrModel) -> Color
    toColor(PyObject * v, pythonapi::ColorModel colortype, std::string const & name) -> Color
    ColorRange_toColor(PyObject * v, pythonapi::ColorModel colortype) -> Color
    """
    return _ilwisobjects.ColorRange_toColor(*args)

class ContinuousColorRange(ColorRange):
    """Proxy of C++ pythonapi::ContinuousColorRange class."""

    __swig_setmethods__ = {}
    for _s in [ColorRange]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ContinuousColorRange, name, value)
    __swig_getmethods__ = {}
    for _s in [ColorRange]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ContinuousColorRange, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(pythonapi::ContinuousColorRange self) -> ContinuousColorRange
        __init__(pythonapi::ContinuousColorRange self, Color clr1, Color clr2) -> ContinuousColorRange
        """
        this = _ilwisobjects.new_ContinuousColorRange(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def clone(self):
        """clone(ContinuousColorRange self) -> ContinuousColorRange"""
        return _ilwisobjects.ContinuousColorRange_clone(self)


    def ensure(self, v, inclusive=True):
        """
        ensure(ContinuousColorRange self, PyObject const * v, bool inclusive=True) -> PyObject
        ensure(ContinuousColorRange self, PyObject const * v) -> PyObject *
        """
        return _ilwisobjects.ContinuousColorRange_ensure(self, v, inclusive)


    def containsVar(self, v, inclusive=True):
        """
        containsVar(ContinuousColorRange self, PyObject const * v, bool inclusive=True) -> bool
        containsVar(ContinuousColorRange self, PyObject const * v) -> bool
        """
        return _ilwisobjects.ContinuousColorRange_containsVar(self, v, inclusive)


    def containsColor(self, clr, inclusive=True):
        """
        containsColor(ContinuousColorRange self, Color clr, bool inclusive=True) -> bool
        containsColor(ContinuousColorRange self, Color clr) -> bool
        """
        return _ilwisobjects.ContinuousColorRange_containsColor(self, clr, inclusive)


    def containsRange(self, v, inclusive=True):
        """
        containsRange(ContinuousColorRange self, ColorRange v, bool inclusive=True) -> bool
        containsRange(ContinuousColorRange self, ColorRange v) -> bool
        """
        return _ilwisobjects.ContinuousColorRange_containsRange(self, v, inclusive)


    def impliedValue(self, v):
        """impliedValue(ContinuousColorRange self, PyObject const * v) -> Color"""
        return _ilwisobjects.ContinuousColorRange_impliedValue(self, v)

    __swig_destroy__ = _ilwisobjects.delete_ContinuousColorRange
    __del__ = lambda self: None
ContinuousColorRange_swigregister = _ilwisobjects.ContinuousColorRange_swigregister
ContinuousColorRange_swigregister(ContinuousColorRange)

class ColorPalette(ItemRange, ColorRange):
    """Proxy of C++ pythonapi::ColorPalette class."""

    __swig_setmethods__ = {}
    for _s in [ItemRange, ColorRange]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ColorPalette, name, value)
    __swig_getmethods__ = {}
    for _s in [ItemRange, ColorRange]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ColorPalette, name)
    __repr__ = _swig_repr

    def __init__(self):
        """__init__(pythonapi::ColorPalette self) -> ColorPalette"""
        this = _ilwisobjects.new_ColorPalette()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def item(self, *args):
        """
        item(ColorPalette self, quint32 raw) -> Color
        item(ColorPalette self, std::string const & name) -> Color
        """
        return _ilwisobjects.ColorPalette_item(self, *args)


    def itemByOrder(self, index):
        """itemByOrder(ColorPalette self, quint32 index) -> Color"""
        return _ilwisobjects.ColorPalette_itemByOrder(self, index)


    def color(self, index):
        """color(ColorPalette self, int index) -> Color"""
        return _ilwisobjects.ColorPalette_color(self, index)


    def add(self, pyColor):
        """add(ColorPalette self, Color pyColor)"""
        return _ilwisobjects.ColorPalette_add(self, pyColor)


    def remove(self, name):
        """remove(ColorPalette self, std::string const & name)"""
        return _ilwisobjects.ColorPalette_remove(self, name)


    def clear(self):
        """clear(ColorPalette self)"""
        return _ilwisobjects.ColorPalette_clear(self)


    def containsColor(self, clr, inclusive=True):
        """
        containsColor(ColorPalette self, Color clr, bool inclusive=True) -> bool
        containsColor(ColorPalette self, Color clr) -> bool
        """
        return _ilwisobjects.ColorPalette_containsColor(self, clr, inclusive)


    def containsRange(self, v, inclusive=True):
        """
        containsRange(ColorPalette self, ColorRange v, bool inclusive=True) -> bool
        containsRange(ColorPalette self, ColorRange v) -> bool
        """
        return _ilwisobjects.ColorPalette_containsRange(self, v, inclusive)


    def count(self):
        """count(ColorPalette self) -> quint32"""
        return _ilwisobjects.ColorPalette_count(self)


    def valueAt(self, index, rng):
        """valueAt(ColorPalette self, quint32 index, ItemRange rng) -> Color"""
        return _ilwisobjects.ColorPalette_valueAt(self, index, rng)


    def gotoIndex(self, index, step):
        """gotoIndex(ColorPalette self, qint32 index, qint32 step) -> qint32"""
        return _ilwisobjects.ColorPalette_gotoIndex(self, index, step)

    __swig_destroy__ = _ilwisobjects.delete_ColorPalette
    __del__ = lambda self: None
ColorPalette_swigregister = _ilwisobjects.ColorPalette_swigregister
ColorPalette_swigregister(ColorPalette)

class TimeInterval(NumericRange):
    """Proxy of C++ pythonapi::TimeInterval class."""

    __swig_setmethods__ = {}
    for _s in [NumericRange]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, TimeInterval, name, value)
    __swig_getmethods__ = {}
    for _s in [NumericRange]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, TimeInterval, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(pythonapi::TimeInterval self, IlwisTypes tp) -> TimeInterval
        __init__(pythonapi::TimeInterval self) -> TimeInterval
        __init__(pythonapi::TimeInterval self, PyObject const * beg, PyObject const * end, std::string step, IlwisTypes tp) -> TimeInterval
        __init__(pythonapi::TimeInterval self, PyObject const * beg, PyObject const * end, std::string step) -> TimeInterval
        __init__(pythonapi::TimeInterval self, PyObject const * beg, PyObject const * end) -> TimeInterval
        """
        this = _ilwisobjects.new_TimeInterval(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def begin(self, *args):
        """
        begin(TimeInterval self) -> PyObject
        begin(TimeInterval self, PyObject const * t)
        """
        return _ilwisobjects.TimeInterval_begin(self, *args)


    def end(self, *args):
        """
        end(TimeInterval self) -> PyObject
        end(TimeInterval self, PyObject const * t)
        """
        return _ilwisobjects.TimeInterval_end(self, *args)


    def contains(self, *args):
        """
        contains(TimeInterval self, std::string const & value, bool inclusive=True) -> bool
        contains(TimeInterval self, std::string const & value) -> bool
        contains(TimeInterval self, PyObject const * value, bool inclusive=True) -> bool
        contains(TimeInterval self, PyObject const * value) -> bool
        """
        return _ilwisobjects.TimeInterval_contains(self, *args)


    def clone(self):
        """clone(TimeInterval self) -> TimeInterval"""
        return _ilwisobjects.TimeInterval_clone(self)

    __swig_destroy__ = _ilwisobjects.delete_TimeInterval
    __del__ = lambda self: None
TimeInterval_swigregister = _ilwisobjects.TimeInterval_swigregister
TimeInterval_swigregister(TimeInterval)

class DataDefinition(_object):
    """Proxy of C++ pythonapi::DataDefinition class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, DataDefinition, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, DataDefinition, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _ilwisobjects.delete_DataDefinition
    __del__ = lambda self: None

    def __init__(self, *args):
        """
        __init__(pythonapi::DataDefinition self) -> DataDefinition
        __init__(pythonapi::DataDefinition self, Domain dm, Range rng=None) -> DataDefinition
        __init__(pythonapi::DataDefinition self, Domain dm) -> DataDefinition
        __init__(pythonapi::DataDefinition self, DataDefinition datdef) -> DataDefinition
        """
        this = _ilwisobjects.new_DataDefinition(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __str__(self):
        """__str__(DataDefinition self) -> std::string"""
        return _ilwisobjects.DataDefinition___str__(self)


    def __bool__(self):
        """__bool__(DataDefinition self) -> bool"""
        return _ilwisobjects.DataDefinition___bool__(self)


    def isCompatibleWith(self, datdef):
        """isCompatibleWith(DataDefinition self, DataDefinition datdef) -> bool"""
        return _ilwisobjects.DataDefinition_isCompatibleWith(self, datdef)


    def merge(datdef1, datdef2):
        """merge(DataDefinition datdef1, DataDefinition datdef2) -> DataDefinition"""
        return _ilwisobjects.DataDefinition_merge(datdef1, datdef2)

    merge = staticmethod(merge)

    def __set__(self, datdef):
        """__set__(DataDefinition self, DataDefinition datdef) -> DataDefinition"""
        return _ilwisobjects.DataDefinition___set__(self, datdef)


    def range(self, *args):
        """
        range(DataDefinition self, Range rng)
        range(DataDefinition self) -> Range
        """
        return _ilwisobjects.DataDefinition_range(self, *args)


    def domain(self, *args):
        """
        domain(DataDefinition self, Domain dm)
        domain(DataDefinition self) -> Domain
        """
        return _ilwisobjects.DataDefinition_domain(self, *args)

DataDefinition_swigregister = _ilwisobjects.DataDefinition_swigregister
DataDefinition_swigregister(DataDefinition)

def DataDefinition_merge(datdef1, datdef2):
    """DataDefinition_merge(DataDefinition datdef1, DataDefinition datdef2) -> DataDefinition"""
    return _ilwisobjects.DataDefinition_merge(datdef1, datdef2)

class ColumnDefinition(_object):
    """Proxy of C++ pythonapi::ColumnDefinition class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ColumnDefinition, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ColumnDefinition, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(pythonapi::ColumnDefinition self) -> ColumnDefinition
        __init__(pythonapi::ColumnDefinition self, ColumnDefinition coldef, quint32 index) -> ColumnDefinition
        __init__(pythonapi::ColumnDefinition self, std::string const & name, DataDefinition datdef, quint64 colindex) -> ColumnDefinition
        __init__(pythonapi::ColumnDefinition self, ColumnDefinition coldef) -> ColumnDefinition
        __init__(pythonapi::ColumnDefinition self, std::string const & nm, Domain dom, quint64 colindex) -> ColumnDefinition
        """
        this = _ilwisobjects.new_ColumnDefinition(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _ilwisobjects.delete_ColumnDefinition
    __del__ = lambda self: None

    def datadef(self):
        """datadef(ColumnDefinition self) -> DataDefinition"""
        return _ilwisobjects.ColumnDefinition_datadef(self)


    def columnindex(self, *args):
        """
        columnindex(ColumnDefinition self, quint64 idx)
        columnindex(ColumnDefinition self) -> quint64
        """
        return _ilwisobjects.ColumnDefinition_columnindex(self, *args)


    def isChanged(self):
        """isChanged(ColumnDefinition self) -> bool"""
        return _ilwisobjects.ColumnDefinition_isChanged(self)


    def changed(self, yesno):
        """changed(ColumnDefinition self, bool yesno)"""
        return _ilwisobjects.ColumnDefinition_changed(self, yesno)


    def __str__(self):
        """__str__(ColumnDefinition self) -> std::string"""
        return _ilwisobjects.ColumnDefinition___str__(self)


    def __bool__(self):
        """__bool__(ColumnDefinition self) -> bool"""
        return _ilwisobjects.ColumnDefinition___bool__(self)

ColumnDefinition_swigregister = _ilwisobjects.ColumnDefinition_swigregister
ColumnDefinition_swigregister(ColumnDefinition)

class DomainItem(Object):
    """Proxy of C++ pythonapi::DomainItem class."""

    __swig_setmethods__ = {}
    for _s in [Object]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DomainItem, name, value)
    __swig_getmethods__ = {}
    for _s in [Object]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, DomainItem, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(pythonapi::DomainItem self) -> DomainItem
        __init__(pythonapi::DomainItem self, Ilwis::DomainItem * ilwItem) -> DomainItem
        """
        this = _ilwisobjects.new_DomainItem(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __bool__(self):
        """__bool__(DomainItem self) -> bool"""
        return _ilwisobjects.DomainItem___bool__(self)


    def __str__(self):
        """__str__(DomainItem self) -> std::string"""
        return _ilwisobjects.DomainItem___str__(self)


    def ilwisType(self):
        """ilwisType(DomainItem self) -> IlwisTypes"""
        return _ilwisobjects.DomainItem_ilwisType(self)


    def clone(self):
        """clone(DomainItem self) -> DomainItem"""
        return _ilwisobjects.DomainItem_clone(self)


    def raw(self, *args):
        """
        raw(DomainItem self, quint32 rw)
        raw(DomainItem self) -> quint32
        """
        return _ilwisobjects.DomainItem_raw(self, *args)

    __swig_destroy__ = _ilwisobjects.delete_DomainItem
    __del__ = lambda self: None
DomainItem_swigregister = _ilwisobjects.DomainItem_swigregister
DomainItem_swigregister(DomainItem)

class IndexedIdentifier(DomainItem):
    """Proxy of C++ pythonapi::IndexedIdentifier class."""

    __swig_setmethods__ = {}
    for _s in [DomainItem]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, IndexedIdentifier, name, value)
    __swig_getmethods__ = {}
    for _s in [DomainItem]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, IndexedIdentifier, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(pythonapi::IndexedIdentifier self) -> IndexedIdentifier
        __init__(pythonapi::IndexedIdentifier self, std::string const & label, quint32 ind=0, qint32 cnt) -> IndexedIdentifier
        __init__(pythonapi::IndexedIdentifier self, std::string const & label, quint32 ind=0) -> IndexedIdentifier
        __init__(pythonapi::IndexedIdentifier self, std::string const & label) -> IndexedIdentifier
        __init__(pythonapi::IndexedIdentifier self, Ilwis::DomainItem * ilwItem) -> IndexedIdentifier
        """
        this = _ilwisobjects.new_IndexedIdentifier(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def prefix(self):
        """prefix(IndexedIdentifier self) -> std::string"""
        return _ilwisobjects.IndexedIdentifier_prefix(self)


    def setPrefix(self, name):
        """setPrefix(IndexedIdentifier self, std::string const & name)"""
        return _ilwisobjects.IndexedIdentifier_setPrefix(self, name)


    def __eq__(self, item):
        """__eq__(IndexedIdentifier self, IndexedIdentifier item) -> bool"""
        return _ilwisobjects.IndexedIdentifier___eq__(self, item)

    __swig_destroy__ = _ilwisobjects.delete_IndexedIdentifier
    __del__ = lambda self: None
IndexedIdentifier_swigregister = _ilwisobjects.IndexedIdentifier_swigregister
IndexedIdentifier_swigregister(IndexedIdentifier)

class NamedIdentifier(DomainItem):
    """Proxy of C++ pythonapi::NamedIdentifier class."""

    __swig_setmethods__ = {}
    for _s in [DomainItem]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, NamedIdentifier, name, value)
    __swig_getmethods__ = {}
    for _s in [DomainItem]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, NamedIdentifier, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(pythonapi::NamedIdentifier self) -> NamedIdentifier
        __init__(pythonapi::NamedIdentifier self, std::string const & name, quint32 rawvalue) -> NamedIdentifier
        __init__(pythonapi::NamedIdentifier self, std::string const & name) -> NamedIdentifier
        __init__(pythonapi::NamedIdentifier self, Ilwis::DomainItem * ilwItem) -> NamedIdentifier
        """
        this = _ilwisobjects.new_NamedIdentifier(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def setName(self, name):
        """setName(NamedIdentifier self, std::string const & name)"""
        return _ilwisobjects.NamedIdentifier_setName(self, name)


    def __eq__(self, item):
        """__eq__(NamedIdentifier self, NamedIdentifier item) -> bool"""
        return _ilwisobjects.NamedIdentifier___eq__(self, item)

    __swig_destroy__ = _ilwisobjects.delete_NamedIdentifier
    __del__ = lambda self: None
NamedIdentifier_swigregister = _ilwisobjects.NamedIdentifier_swigregister
NamedIdentifier_swigregister(NamedIdentifier)

class ThematicItem(NamedIdentifier):
    """Proxy of C++ pythonapi::ThematicItem class."""

    __swig_setmethods__ = {}
    for _s in [NamedIdentifier]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ThematicItem, name, value)
    __swig_getmethods__ = {}
    for _s in [NamedIdentifier]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ThematicItem, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(pythonapi::ThematicItem self) -> ThematicItem
        __init__(pythonapi::ThematicItem self, Ilwis::DomainItem * ilwItem) -> ThematicItem
        __init__(pythonapi::ThematicItem self, PyObject * tup, quint32 rawValue) -> ThematicItem
        __init__(pythonapi::ThematicItem self, PyObject * tup) -> ThematicItem
        """
        this = _ilwisobjects.new_ThematicItem(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def description(self, *args):
        """
        description(ThematicItem self) -> std::string
        description(ThematicItem self, std::string & descr)
        """
        return _ilwisobjects.ThematicItem_description(self, *args)


    def code(self, *args):
        """
        code(ThematicItem self) -> std::string
        code(ThematicItem self, std::string & code)
        """
        return _ilwisobjects.ThematicItem_code(self, *args)

    __swig_destroy__ = _ilwisobjects.delete_ThematicItem
    __del__ = lambda self: None
ThematicItem_swigregister = _ilwisobjects.ThematicItem_swigregister
ThematicItem_swigregister(ThematicItem)

class Interval(DomainItem):
    """Proxy of C++ pythonapi::Interval class."""

    __swig_setmethods__ = {}
    for _s in [DomainItem]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Interval, name, value)
    __swig_getmethods__ = {}
    for _s in [DomainItem]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Interval, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(pythonapi::Interval self) -> Interval
        __init__(pythonapi::Interval self, std::string const & label, NumericRange nr) -> Interval
        """
        this = _ilwisobjects.new_Interval(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def isOrdered(self):
        """isOrdered(Interval self) -> bool"""
        return _ilwisobjects.Interval_isOrdered(self)


    def range(self, *args):
        """
        range(Interval self) -> NumericRange
        range(Interval self, NumericRange nr)
        """
        return _ilwisobjects.Interval_range(self, *args)

    __swig_destroy__ = _ilwisobjects.delete_Interval
    __del__ = lambda self: None
Interval_swigregister = _ilwisobjects.Interval_swigregister
Interval_swigregister(Interval)

class VertexIterator(_object):
    """Proxy of C++ pythonapi::VertexIterator class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, VertexIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, VertexIterator, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(pythonapi::VertexIterator self) -> VertexIterator
        __init__(pythonapi::VertexIterator self, Geometry geom) -> VertexIterator
        __init__(pythonapi::VertexIterator self, std::string const & wkt) -> VertexIterator
        """
        this = _ilwisobjects.new_VertexIterator(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _ilwisobjects.delete_VertexIterator
    __del__ = lambda self: None

    def __bool__(self):
        """__bool__(VertexIterator self) -> bool"""
        return _ilwisobjects.VertexIterator___bool__(self)


    def __str__(self):
        """__str__(VertexIterator self) -> std::string"""
        return _ilwisobjects.VertexIterator___str__(self)


    def __iter__(self):
        """__iter__(VertexIterator self) -> VertexIterator"""
        return _ilwisobjects.VertexIterator___iter__(self)


    def __next__(self):
        """__next__(VertexIterator self) -> Coordinate"""
        return _ilwisobjects.VertexIterator___next__(self)


    def __add__(self, n):
        """__add__(VertexIterator self, int n) -> VertexIterator"""
        return _ilwisobjects.VertexIterator___add__(self, n)


    def __radd__(self, n):
        """__radd__(VertexIterator self, int n) -> VertexIterator"""
        return _ilwisobjects.VertexIterator___radd__(self, n)


    def __iadd__(self, n):
        """__iadd__(VertexIterator self, int n) -> VertexIterator"""
        return _ilwisobjects.VertexIterator___iadd__(self, n)


    def __sub__(self, n):
        """__sub__(VertexIterator self, int n) -> VertexIterator"""
        return _ilwisobjects.VertexIterator___sub__(self, n)


    def __rsub__(self, n):
        """__rsub__(VertexIterator self, int n) -> VertexIterator"""
        return _ilwisobjects.VertexIterator___rsub__(self, n)


    def __isub__(self, n):
        """__isub__(VertexIterator self, int n) -> VertexIterator"""
        return _ilwisobjects.VertexIterator___isub__(self, n)


    def __getitem__(self, linearpos):
        """__getitem__(VertexIterator self, quint32 linearpos) -> Coordinate"""
        return _ilwisobjects.VertexIterator___getitem__(self, linearpos)


    def current(self):
        """current(VertexIterator self) -> Coordinate"""
        return _ilwisobjects.VertexIterator_current(self)


    def __eq__(self, other):
        """__eq__(VertexIterator self, VertexIterator other) -> bool"""
        return _ilwisobjects.VertexIterator___eq__(self, other)


    def __ne__(self, other):
        """__ne__(VertexIterator self, VertexIterator other) -> bool"""
        return _ilwisobjects.VertexIterator___ne__(self, other)


    def __lt__(self, other):
        """__lt__(VertexIterator self, VertexIterator other) -> bool"""
        return _ilwisobjects.VertexIterator___lt__(self, other)


    def __gt__(self, other):
        """__gt__(VertexIterator self, VertexIterator other) -> bool"""
        return _ilwisobjects.VertexIterator___gt__(self, other)


    def __le__(self, other):
        """__le__(VertexIterator self, VertexIterator other) -> bool"""
        return _ilwisobjects.VertexIterator___le__(self, other)


    def __ge__(self, other):
        """__ge__(VertexIterator self, VertexIterator other) -> bool"""
        return _ilwisobjects.VertexIterator___ge__(self, other)


    def nextSubGeometry(self):
        """nextSubGeometry(VertexIterator self) -> bool"""
        return _ilwisobjects.VertexIterator_nextSubGeometry(self)


    def isInteriorVertex(self):
        """isInteriorVertex(VertexIterator self) -> bool"""
        return _ilwisobjects.VertexIterator_isInteriorVertex(self)


    def begin(self):
        """begin(VertexIterator self) -> VertexIterator"""
        return _ilwisobjects.VertexIterator_begin(self)


    def end(self):
        """end(VertexIterator self) -> VertexIterator"""
        return _ilwisobjects.VertexIterator_end(self)

VertexIterator_swigregister = _ilwisobjects.VertexIterator_swigregister
VertexIterator_swigregister(VertexIterator)


class ReadOnly(type):
  @property
  def sUNDEF(cls):
    return "?"
  @property
  def shUNDEF(cls):
    return 32767
  @property
  def iUNDEF(cls):
    return 2147483645
  @property
  def rUNDEF(cls):
    return -1e+308
  @property
  def flUNDEF(cls):
    return 1e38
  @property
  def i64UNDEF(cls):
    return 9223372036854775808


class Const(metaclass=ReadOnly):pass

# This file is compatible with both classic and new-style classes.


